/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.mp.api.impl;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.mp.api.WxMpOcrService;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.bean.ocr.WxMpOcrBankCardResult;
import me.chanjar.weixin.mp.bean.ocr.WxMpOcrBizLicenseResult;
import me.chanjar.weixin.mp.bean.ocr.WxMpOcrCommResult;
import me.chanjar.weixin.mp.bean.ocr.WxMpOcrDrivingLicenseResult;
import me.chanjar.weixin.mp.bean.ocr.WxMpOcrDrivingResult;
import me.chanjar.weixin.mp.bean.ocr.WxMpOcrIdCardResult;
import me.chanjar.weixin.mp.enums.WxMpApiUrl;
import me.chanjar.weixin.mp.util.requestexecuter.ocr.OcrDiscernRequestExecutor;

public class WxMpOcrServiceImpl
implements WxMpOcrService {
    private final WxMpService wxMpService;

    @Override
    public WxMpOcrIdCardResult idCard(String imgUrl) throws WxErrorException {
        try {
            imgUrl = URLEncoder.encode(imgUrl, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        String result = this.wxMpService.get(String.format(WxMpApiUrl.Ocr.IDCARD.getUrl(this.wxMpService.getWxMpConfigStorage()), imgUrl), null);
        return WxMpOcrIdCardResult.fromJson(result);
    }

    @Override
    public WxMpOcrIdCardResult idCard(File imgFile) throws WxErrorException {
        String result = this.wxMpService.execute(OcrDiscernRequestExecutor.create(this.wxMpService.getRequestHttp()), WxMpApiUrl.Ocr.FILEIDCARD.getUrl(this.wxMpService.getWxMpConfigStorage()), imgFile);
        return WxMpOcrIdCardResult.fromJson(result);
    }

    @Override
    public WxMpOcrBankCardResult bankCard(String imgUrl) throws WxErrorException {
        try {
            imgUrl = URLEncoder.encode(imgUrl, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        String result = this.wxMpService.get(String.format(WxMpApiUrl.Ocr.BANK_CARD.getUrl(this.wxMpService.getWxMpConfigStorage()), imgUrl), null);
        return WxMpOcrBankCardResult.fromJson(result);
    }

    @Override
    public WxMpOcrBankCardResult bankCard(File imgFile) throws WxErrorException {
        String result = this.wxMpService.execute(OcrDiscernRequestExecutor.create(this.wxMpService.getRequestHttp()), WxMpApiUrl.Ocr.FILE_BANK_CARD.getUrl(this.wxMpService.getWxMpConfigStorage()), imgFile);
        return WxMpOcrBankCardResult.fromJson(result);
    }

    @Override
    public WxMpOcrDrivingResult driving(String imgUrl) throws WxErrorException {
        try {
            imgUrl = URLEncoder.encode(imgUrl, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        String result = this.wxMpService.get(String.format(WxMpApiUrl.Ocr.DRIVING.getUrl(this.wxMpService.getWxMpConfigStorage()), imgUrl), null);
        return WxMpOcrDrivingResult.fromJson(result);
    }

    @Override
    public WxMpOcrDrivingResult driving(File imgFile) throws WxErrorException {
        String result = this.wxMpService.execute(OcrDiscernRequestExecutor.create(this.wxMpService.getRequestHttp()), WxMpApiUrl.Ocr.FILE_DRIVING.getUrl(this.wxMpService.getWxMpConfigStorage()), imgFile);
        return WxMpOcrDrivingResult.fromJson(result);
    }

    @Override
    public WxMpOcrDrivingLicenseResult drivingLicense(String imgUrl) throws WxErrorException {
        try {
            imgUrl = URLEncoder.encode(imgUrl, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        String result = this.wxMpService.get(String.format(WxMpApiUrl.Ocr.DRIVING_LICENSE.getUrl(this.wxMpService.getWxMpConfigStorage()), imgUrl), null);
        return WxMpOcrDrivingLicenseResult.fromJson(result);
    }

    @Override
    public WxMpOcrDrivingLicenseResult drivingLicense(File imgFile) throws WxErrorException {
        String result = this.wxMpService.execute(OcrDiscernRequestExecutor.create(this.wxMpService.getRequestHttp()), WxMpApiUrl.Ocr.FILE_DRIVING_LICENSE.getUrl(this.wxMpService.getWxMpConfigStorage()), imgFile);
        return WxMpOcrDrivingLicenseResult.fromJson(result);
    }

    @Override
    public WxMpOcrBizLicenseResult bizLicense(String imgUrl) throws WxErrorException {
        try {
            imgUrl = URLEncoder.encode(imgUrl, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        String result = this.wxMpService.get(String.format(WxMpApiUrl.Ocr.BIZ_LICENSE.getUrl(this.wxMpService.getWxMpConfigStorage()), imgUrl), null);
        return WxMpOcrBizLicenseResult.fromJson(result);
    }

    @Override
    public WxMpOcrBizLicenseResult bizLicense(File imgFile) throws WxErrorException {
        String result = this.wxMpService.execute(OcrDiscernRequestExecutor.create(this.wxMpService.getRequestHttp()), WxMpApiUrl.Ocr.FILE_BIZ_LICENSE.getUrl(this.wxMpService.getWxMpConfigStorage()), imgFile);
        return WxMpOcrBizLicenseResult.fromJson(result);
    }

    @Override
    public WxMpOcrCommResult comm(String imgUrl) throws WxErrorException {
        try {
            imgUrl = URLEncoder.encode(imgUrl, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        String result = this.wxMpService.get(String.format(WxMpApiUrl.Ocr.COMM.getUrl(this.wxMpService.getWxMpConfigStorage()), imgUrl), null);
        return WxMpOcrCommResult.fromJson(result);
    }

    @Override
    public WxMpOcrCommResult comm(File imgFile) throws WxErrorException {
        String result = this.wxMpService.execute(OcrDiscernRequestExecutor.create(this.wxMpService.getRequestHttp()), WxMpApiUrl.Ocr.FILE_COMM.getUrl(this.wxMpService.getWxMpConfigStorage()), imgFile);
        return WxMpOcrCommResult.fromJson(result);
    }

    public WxMpOcrServiceImpl(WxMpService wxMpService) {
        this.wxMpService = wxMpService;
    }
}

