/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.mp.api.impl;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.util.json.WxGsonBuilder;
import me.chanjar.weixin.mp.api.WxMpMemberCardService;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.bean.card.AdvancedInfo;
import me.chanjar.weixin.mp.bean.card.BaseInfo;
import me.chanjar.weixin.mp.bean.card.CardUpdateResult;
import me.chanjar.weixin.mp.bean.card.DateInfo;
import me.chanjar.weixin.mp.bean.card.WxMpCardCreateResult;
import me.chanjar.weixin.mp.bean.card.enums.BusinessServiceType;
import me.chanjar.weixin.mp.bean.card.enums.CardColor;
import me.chanjar.weixin.mp.bean.card.enums.DateInfoType;
import me.chanjar.weixin.mp.bean.card.membercard.ActivatePluginParam;
import me.chanjar.weixin.mp.bean.card.membercard.ActivatePluginParamResult;
import me.chanjar.weixin.mp.bean.card.membercard.MemberCard;
import me.chanjar.weixin.mp.bean.card.membercard.MemberCardActivateUserFormRequest;
import me.chanjar.weixin.mp.bean.card.membercard.MemberCardActivateUserFormResult;
import me.chanjar.weixin.mp.bean.card.membercard.MemberCardCreateRequest;
import me.chanjar.weixin.mp.bean.card.membercard.MemberCardUpdateRequest;
import me.chanjar.weixin.mp.bean.card.membercard.WxMpMemberCardActivateTempInfoResult;
import me.chanjar.weixin.mp.bean.card.membercard.WxMpMemberCardActivatedMessage;
import me.chanjar.weixin.mp.bean.card.membercard.WxMpMemberCardCreateMessage;
import me.chanjar.weixin.mp.bean.card.membercard.WxMpMemberCardUpdateMessage;
import me.chanjar.weixin.mp.bean.card.membercard.WxMpMemberCardUpdateResult;
import me.chanjar.weixin.mp.bean.card.membercard.WxMpMemberCardUserInfoResult;
import me.chanjar.weixin.mp.enums.WxMpApiUrl;
import me.chanjar.weixin.mp.util.json.WxMpGsonBuilder;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WxMpMemberCardServiceImpl
implements WxMpMemberCardService {
    private static final Logger log = LoggerFactory.getLogger(WxMpMemberCardServiceImpl.class);
    private final WxMpService wxMpService;
    private static final Gson GSON = WxMpGsonBuilder.create();

    @Override
    public WxMpService getWxMpService() {
        return this.wxMpService;
    }

    @Override
    public WxMpCardCreateResult createMemberCard(String createJson) throws WxErrorException {
        WxMpMemberCardCreateMessage createMessage = (WxMpMemberCardCreateMessage)WxGsonBuilder.create().fromJson(createJson, WxMpMemberCardCreateMessage.class);
        return this.createMemberCard(createMessage);
    }

    @Override
    public WxMpCardCreateResult createMemberCard(WxMpMemberCardCreateMessage createMessageMessage) throws WxErrorException {
        WxMpCardCreateResult validResult = this.validCheck(createMessageMessage);
        if (!validResult.isSuccess()) {
            return validResult;
        }
        String response = this.wxMpService.post(WxMpApiUrl.MemberCard.MEMBER_CARD_CREATE, GSON.toJson((Object)createMessageMessage));
        return WxMpCardCreateResult.fromJson(response);
    }

    private WxMpCardCreateResult validCheck(WxMpMemberCardCreateMessage createMessageMessage) {
        if (createMessageMessage == null) {
            return WxMpCardCreateResult.failure("\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        MemberCardCreateRequest cardCreateRequest = createMessageMessage.getCardCreateRequest();
        if (cardCreateRequest == null) {
            return WxMpCardCreateResult.failure("\u4f1a\u5458\u5361\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String cardType = cardCreateRequest.getCardType();
        if (!StringUtils.equals((CharSequence)cardType, (CharSequence)"MEMBER_CARD")) {
            return WxMpCardCreateResult.failure("\u5361\u5238\u7c7b\u578b\u5fc5\u987b\u7b49\u4e8eMEMBER_CARD");
        }
        MemberCard memberCard = cardCreateRequest.getMemberCard();
        if (StringUtils.isEmpty((CharSequence)memberCard.getPrerogative())) {
            return WxMpCardCreateResult.failure("\u4f1a\u5458\u5361\u7279\u6743\u8bf4\u660e\u4e0d\u80fd\u4e3a\u7a7a:prerogative");
        }
        if (!memberCard.isAutoActivate() && !memberCard.isWxActivate() && StringUtils.isEmpty((CharSequence)memberCard.getActivateUrl())) {
            return WxMpCardCreateResult.failure("\u4f1a\u5458\u5361\u6fc0\u6d3b\u65b9\u5f0f\u4e3a\u63a5\u53e3\u6fc0\u6d3b\uff0cactivate_url\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BaseInfo baseInfo = memberCard.getBaseInfo();
        if (baseInfo == null) {
            return WxMpCardCreateResult.failure("\u4f1a\u5458\u5361\u57fa\u672c\u4fe1\u606f\u5bf9\u8c61base_info\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)baseInfo.getLogoUrl())) {
            return WxMpCardCreateResult.failure("\u4f1a\u5458\u5361\u57fa\u672c\u4fe1\u606f\u7684\u5546\u6237logo:logo_url\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)baseInfo.getCodeType())) {
            return WxMpCardCreateResult.failure("\u4f1a\u5458\u5361\u57fa\u672c\u4fe1\u606f\u7684\u6761\u7801\u7c7b\u578b:code_type\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)baseInfo.getBrandName())) {
            return WxMpCardCreateResult.failure("\u4f1a\u5458\u5361\u57fa\u672c\u4fe1\u606f\u7684\u5546\u6237\u540d\u5b57:brand_name\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.length((CharSequence)baseInfo.getBrandName()) > 12) {
            return WxMpCardCreateResult.failure("\u4f1a\u5458\u5361\u57fa\u672c\u4fe1\u606f\u7684\u5546\u6237\u540d\u5b57:brand_name\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e12\u4e2a\u6c49\u5b57");
        }
        if (StringUtils.isBlank((CharSequence)baseInfo.getTitle())) {
            return WxMpCardCreateResult.failure("\u4f1a\u5458\u5361\u57fa\u672c\u4fe1\u606f\u7684\u5361\u5238\u540d\u79f0:title\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.length((CharSequence)baseInfo.getTitle()) > 9) {
            return WxMpCardCreateResult.failure("\u4f1a\u5458\u5361\u57fa\u672c\u4fe1\u606f\u7684\u5361\u5238\u540d\u79f0:title\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e9\u4e2a\u6c49\u5b57");
        }
        if (StringUtils.isBlank((CharSequence)baseInfo.getColor())) {
            return WxMpCardCreateResult.failure("\u4f1a\u5458\u5361\u57fa\u672c\u4fe1\u606f\u7684\u5361\u989c\u8272:color\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CardColor cardColor = null;
        try {
            cardColor = CardColor.valueOf(baseInfo.getColor());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (cardColor == null) {
            return WxMpCardCreateResult.failure("\u4f1a\u5458\u5361\u57fa\u672c\u4fe1\u606f\u7684\u5361\u989c\u8272:" + baseInfo.getColor() + "\u4e0d\u652f\u6301");
        }
        if (StringUtils.isBlank((CharSequence)baseInfo.getNotice())) {
            return WxMpCardCreateResult.failure("\u4f1a\u5458\u5361\u57fa\u672c\u4fe1\u606f\u7684\u4f7f\u7528\u63d0\u9192:notice\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)baseInfo.getDescription())) {
            return WxMpCardCreateResult.failure("\u4f1a\u5458\u5361\u57fa\u672c\u4fe1\u606f\u7684\u4f7f\u7528\u8bf4\u660e:description\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (baseInfo.getSku() == null) {
            return WxMpCardCreateResult.failure("\u4f1a\u5458\u5361\u57fa\u672c\u4fe1\u606f\u7684\u5546\u54c1\u4fe1\u606f:sku\u4e0d\u80fd\u4e3a\u7a7a");
        }
        DateInfo dateInfo = baseInfo.getDateInfo();
        if (dateInfo == null) {
            return WxMpCardCreateResult.failure("\u4f1a\u5458\u5361\u57fa\u672c\u4fe1\u606f\u7684\u4f7f\u7528\u65e5\u671f:date_info\u4e0d\u80fd\u4e3a\u7a7a");
        }
        DateInfoType dateInfoType = null;
        try {
            dateInfoType = DateInfoType.valueOf(dateInfo.getType());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (dateInfoType == null) {
            return WxMpCardCreateResult.failure("\u4f1a\u5458\u5361\u57fa\u672c\u4fe1\u606f\u7684\u4f7f\u7528\u65e5\u671f\u7c7b\u578b:" + dateInfo.getType() + "\u4e0d\u5408\u6cd5");
        }
        if (dateInfoType == DateInfoType.DATE_TYPE_FIX_TERM && (dateInfo.getFixedTerm() == null || dateInfo.getFixedBeginTerm() == null)) {
            return WxMpCardCreateResult.failure(String.format("\u4f1a\u5458\u5361\u57fa\u672c\u4fe1\u606f\u7684\u4f7f\u7528\u65e5\u671f\u4e3a:%s\uff0cfixedTerm\u548cfixedBeginTerm\u4e0d\u80fd\u4e3a\u7a7a", dateInfoType.getDescription()));
        }
        if (dateInfoType == DateInfoType.DATE_TYPE_FIX_TIME_RANGE && (dateInfo.getBeginTimestamp() == null || dateInfo.getEndTimestamp() == null)) {
            return WxMpCardCreateResult.failure(String.format("\u4f1a\u5458\u5361\u57fa\u672c\u4fe1\u606f\u7684\u4f7f\u7528\u65e5\u671f\u4e3a:%s\uff0cbeginTimestamp \u548c endTimestamp \u4e0d\u80fd\u4e3a\u7a7a", dateInfoType.getDescription()));
        }
        if (dateInfoType == DateInfoType.DATE_TYPE_FIX_TIME_RANGE && (dateInfo.getBeginTimestamp() * 1000L < System.currentTimeMillis() || dateInfo.getEndTimestamp() * 1000L < System.currentTimeMillis() || dateInfo.getBeginTimestamp() > dateInfo.getEndTimestamp())) {
            return WxMpCardCreateResult.failure(String.format("\u4f1a\u5458\u5361\u57fa\u672c\u4fe1\u606f\u7684\u4f7f\u7528\u65e5\u671f\u4e3a:%s\uff0cbeginTimestamp\u548cendTimestamp\u7684\u503c\u4e0d\u5408\u6cd5\uff0c\u8bf7\u68c0\u67e5", dateInfoType.getDescription()));
        }
        if (!baseInfo.isUseAllLocations() && baseInfo.getLocationIdList().isEmpty()) {
            return WxMpCardCreateResult.failure("\u4f1a\u5458\u5361\u57fa\u672c\u4fe1\u606f\u7684\u95e8\u5e97\u4f7f\u7528\u8303\u56f4\u9009\u62e9\u6307\u5b9a\u95e8\u5e97,\u95e8\u5e97\u5217\u8868:locationIdList\u4e0d\u80fd\u4e3a\u7a7a");
        }
        AdvancedInfo advancedInfo = memberCard.getAdvancedInfo();
        if (advancedInfo != null && advancedInfo.getBusinessServiceList() != null) {
            for (String bs : advancedInfo.getBusinessServiceList()) {
                try {
                    BusinessServiceType.valueOf(bs);
                }
                catch (IllegalArgumentException ex) {
                    return WxMpCardCreateResult.failure("\u4f1a\u5458\u5361\u9ad8\u7ea7\u4fe1\u606f\u7684\u5546\u6237\u670d\u52a1:" + bs + " \u4e0d\u5408\u6cd5");
                }
            }
        }
        return WxMpCardCreateResult.success();
    }

    @Override
    public String activateMemberCard(WxMpMemberCardActivatedMessage activatedMessage) throws WxErrorException {
        return this.wxMpService.post(WxMpApiUrl.MemberCard.MEMBER_CARD_ACTIVATE, GSON.toJson((Object)activatedMessage));
    }

    @Override
    public WxMpMemberCardUserInfoResult getUserInfo(String cardId, String code) throws WxErrorException {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("card_id", cardId);
        jsonObject.addProperty("code", code);
        String responseContent = this.getWxMpService().post(WxMpApiUrl.MemberCard.MEMBER_CARD_USER_INFO_GET, jsonObject.toString());
        log.debug("{}", (Object)responseContent);
        JsonElement tmpJsonElement = new JsonParser().parse(responseContent);
        return (WxMpMemberCardUserInfoResult)WxMpGsonBuilder.create().fromJson(tmpJsonElement, new TypeToken<WxMpMemberCardUserInfoResult>(){}.getType());
    }

    @Override
    public WxMpMemberCardUpdateResult updateUserMemberCard(WxMpMemberCardUpdateMessage updateUserMessage) throws WxErrorException {
        String responseContent = this.getWxMpService().post(WxMpApiUrl.MemberCard.MEMBER_CARD_UPDATE_USER, GSON.toJson((Object)updateUserMessage));
        JsonElement tmpJsonElement = new JsonParser().parse(responseContent);
        return (WxMpMemberCardUpdateResult)WxMpGsonBuilder.create().fromJson(tmpJsonElement, new TypeToken<WxMpMemberCardUpdateResult>(){}.getType());
    }

    @Override
    public MemberCardActivateUserFormResult setActivateUserForm(MemberCardActivateUserFormRequest userFormRequest) throws WxErrorException {
        String responseContent = this.getWxMpService().post(WxMpApiUrl.MemberCard.MEMBER_CARD_ACTIVATE_USER_FORM, GSON.toJson((Object)userFormRequest));
        return MemberCardActivateUserFormResult.fromJson(responseContent);
    }

    @Override
    public ActivatePluginParam getActivatePluginParam(String cardId, String outStr) throws WxErrorException {
        String url = this.getActivatePluginUrl(cardId, outStr);
        try {
            String decodedUrl = URLDecoder.decode(url, "UTF-8");
            Map<String, String> resultMap = WxMpMemberCardServiceImpl.parseRequestUrl(decodedUrl);
            ActivatePluginParam activatePluginParam = new ActivatePluginParam();
            activatePluginParam.setEncryptCardId(resultMap.get("encrypt_card_id"));
            activatePluginParam.setOuterStr(resultMap.get("outer_str"));
            activatePluginParam.setBiz(resultMap.get("biz") + "==");
            return activatePluginParam;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String getActivatePluginUrl(String cardId, String outStr) throws WxErrorException {
        JsonObject params = new JsonObject();
        params.addProperty("card_id", cardId);
        params.addProperty("outer_str", outStr);
        String response = this.wxMpService.post(WxMpApiUrl.MemberCard.MEMBER_CARD_ACTIVATE_URL, GSON.toJson((JsonElement)params));
        ActivatePluginParamResult result = (ActivatePluginParamResult)GSON.fromJson(response, ActivatePluginParamResult.class);
        return result.getUrl();
    }

    @Override
    public CardUpdateResult updateCardInfo(MemberCardUpdateRequest memberCardUpdateRequest) throws WxErrorException {
        String response = this.wxMpService.post(WxMpApiUrl.MemberCard.MEMBER_CARD_UPDATE, GSON.toJson((Object)memberCardUpdateRequest));
        return (CardUpdateResult)GSON.fromJson(response, CardUpdateResult.class);
    }

    @Override
    public WxMpMemberCardActivateTempInfoResult getActivateTempInfo(String activateTicket) throws WxErrorException {
        JsonObject params = new JsonObject();
        params.addProperty("activate_ticket", activateTicket);
        String response = this.wxMpService.post(WxMpApiUrl.MemberCard.MEMBER_CARD_ACTIVATE_TEMP_INFO, GSON.toJson((JsonElement)params));
        return (WxMpMemberCardActivateTempInfoResult)GSON.fromJson(response, WxMpMemberCardActivateTempInfoResult.class);
    }

    private static String truncateUrlPage(String strURL) {
        String strAllParam = null;
        String[] arrSplit = strURL.split("[?]");
        if (strURL.length() > 1 && arrSplit.length > 1 && arrSplit[1] != null) {
            strAllParam = arrSplit[1];
        }
        return strAllParam;
    }

    private static Map<String, String> parseRequestUrl(String url) {
        String[] arrSplit;
        HashMap<String, String> mapRequest = new HashMap<String, String>(16);
        String strUrlParam = WxMpMemberCardServiceImpl.truncateUrlPage(url);
        if (strUrlParam == null) {
            return mapRequest;
        }
        for (String strSplit : arrSplit = strUrlParam.split("[&]")) {
            String[] arrSplitEqual = strSplit.split("[=]");
            if (arrSplitEqual.length > 1) {
                mapRequest.put(arrSplitEqual[0], arrSplitEqual[1]);
                continue;
            }
            if ("".equals(arrSplitEqual[0])) continue;
            mapRequest.put(arrSplitEqual[0], "");
        }
        return mapRequest;
    }

    public WxMpMemberCardServiceImpl(WxMpService wxMpService) {
        this.wxMpService = wxMpService;
    }
}

