/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.mp.config.impl;

import java.util.concurrent.ConcurrentHashMap;
import me.chanjar.weixin.common.bean.WxAccessToken;
import me.chanjar.weixin.mp.config.impl.WxMpDefaultConfigImpl;

public class WxMpMapConfigImpl
extends WxMpDefaultConfigImpl {
    private static final long serialVersionUID = 5311395137835650104L;
    private static final ConcurrentHashMap<String, String> CONCURRENT_HASH_MAP = new ConcurrentHashMap(1);
    private static final String MAP_KEY = "access_token";

    @Override
    public String getAccessToken() {
        return CONCURRENT_HASH_MAP.get(MAP_KEY);
    }

    @Override
    public void setAccessToken(String accessToken) {
        CONCURRENT_HASH_MAP.put(MAP_KEY, accessToken);
    }

    @Override
    public void updateAccessToken(WxAccessToken accessToken) {
        this.updateAccessToken(accessToken.getAccessToken(), accessToken.getExpiresIn());
    }

    @Override
    public void updateAccessToken(String accessToken, int expiresInSeconds) {
        CONCURRENT_HASH_MAP.put(MAP_KEY, accessToken);
        this.expiresTime = System.currentTimeMillis() + (long)(expiresInSeconds - 200) * 1000L;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WxMpMapConfigImpl)) {
            return false;
        }
        WxMpMapConfigImpl other = (WxMpMapConfigImpl)o;
        return other.canEqual(this);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof WxMpMapConfigImpl;
    }

    @Override
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    @Override
    public String toString() {
        return "WxMpMapConfigImpl()";
    }
}

