/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.mp.api.impl;

import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.util.json.GsonHelper;
import me.chanjar.weixin.common.util.json.GsonParser;
import me.chanjar.weixin.mp.api.WxMpFreePublishService;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.bean.freepublish.WxMpFreePublishInfo;
import me.chanjar.weixin.mp.bean.freepublish.WxMpFreePublishList;
import me.chanjar.weixin.mp.bean.freepublish.WxMpFreePublishStatus;
import me.chanjar.weixin.mp.enums.WxMpApiUrl;

public class WxMpFreePublishServiceImpl
implements WxMpFreePublishService {
    private static final String MEDIA_ID = "media_id";
    private static final String PUBLISH_ID = "publish_id";
    private static final String ARTICLE_ID = "article_id";
    private static final String ERRCODE_SUCCESS = "0";
    private final WxMpService mpService;

    @Override
    public String submit(String mediaId) throws WxErrorException {
        String json = this.mpService.post((WxMpApiUrl)WxMpApiUrl.FreePublish.SUBMIT, GsonHelper.buildJsonObject((Object[])new Object[]{MEDIA_ID, mediaId}));
        return GsonParser.parse((String)json).get(PUBLISH_ID).toString();
    }

    @Override
    public WxMpFreePublishStatus getPushStatus(String publishId) throws WxErrorException {
        return WxMpFreePublishStatus.fromJson(this.mpService.post((WxMpApiUrl)WxMpApiUrl.FreePublish.GET_PUSH_STATUS, GsonHelper.buildJsonObject((Object[])new Object[]{PUBLISH_ID, publishId})));
    }

    @Override
    public Boolean deletePush(String articleId, Integer index) throws WxErrorException {
        String json = this.mpService.post((WxMpApiUrl)WxMpApiUrl.FreePublish.DEL_PUSH, GsonHelper.buildJsonObject((Object[])new Object[]{ARTICLE_ID, articleId, "index", index}));
        return GsonParser.parse((String)json).get("errcode").toString().equals(ERRCODE_SUCCESS);
    }

    @Override
    public Boolean deletePushAllArticle(String articleId) throws WxErrorException {
        return this.deletePush(articleId, 0);
    }

    @Override
    public WxMpFreePublishInfo getArticleFromId(String articleId) throws WxErrorException {
        return WxMpFreePublishInfo.fromJson(this.mpService.post((WxMpApiUrl)WxMpApiUrl.FreePublish.GET_ARTICLE, GsonHelper.buildJsonObject((Object[])new Object[]{ARTICLE_ID, articleId})));
    }

    @Override
    public WxMpFreePublishList getPublicationRecords(int offset, int count, int noContent) throws WxErrorException {
        return WxMpFreePublishList.fromJson(this.mpService.post((WxMpApiUrl)WxMpApiUrl.FreePublish.BATCH_GET, GsonHelper.buildJsonObject((Object[])new Object[]{"offset", offset, "count", count, "no_content", noContent})));
    }

    @Override
    public WxMpFreePublishList getPublicationRecords(int offset, int count) throws WxErrorException {
        return this.getPublicationRecords(offset, count, 0);
    }

    public WxMpFreePublishServiceImpl(WxMpService mpService) {
        this.mpService = mpService;
    }
}

