/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.mp.api.impl;

import com.google.gson.JsonObject;
import java.io.File;
import java.util.Date;
import me.chanjar.weixin.common.bean.result.WxMediaUploadResult;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.util.http.MediaUploadRequestExecutor;
import me.chanjar.weixin.mp.api.WxMpKefuService;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.bean.kefu.WxMpKefuMessage;
import me.chanjar.weixin.mp.bean.kefu.request.WxMpKfAccountRequest;
import me.chanjar.weixin.mp.bean.kefu.request.WxMpKfSessionRequest;
import me.chanjar.weixin.mp.bean.kefu.result.WxMpKfList;
import me.chanjar.weixin.mp.bean.kefu.result.WxMpKfMsgList;
import me.chanjar.weixin.mp.bean.kefu.result.WxMpKfOnlineList;
import me.chanjar.weixin.mp.bean.kefu.result.WxMpKfSessionGetResult;
import me.chanjar.weixin.mp.bean.kefu.result.WxMpKfSessionList;
import me.chanjar.weixin.mp.bean.kefu.result.WxMpKfSessionWaitCaseList;
import me.chanjar.weixin.mp.enums.WxMpApiUrl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WxMpKefuServiceImpl
implements WxMpKefuService {
    private static final Logger log = LoggerFactory.getLogger(WxMpKefuServiceImpl.class);
    private final WxMpService wxMpService;

    @Override
    public boolean sendKefuMessage(WxMpKefuMessage message) throws WxErrorException {
        return this.sendKefuMessageWithResponse(message) != null;
    }

    @Override
    public String sendKefuMessageWithResponse(WxMpKefuMessage message) throws WxErrorException {
        return this.wxMpService.post((WxMpApiUrl)WxMpApiUrl.Kefu.MESSAGE_CUSTOM_SEND, message.toJson());
    }

    @Override
    public WxMpKfList kfList() throws WxErrorException {
        String responseContent = this.wxMpService.get(WxMpApiUrl.Kefu.GET_KF_LIST, null);
        return WxMpKfList.fromJson(responseContent);
    }

    @Override
    public WxMpKfOnlineList kfOnlineList() throws WxErrorException {
        String responseContent = this.wxMpService.get(WxMpApiUrl.Kefu.GET_ONLINE_KF_LIST, null);
        return WxMpKfOnlineList.fromJson(responseContent);
    }

    @Override
    public boolean kfAccountAdd(WxMpKfAccountRequest request) throws WxErrorException {
        String responseContent = this.wxMpService.post((WxMpApiUrl)WxMpApiUrl.Kefu.KFACCOUNT_ADD, request.toJson());
        return responseContent != null;
    }

    @Override
    public boolean kfAccountUpdate(WxMpKfAccountRequest request) throws WxErrorException {
        String responseContent = this.wxMpService.post((WxMpApiUrl)WxMpApiUrl.Kefu.KFACCOUNT_UPDATE, request.toJson());
        return responseContent != null;
    }

    @Override
    public boolean kfAccountInviteWorker(WxMpKfAccountRequest request) throws WxErrorException {
        String responseContent = this.wxMpService.post((WxMpApiUrl)WxMpApiUrl.Kefu.KFACCOUNT_INVITE_WORKER, request.toJson());
        return responseContent != null;
    }

    @Override
    public boolean kfAccountUploadHeadImg(String kfAccount, File imgFile) throws WxErrorException {
        WxMediaUploadResult responseContent = (WxMediaUploadResult)this.wxMpService.execute(MediaUploadRequestExecutor.create(this.wxMpService.getRequestHttp()), String.format(WxMpApiUrl.Kefu.KFACCOUNT_UPLOAD_HEAD_IMG.getUrl(this.wxMpService.getWxMpConfigStorage()), kfAccount), imgFile);
        return responseContent != null;
    }

    @Override
    public boolean kfAccountDel(String kfAccount) throws WxErrorException {
        String responseContent = this.wxMpService.get(String.format(WxMpApiUrl.Kefu.KFACCOUNT_DEL.getUrl(this.wxMpService.getWxMpConfigStorage()), kfAccount), null);
        return responseContent != null;
    }

    @Override
    public boolean kfSessionCreate(String openid, String kfAccount) throws WxErrorException {
        WxMpKfSessionRequest request = new WxMpKfSessionRequest(kfAccount, openid);
        String responseContent = this.wxMpService.post((WxMpApiUrl)WxMpApiUrl.Kefu.KFSESSION_CREATE, request.toJson());
        return responseContent != null;
    }

    @Override
    public boolean kfSessionClose(String openid, String kfAccount) throws WxErrorException {
        WxMpKfSessionRequest request = new WxMpKfSessionRequest(kfAccount, openid);
        String responseContent = this.wxMpService.post((WxMpApiUrl)WxMpApiUrl.Kefu.KFSESSION_CLOSE, request.toJson());
        return responseContent != null;
    }

    @Override
    public WxMpKfSessionGetResult kfSessionGet(String openid) throws WxErrorException {
        String responseContent = this.wxMpService.get(String.format(WxMpApiUrl.Kefu.KFSESSION_GET_SESSION.getUrl(this.wxMpService.getWxMpConfigStorage()), openid), null);
        return WxMpKfSessionGetResult.fromJson(responseContent);
    }

    @Override
    public WxMpKfSessionList kfSessionList(String kfAccount) throws WxErrorException {
        String responseContent = this.wxMpService.get(String.format(WxMpApiUrl.Kefu.KFSESSION_GET_SESSION_LIST.getUrl(this.wxMpService.getWxMpConfigStorage()), kfAccount), null);
        return WxMpKfSessionList.fromJson(responseContent);
    }

    @Override
    public WxMpKfSessionWaitCaseList kfSessionGetWaitCase() throws WxErrorException {
        String responseContent = this.wxMpService.get(WxMpApiUrl.Kefu.KFSESSION_GET_WAIT_CASE, null);
        return WxMpKfSessionWaitCaseList.fromJson(responseContent);
    }

    @Override
    public WxMpKfMsgList kfMsgList(Date startTime, Date endTime, Long msgId, Integer number) throws WxErrorException {
        if (number > 10000) {
            throw new WxErrorException("\u975e\u6cd5\u53c2\u6570\u8bf7\u6c42\uff0c\u6bcf\u6b21\u6700\u591a\u67e5\u8be210000\u6761\u8bb0\u5f55\uff01");
        }
        if (startTime.after(endTime)) {
            throw new WxErrorException("\u8d77\u59cb\u65f6\u95f4\u4e0d\u80fd\u665a\u4e8e\u7ed3\u675f\u65f6\u95f4\uff01");
        }
        JsonObject param = new JsonObject();
        param.addProperty("starttime", (Number)(startTime.getTime() / 1000L));
        param.addProperty("endtime", (Number)(endTime.getTime() / 1000L));
        param.addProperty("msgid", (Number)msgId);
        param.addProperty("number", (Number)number);
        String responseContent = this.wxMpService.post((WxMpApiUrl)WxMpApiUrl.Kefu.MSG_RECORD_LIST, param.toString());
        return WxMpKfMsgList.fromJson(responseContent);
    }

    @Override
    public WxMpKfMsgList kfMsgList(Date startTime, Date endTime) throws WxErrorException {
        int number = 10000;
        WxMpKfMsgList result = this.kfMsgList(startTime, endTime, 1L, number);
        if (result != null && result.getNumber() == number) {
            Long msgId = result.getMsgId();
            WxMpKfMsgList followingResult = this.kfMsgList(startTime, endTime, msgId, number);
            while (followingResult != null && !followingResult.getRecords().isEmpty()) {
                result.getRecords().addAll(followingResult.getRecords());
                result.setNumber(result.getNumber() + followingResult.getNumber());
                result.setMsgId(followingResult.getMsgId());
                followingResult = this.kfMsgList(startTime, endTime, followingResult.getMsgId(), number);
            }
        }
        return result;
    }

    @Override
    public boolean sendKfTypingState(String openid, String command) throws WxErrorException {
        JsonObject params = new JsonObject();
        params.addProperty("touser", openid);
        params.addProperty("command", command);
        String responseContent = this.wxMpService.post((WxMpApiUrl)WxMpApiUrl.Kefu.CUSTOM_TYPING, params.toString());
        return responseContent != null;
    }

    public WxMpKefuServiceImpl(WxMpService wxMpService) {
        this.wxMpService = wxMpService;
    }
}

