/*
 * Decompiled with CFR 0.152.
 */
package com.github.binarywang.wxpay.exception;

import com.github.binarywang.wxpay.bean.result.WxPayBaseResult;
import com.google.common.base.Joiner;

public class WxPayException
extends Exception {
    private String customErrorMsg;
    private String returnCode;
    private String returnMsg;
    private String resultCode;
    private String errCode;
    private String errCodeDes;
    private String xmlString;

    public WxPayException(String customErrorMsg) {
        super(customErrorMsg);
        this.customErrorMsg = customErrorMsg;
    }

    public WxPayException(String customErrorMsg, Throwable tr) {
        super(customErrorMsg, tr);
        this.customErrorMsg = customErrorMsg;
    }

    private WxPayException(Builder builder) {
        super(builder.buildErrorMsg());
        this.returnCode = builder.returnCode;
        this.returnMsg = builder.returnMsg;
        this.resultCode = builder.resultCode;
        this.errCode = builder.errCode;
        this.errCodeDes = builder.errCodeDes;
        this.xmlString = builder.xmlString;
    }

    public static WxPayException from(WxPayBaseResult payBaseResult) {
        return WxPayException.newBuilder().xmlString(payBaseResult.getXmlString()).returnMsg(payBaseResult.getReturnMsg()).returnCode(payBaseResult.getReturnCode()).resultCode(payBaseResult.getResultCode()).errCode(payBaseResult.getErrCode()).errCodeDes(payBaseResult.getErrCodeDes()).build();
    }

    public String getXmlString() {
        return this.xmlString;
    }

    public String getReturnCode() {
        return this.returnCode;
    }

    public String getReturnMsg() {
        return this.returnMsg;
    }

    public String getResultCode() {
        return this.resultCode;
    }

    public String getErrCode() {
        return this.errCode;
    }

    public String getErrCodeDes() {
        return this.errCodeDes;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private String returnCode;
        private String returnMsg;
        private String resultCode;
        private String errCode;
        private String errCodeDes;
        private String xmlString;

        private Builder() {
        }

        public Builder returnCode(String returnCode) {
            this.returnCode = returnCode;
            return this;
        }

        public Builder returnMsg(String returnMsg) {
            this.returnMsg = returnMsg;
            return this;
        }

        public Builder resultCode(String resultCode) {
            this.resultCode = resultCode;
            return this;
        }

        public Builder errCode(String errCode) {
            this.errCode = errCode;
            return this;
        }

        public Builder errCodeDes(String errCodeDes) {
            this.errCodeDes = errCodeDes;
            return this;
        }

        public Builder xmlString(String xmlString) {
            this.xmlString = xmlString;
            return this;
        }

        public WxPayException build() {
            return new WxPayException(this);
        }

        public String buildErrorMsg() {
            return Joiner.on((String)"\uff0c").skipNulls().join((Object[])new String[]{this.returnCode == null ? null : String.format("\u8fd4\u56de\u4ee3\u7801\uff1a[%s]", this.returnCode), this.returnMsg == null ? null : String.format("\u8fd4\u56de\u4fe1\u606f\uff1a[%s]", this.returnMsg), this.resultCode == null ? null : String.format("\u7ed3\u679c\u4ee3\u7801\uff1a[%s]", this.resultCode), this.errCode == null ? null : String.format("\u9519\u8bef\u4ee3\u7801\uff1a[%s]", this.errCode), this.errCodeDes == null ? null : String.format("\u9519\u8bef\u8be6\u60c5\uff1a[%s]", this.errCodeDes), this.xmlString == null ? null : "\u5fae\u4fe1\u8fd4\u56de\u7684\u539f\u59cb\u62a5\u6587\uff1a\n" + this.xmlString});
        }
    }
}

