/*
 * Decompiled with CFR 0.152.
 */
package com.binarywang.spring.starter.wxjava.pay.config;

import com.binarywang.spring.starter.wxjava.pay.properties.WxPayProperties;
import com.github.binarywang.wxpay.config.WxPayConfig;
import com.github.binarywang.wxpay.service.WxPayService;
import com.github.binarywang.wxpay.service.impl.WxPayServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={WxPayProperties.class})
@ConditionalOnClass(value={WxPayService.class})
@ConditionalOnProperty(prefix="wx.pay", value={"enabled"}, matchIfMissing=true)
public class WxPayAutoConfiguration {
    private WxPayProperties properties;

    @Autowired
    public WxPayAutoConfiguration(WxPayProperties properties) {
        this.properties = properties;
    }

    @Bean
    @ConditionalOnMissingBean(value={WxPayService.class})
    public WxPayService wxPayService() {
        WxPayServiceImpl wxPayService = new WxPayServiceImpl();
        WxPayConfig payConfig = new WxPayConfig();
        payConfig.setAppId(StringUtils.trimToNull((String)this.properties.getAppId()));
        payConfig.setMchId(StringUtils.trimToNull((String)this.properties.getMchId()));
        payConfig.setMchKey(StringUtils.trimToNull((String)this.properties.getMchKey()));
        payConfig.setSubAppId(StringUtils.trimToNull((String)this.properties.getSubAppId()));
        payConfig.setSubMchId(StringUtils.trimToNull((String)this.properties.getSubMchId()));
        payConfig.setKeyPath(StringUtils.trimToNull((String)this.properties.getKeyPath()));
        payConfig.setUseSandboxEnv(this.properties.isUseSandboxEnv());
        payConfig.setServiceId(StringUtils.trimToNull((String)this.properties.getServiceId()));
        payConfig.setPayScoreNotifyUrl(StringUtils.trimToNull((String)this.properties.getPayScoreNotifyUrl()));
        payConfig.setPrivateKeyPath(StringUtils.trimToNull((String)this.properties.getPrivateKeyPath()));
        payConfig.setPrivateCertPath(StringUtils.trimToNull((String)this.properties.getPrivateCertPath()));
        payConfig.setCertSerialNo(StringUtils.trimToNull((String)this.properties.getCertSerialNo()));
        payConfig.setApiV3Key(StringUtils.trimToNull((String)this.properties.getApiv3Key()));
        wxPayService.setConfig(payConfig);
        return wxPayService;
    }
}

