/*
 * Decompiled with CFR 0.152.
 */
package com.fastobject.diff;

import com.fastobject.diff.DiffWapper;
import com.fastobject.diff.Difference;
import java.util.List;

public class DiffUtils<T> {
    public static final String CHANGE = "CHANGE";
    public static final String REMOVE = "REMOVE";
    public static final String ADD = "ADD";

    public DiffWapper get(String path, String nameCn, T oldValue, T newValue) {
        if (oldValue == newValue && oldValue == null) {
            return null;
        }
        if (oldValue == null || newValue == null) {
            return DiffUtils.getDiffWapper(path, nameCn, oldValue, newValue);
        }
        if (!newValue.equals(oldValue)) {
            return DiffUtils.getDiffWapper(path, nameCn, oldValue, newValue);
        }
        return null;
    }

    public static DiffWapper getDiffWapper(String path, String nameCn, Object oldStr, Object newStr) {
        String op = CHANGE;
        if (newStr == null && oldStr != null) {
            op = REMOVE;
        }
        if (oldStr == null && newStr != null) {
            op = ADD;
        }
        return DiffWapper.builder().path(path).logName(nameCn).op(op).diffValue(Difference.builder().oldValue(oldStr).newValue(newStr).build()).build();
    }

    public static String genDiffStr(List<DiffWapper> diffWapperList) {
        StringBuffer sb = new StringBuffer();
        if (diffWapperList != null && diffWapperList.size() > 0) {
            for (DiffWapper diffWapper : diffWapperList) {
                String op = diffWapper.getOp();
                String opCn = "\u4fee\u6539\u4e3a";
                if (op.equals(ADD)) {
                    opCn = "\u88ab\u6dfb\u52a0\u6210";
                    sb.append(String.format("\u300c%s\u300d%s[%s]", diffWapper.getLogName(), opCn, diffWapper.getDiffValue().getNewValue()));
                } else if (op.equals(REMOVE)) {
                    opCn = "\u88ab\u5220\u9664";
                    sb.append(String.format("\u300c%s\u300d\u7531[%s]%s", diffWapper.getLogName(), diffWapper.getDiffValue().getOldValue(), opCn));
                } else {
                    sb.append(String.format("\u300c%s\u300d\u7531[%s]%s[%s]", diffWapper.getLogName(), diffWapper.getDiffValue().getOldValue(), opCn, diffWapper.getDiffValue().getNewValue()));
                }
                sb.append("\n");
            }
        }
        return sb.toString();
    }
}

