/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.datatables.qrepository;

import com.querydsl.core.BooleanBuilder;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Operator;
import com.querydsl.core.types.Ops;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.PathBuilder;
import com.querydsl.core.types.dsl.StringExpression;
import java.util.ArrayList;
import org.springframework.data.jpa.datatables.mapping.Column;
import org.springframework.data.jpa.datatables.mapping.DataTablesInput;
import org.springframework.data.jpa.datatables.repository.DataTablesUtils;
import org.springframework.util.StringUtils;

class PredicateFactory {
    private static final char ESCAPE_CHAR = '~';

    PredicateFactory() {
    }

    public static Predicate createPredicate(PathBuilder<?> entity, DataTablesInput input) {
        BooleanBuilder predicate = new BooleanBuilder();
        for (Column column : input.getColumns()) {
            String filterValue = column.getSearch().getValue();
            boolean isColumnSearchable = column.getSearchable() != false && StringUtils.hasText((String)filterValue);
            if (!isColumnSearchable) continue;
            if (filterValue.contains("+")) {
                boolean nullable = false;
                ArrayList<String> values = new ArrayList<String>();
                for (String value : filterValue.split("\\+")) {
                    if ("NULL".equals(value)) {
                        nullable = true;
                        continue;
                    }
                    values.add("\\NULL".equals(value) ? "NULL" : value);
                }
                if (values.size() > 0 && DataTablesUtils.isBoolean((String)values.get(0))) {
                    ArrayList<Boolean> booleanValues = new ArrayList<Boolean>();
                    for (int i = 0; i < values.size(); ++i) {
                        booleanValues.add(Boolean.valueOf((String)values.get(i)));
                    }
                    BooleanExpression in = entity.getBoolean(column.getData()).in(booleanValues);
                    if (nullable) {
                        predicate = predicate.and((Predicate)entity.getBoolean(column.getData()).isNull().or((Predicate)in));
                        continue;
                    }
                    predicate = predicate.and((Predicate)in);
                    continue;
                }
                if (values.isEmpty()) {
                    if (!nullable) continue;
                    predicate = predicate.and((Predicate)entity.get(column.getData()).isNull());
                    continue;
                }
                BooleanExpression in = PredicateFactory.getStringExpression(entity, column.getData()).in(values);
                if (nullable) {
                    predicate = predicate.and((Predicate)entity.get(column.getData()).isNull().or((Predicate)in));
                    continue;
                }
                predicate = predicate.and((Predicate)in);
                continue;
            }
            if (DataTablesUtils.isBoolean(filterValue)) {
                predicate = predicate.and((Predicate)entity.getBoolean(column.getData()).eq(Boolean.valueOf(filterValue)));
                continue;
            }
            StringExpression stringExpression = PredicateFactory.getStringExpression(entity, column.getData());
            if ("NULL".equals(filterValue)) {
                predicate = predicate.and((Predicate)stringExpression.isNull());
                continue;
            }
            String likeFilterValue = PredicateFactory.getLikeFilterValue("\\NULL".equals(filterValue) ? "NULL" : filterValue);
            predicate = predicate.and((Predicate)stringExpression.lower().like(likeFilterValue, '~'));
        }
        String globalFilterValue = input.getSearch().getValue();
        if (StringUtils.hasText((String)globalFilterValue)) {
            BooleanBuilder matchOneColumnPredicate = new BooleanBuilder();
            for (Column column : input.getColumns()) {
                if (!column.getSearchable().booleanValue()) continue;
                matchOneColumnPredicate = matchOneColumnPredicate.or((Predicate)PredicateFactory.getStringExpression(entity, column.getData()).lower().like(PredicateFactory.getLikeFilterValue(globalFilterValue), '~'));
            }
            predicate = predicate.and((Predicate)matchOneColumnPredicate);
        }
        return predicate;
    }

    private static StringExpression getStringExpression(PathBuilder<?> entity, String columnData) {
        return Expressions.stringOperation((Operator)Ops.STRING_CAST, (Expression[])new Expression[]{entity.get(columnData)});
    }

    private static String getLikeFilterValue(String filterValue) {
        return "%" + filterValue.toLowerCase().replaceAll("~", "~~").replaceAll("%", "~%").replaceAll("_", "~_") + "%";
    }
}

