/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidfantasy.mybatisplus.generatorui.mbp;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.generator.config.OutputFile;
import com.baomidou.mybatisplus.generator.config.builder.ConfigBuilder;
import com.baomidou.mybatisplus.generator.config.builder.CustomFile;
import com.baomidou.mybatisplus.generator.config.po.TableInfo;
import com.baomidou.mybatisplus.generator.engine.AbstractTemplateEngine;
import com.github.davidfantasy.mybatisplus.generatorui.mbp.NameConverter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import org.beetl.core.Configuration;
import org.beetl.core.GroupTemplate;
import org.beetl.core.ResourceLoader;
import org.beetl.core.Template;
import org.beetl.core.resource.ClasspathResourceLoader;
import org.beetl.core.resource.CompositeResourceLoader;
import org.beetl.core.resource.FileResourceLoader;
import org.beetl.core.resource.Matcher;
import org.beetl.core.resource.StartsWithMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeetlTemplateEngine
extends AbstractTemplateEngine {
    private static final Logger log = LoggerFactory.getLogger(BeetlTemplateEngine.class);
    private GroupTemplate groupTemplate;
    private final String templateStoreDir;
    private final NameConverter nameConverter;

    public BeetlTemplateEngine(NameConverter nameConverter, String templateStoreDir) {
        this.templateStoreDir = templateStoreDir;
        this.nameConverter = nameConverter;
        try {
            log.info("\u6a21\u677f\u6839\u76ee\u5f55\u4e3a\uff1a" + templateStoreDir);
            ClasspathResourceLoader classpathResourceLoader = new ClasspathResourceLoader(((Object)((Object)this)).getClass().getClassLoader());
            FileResourceLoader fileResourceLoader = new FileResourceLoader(templateStoreDir);
            CompositeResourceLoader loader = new CompositeResourceLoader();
            loader.addResourceLoader((Matcher)new StartsWithMatcher("classpath:").withoutPrefix(), (ResourceLoader)classpathResourceLoader);
            loader.addResourceLoader((Matcher)new StartsWithMatcher("file:").withoutPrefix(), (ResourceLoader)fileResourceLoader);
            Configuration cfg = Configuration.defaultConfiguration();
            this.groupTemplate = new GroupTemplate((ResourceLoader)loader, cfg);
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public void writer(Map<String, Object> objectMap, String templatePath, File outputFile) throws Exception {
        if (templatePath.startsWith("file:")) {
            templatePath = templatePath.replace(this.templateStoreDir, "");
        }
        log.info("templatePath:" + templatePath);
        Template template = this.groupTemplate.getTemplate((Object)templatePath);
        try (FileOutputStream fileOutputStream = new FileOutputStream(outputFile);){
            template.binding(objectMap);
            template.renderTo((OutputStream)fileOutputStream);
        }
        log.info("\u5df2\u751f\u6210\u6587\u4ef6:" + outputFile.getPath());
    }

    public AbstractTemplateEngine init(ConfigBuilder configBuilder) {
        return this;
    }

    public String templateFilePath(String filePath) {
        return filePath;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String write2String(Map<String, Object> objectMap, String templatePath) {
        if (templatePath.startsWith("file:")) {
            templatePath = templatePath.replace(this.templateStoreDir, "");
        }
        Template template = this.groupTemplate.getTemplate((Object)templatePath);
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            template.binding(objectMap);
            template.renderTo((OutputStream)baos);
            String string = baos.toString("utf-8");
            return string;
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }

    protected void outputCustomFile(List<CustomFile> customFiles, TableInfo tableInfo, Map<String, Object> objectMap) {
        String entityName = tableInfo.getEntityName();
        String parentPath = this.getPathInfo(OutputFile.parent);
        customFiles.forEach(file -> {
            String filePath;
            String string = filePath = StrUtil.isNotBlank((CharSequence)file.getFilePath()) ? file.getFilePath() : parentPath;
            if (StrUtil.isNotBlank((CharSequence)file.getPackageName())) {
                filePath = filePath + File.separator + file.getPackageName();
                filePath = filePath.replaceAll("\\.", "\\" + File.separator);
            }
            String fileName = filePath + File.separator + this.nameConverter.customFileNameConvert(file.getFileName(), entityName);
            this.outputFile(new File(fileName), objectMap, file.getTemplatePath(), file.isFileOverride());
        });
    }
}

