/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidfantasy.mybatisplus.generatorui.service;

import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.generator.config.DataSourceConfig;
import com.baomidou.mybatisplus.generator.config.IDbQuery;
import com.github.davidfantasy.mybatisplus.generatorui.dbquery.DbQueryHolder;
import com.github.davidfantasy.mybatisplus.generatorui.dto.TableInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

@Service
public class DatabaseService {
    @Autowired
    private JdbcTemplate jdbcTemplate;
    @Autowired
    private DataSourceConfig dataSourceConfig;
    @Autowired
    private DbQueryHolder dbQueryHolder;

    public List<TableInfo> getTablesFromDb() {
        IDbQuery dbQuery = this.dbQueryHolder.getDbQuery(this.dataSourceConfig.getDbType());
        List results = this.jdbcTemplate.queryForList(this.getTableSql());
        ArrayList tableInfos = Lists.newArrayList();
        for (Map table : results) {
            TableInfo tableInfo = new TableInfo();
            tableInfo.setName((String)table.get(dbQuery.tableName()));
            tableInfo.setComment((String)table.get(dbQuery.tableComment()));
            tableInfos.add(tableInfo);
        }
        return tableInfos;
    }

    public String getTableSql() {
        String tablesSql = this.dbQueryHolder.getDbQuery(this.dataSourceConfig.getDbType()).tablesSql();
        String schema = this.dataSourceConfig.getSchemaName();
        if (schema == null) {
            schema = this.getDefaultSchema();
        }
        tablesSql = String.format(tablesSql, schema);
        return tablesSql;
    }

    private String getDefaultSchema() {
        String schema = null;
        DbType dbType = this.dataSourceConfig.getDbType();
        if (DbType.POSTGRE_SQL == dbType) {
            schema = "public";
        } else if (DbType.KINGBASE_ES == dbType) {
            schema = "PUBLIC";
        } else if (DbType.DB2 == dbType) {
            schema = "current schema";
        } else if (DbType.ORACLE == dbType) {
            schema = Objects.requireNonNull(this.dataSourceConfig.getUsername()).toUpperCase();
        } else if (DbType.SQL_SERVER == dbType) {
            schema = "dbo";
        }
        return schema;
    }
}

