/*
 * Decompiled with CFR 0.152.
 */
package com.github.fakemongo.async;

import com.github.fakemongo.AwaitResultSingleResultCallback;
import com.github.fakemongo.Fongo;
import com.github.fakemongo.async.FongoAsyncConnectionSource;
import com.mongodb.ReadPreference;
import com.mongodb.ServerAddress;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.async.client.FongoAsyncMongoDatabase;
import com.mongodb.async.client.MockAsyncMongoClient;
import com.mongodb.async.client.MongoClient;
import com.mongodb.binding.AsyncConnectionSource;
import com.mongodb.binding.AsyncReadBinding;
import com.mongodb.binding.AsyncWriteBinding;
import com.mongodb.connection.ServerVersion;
import com.mongodb.operation.AsyncOperationExecutor;
import com.mongodb.operation.AsyncReadOperation;
import com.mongodb.operation.AsyncWriteOperation;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FongoAsync
implements AsyncOperationExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(FongoAsync.class);
    public static final ServerVersion DEFAULT_SERVER_VERSION = new ServerVersion(3, 0);
    private final Fongo fongo;
    private final Map<String, FongoAsyncMongoDatabase> dbMap = new ConcurrentHashMap<String, FongoAsyncMongoDatabase>();
    private final ServerAddress serverAddress;
    private final MongoClient mongo;
    private final String name;

    public FongoAsync(String name) {
        this(name, DEFAULT_SERVER_VERSION);
    }

    public FongoAsync(String name, ServerVersion serverVersion) {
        this.name = name;
        this.serverAddress = new ServerAddress(new InetSocketAddress(ServerAddress.defaultHost(), ServerAddress.defaultPort()));
        this.mongo = this.createMongo();
        this.fongo = new Fongo(name, serverVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized FongoAsyncMongoDatabase getDatabase(String databaseName) {
        Map<String, FongoAsyncMongoDatabase> map = this.dbMap;
        synchronized (map) {
            FongoAsyncMongoDatabase fongoAsyncMongoDatabase = this.dbMap.get(databaseName);
            if (fongoAsyncMongoDatabase == null) {
                fongoAsyncMongoDatabase = new FongoAsyncMongoDatabase(databaseName, this.mongo.getSettings().getCodecRegistry(), this.mongo.getSettings().getReadPreference(), this.mongo.getSettings().getWriteConcern(), this.mongo.getSettings().getReadConcern(), this);
                this.dbMap.put(databaseName, fongoAsyncMongoDatabase);
            }
            return fongoAsyncMongoDatabase;
        }
    }

    public List<String> getDatabaseNames() {
        return new ArrayList<String>(this.dbMap.keySet());
    }

    public void dropDatabase(String dbName) {
        FongoAsyncMongoDatabase db = this.dbMap.remove(dbName);
        if (db != null) {
            db.drop(new AwaitResultSingleResultCallback());
        }
    }

    public ServerAddress getServerAddress() {
        return this.serverAddress;
    }

    public MongoClient getMongo() {
        return this.mongo;
    }

    private MongoClient createMongo() {
        return MockAsyncMongoClient.create(this);
    }

    public String toString() {
        return "FongoAsync (" + this.name + ")";
    }

    public <T> void execute(final AsyncReadOperation<T> operation, final ReadPreference readPreference, SingleResultCallback<T> callback) {
        operation.executeAsync(new AsyncReadBinding(){

            public ReadPreference getReadPreference() {
                return readPreference;
            }

            public void getReadConnectionSource(SingleResultCallback<AsyncConnectionSource> callback) {
                LOG.info("getReadConnectionSource() operation:" + operation.getClass());
                callback.onResult((Object)new FongoAsyncConnectionSource(FongoAsync.this), null);
            }

            public AsyncReadBinding retain() {
                return this;
            }

            public int getCount() {
                return 0;
            }

            public void release() {
            }
        }, callback);
    }

    public <T> void execute(final AsyncWriteOperation<T> operation, SingleResultCallback<T> callback) {
        operation.executeAsync(new AsyncWriteBinding(){

            public void getWriteConnectionSource(SingleResultCallback<AsyncConnectionSource> callback) {
                LOG.info("getWriteConnectionSource() operation:" + operation.getClass());
                callback.onResult((Object)new FongoAsyncConnectionSource(FongoAsync.this), null);
            }

            public AsyncWriteBinding retain() {
                return this;
            }

            public int getCount() {
                return 0;
            }

            public void release() {
            }
        }, callback);
    }

    public ServerVersion getServerVersion() {
        return this.fongo.getServerVersion();
    }

    public Fongo getFongo() {
        return this.fongo;
    }
}

