/*
 * Decompiled with CFR 0.152.
 */
package com.github.fakemongo.impl;

import com.github.fakemongo.FongoException;
import com.github.fakemongo.impl.ExpressionParser;
import com.github.fakemongo.impl.Filter;
import com.github.fakemongo.impl.Util;
import com.github.fakemongo.impl.ValueFilter;
import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bson.BSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateEngine {
    static final Logger LOG = LoggerFactory.getLogger(UpdateEngine.class);
    private final ExpressionParser expressionParser = new ExpressionParser();
    final List<BasicUpdate> commands = Arrays.asList(new BasicUpdate("$set", true){

        @Override
        void mergeAction(String subKey, DBObject subObject, Object object, DBObject objOriginal, boolean isCreated) {
            subObject.put(subKey, object);
        }
    }, new BasicUpdate("$setOnInsert", true){

        @Override
        void mergeAction(String subKey, DBObject subObject, Object object, DBObject objOriginal, boolean isCreated) {
            if (isCreated) {
                subObject.put(subKey, object);
            }
        }
    }, new BasicUpdate("$max", true){

        @Override
        void mergeAction(String subKey, DBObject subObject, Object object, DBObject objOriginal, boolean isCreated) {
            if (object instanceof Number) {
                Number updateNumber = UpdateEngine.this.expressionParser.typecast(this.command + " value", object, Number.class);
                Object oldValue = subObject.get(subKey);
                if (oldValue == null) {
                    subObject.put(subKey, (Object)updateNumber);
                } else {
                    Number oldNumber = UpdateEngine.this.expressionParser.typecast(subKey + " value", oldValue, Number.class);
                    subObject.put(subKey, (Object)Util.genericMax(oldNumber, updateNumber));
                }
            } else if (object instanceof Date) {
                Date updateNumber = UpdateEngine.this.expressionParser.typecast(this.command + " value", object, Date.class);
                Object oldValue = subObject.get(subKey);
                if (oldValue == null) {
                    subObject.put(subKey, (Object)updateNumber);
                } else {
                    Date oldNumber = UpdateEngine.this.expressionParser.typecast(subKey + " value", oldValue, Date.class);
                    subObject.put(subKey, (Object)Util.genericMax(oldNumber, updateNumber));
                }
            } else {
                throw new FongoException(subKey + " expected to be of type Date/Number but is " + (object != null ? object.getClass() : "null") + " toString:" + object);
            }
        }
    }, new BasicUpdate("$min", true){

        @Override
        void mergeAction(String subKey, DBObject subObject, Object object, DBObject objOriginal, boolean isCreated) {
            if (object instanceof Number) {
                Number updateNumber = UpdateEngine.this.expressionParser.typecast(this.command + " value", object, Number.class);
                Object oldValue = subObject.get(subKey);
                if (oldValue == null) {
                    subObject.put(subKey, (Object)updateNumber);
                } else {
                    Number oldNumber = UpdateEngine.this.expressionParser.typecast(subKey + " value", oldValue, Number.class);
                    subObject.put(subKey, (Object)Util.genericMin(oldNumber, updateNumber));
                }
            } else if (object instanceof Date) {
                Date updateNumber = UpdateEngine.this.expressionParser.typecast(this.command + " value", object, Date.class);
                Object oldValue = subObject.get(subKey);
                if (oldValue == null) {
                    subObject.put(subKey, (Object)updateNumber);
                } else {
                    Date oldNumber = UpdateEngine.this.expressionParser.typecast(subKey + " value", oldValue, Date.class);
                    subObject.put(subKey, (Object)Util.genericMin(oldNumber, updateNumber));
                }
            } else {
                throw new FongoException(subKey + " expected to be of type Date/Number but is " + (object != null ? object.getClass() : "null") + " toString:" + object);
            }
        }
    }, new BasicUpdate("$inc", true){

        @Override
        void mergeAction(String subKey, DBObject subObject, Object object, DBObject objOriginal, boolean isCreated) {
            Number updateNumber = UpdateEngine.this.expressionParser.typecast(this.command + " value", object, Number.class);
            Object oldValue = subObject.get(subKey);
            if (oldValue == null) {
                subObject.put(subKey, (Object)updateNumber);
            } else {
                Number oldNumber = UpdateEngine.this.expressionParser.typecast(subKey + " value", oldValue, Number.class);
                subObject.put(subKey, (Object)Util.genericAdd(oldNumber, updateNumber));
            }
        }
    }, new BasicUpdate("$mul", true){

        @Override
        void mergeAction(String subKey, DBObject subObject, Object object, DBObject objOriginal, boolean isCreated) {
            Number updateNumber = UpdateEngine.this.expressionParser.typecast(this.command + " value", object, Number.class);
            Object oldValue = subObject.get(subKey);
            if (oldValue == null) {
                subObject.put(subKey, (Object)Util.genericMul(0, updateNumber));
            } else {
                Number oldNumber = UpdateEngine.this.expressionParser.typecast(subKey + " value", oldValue, Number.class);
                subObject.put(subKey, (Object)Util.genericMul(oldNumber, updateNumber));
            }
        }
    }, new BasicUpdate("$unset", false){

        @Override
        void mergeAction(String subKey, DBObject subObject, Object object, DBObject objOriginal, boolean isCreated) {
            subObject.removeField(subKey);
        }
    }, new BasicUpdate("$rename", true){

        @Override
        void mergeAction(String subKey, DBObject subObject, Object object, DBObject objOriginal, boolean isCreated) {
            Object objValue = subObject.removeField(subKey);
            String newKey = (String)object;
            Util.putValue(objOriginal, newKey, objValue);
        }
    }, new BasicUpdate("$push", true){

        @Override
        void mergeAction(String subKey, DBObject subObject, Object object, DBObject objOriginal, boolean isCreated) {
            BasicDBList currentValue = subObject.containsField(subKey) ? UpdateEngine.this.expressionParser.typecast(subKey, subObject.get(subKey), BasicDBList.class) : new BasicDBList();
            if (ExpressionParser.isDbObject(object) && ExpressionParser.toDbObject(object).get("$each") != null) {
                Object sliceObject;
                DBObject dbObject = ExpressionParser.toDbObject(object);
                Object eachObject = dbObject.get("$each");
                BasicDBList eachList = UpdateEngine.this.expressionParser.typecast(this.command + ".$each value", eachObject, BasicDBList.class);
                int pos = currentValue.size();
                Object positionObject = dbObject.get("$position");
                if (positionObject != null && (pos = UpdateEngine.this.expressionParser.typecast(this.command + ".$position value", positionObject, Number.class).intValue()) >= currentValue.size()) {
                    pos = currentValue.size();
                }
                currentValue.addAll(pos, (Collection)eachList);
                Object sortObj = dbObject.get("$sort");
                if (sortObj != null) {
                    if (sortObj instanceof Number) {
                        int sortDirection = ((Number)sortObj).intValue();
                        Collections.sort(currentValue, UpdateEngine.this.expressionParser.objectComparator(sortDirection));
                    } else if (ExpressionParser.isDbObject(sortObj)) {
                        Collections.sort(currentValue, UpdateEngine.this.expressionParser.sortSpecificationComparator(ExpressionParser.toDbObject(sortObj)));
                    }
                }
                if ((sliceObject = dbObject.get("$slice")) != null) {
                    int slice = UpdateEngine.this.expressionParser.typecast(this.command + ".slice value", sliceObject, Number.class).intValue();
                    if (slice == 0) {
                        currentValue.clear();
                        currentValue.trimToSize();
                    } else if (slice > 0) {
                        BasicDBList subList = new BasicDBList();
                        subList.addAll((Collection)currentValue.subList(0, Math.min(slice, currentValue.size())));
                        currentValue = subList;
                    } else if (slice < 0 && currentValue.size() + slice >= 0) {
                        BasicDBList subList = new BasicDBList();
                        subList.addAll((Collection)currentValue.subList(Math.max(currentValue.size() + slice, 0), currentValue.size()));
                        currentValue = subList;
                    }
                }
            } else {
                currentValue.add(object);
            }
            subObject.put(subKey, (Object)currentValue);
        }
    }, new BasicUpdate("$pushAll", true){

        @Override
        void mergeAction(String subKey, DBObject subObject, Object object, DBObject objOriginal, boolean isCreated) {
            List newList = UpdateEngine.this.expressionParser.typecast(this.command + " value", object, List.class);
            if (!subObject.containsField(subKey)) {
                subObject.put(subKey, (Object)newList);
            } else {
                BasicDBList currentValue = UpdateEngine.this.expressionParser.typecast(subKey, subObject.get(subKey), BasicDBList.class);
                currentValue.addAll((Collection)newList);
                subObject.put(subKey, (Object)currentValue);
            }
        }
    }, new BasicUpdate("$addToSet", true){

        @Override
        void mergeAction(String subKey, DBObject subObject, Object object, DBObject objOriginal, boolean isCreated) {
            Object eachObject;
            boolean isEach = false;
            BasicDBList currentValue = UpdateEngine.this.expressionParser.typecast(subKey, subObject.get(subKey), BasicDBList.class);
            BasicDBList basicDBList = currentValue = currentValue == null ? new BasicDBList() : currentValue;
            if (ExpressionParser.isDbObject(object) && (eachObject = ExpressionParser.toDbObject(object).get("$each")) != null) {
                isEach = true;
                BasicDBList newList = UpdateEngine.this.expressionParser.typecast(this.command + ".$each value", eachObject, BasicDBList.class);
                if (newList == null) {
                    throw new FongoException(this.command + ".$each must not be null");
                }
                for (Object newValue : newList) {
                    if (currentValue.contains(newValue)) continue;
                    currentValue.add(newValue);
                }
            }
            if (!isEach && !currentValue.contains(object)) {
                currentValue.add(object);
            }
            subObject.put(subKey, (Object)currentValue);
        }
    }, new BasicUpdate("$pop", false){

        @Override
        void mergeAction(String subKey, DBObject subObject, Object object, DBObject objOriginal, boolean isCreated) {
            BasicDBList currentList = UpdateEngine.this.expressionParser.typecast(this.command, subObject.get(subKey), BasicDBList.class);
            if (currentList != null && currentList.size() > 0) {
                int direction = UpdateEngine.this.expressionParser.typecast(this.command, object, Number.class).intValue();
                if (direction > 0) {
                    currentList.remove(currentList.size() - 1);
                } else {
                    currentList.remove(0);
                }
            }
        }
    }, new BasicUpdate("$pull", false){

        @Override
        void mergeAction(String subKey, DBObject subObject, Object object, DBObject objOriginal, boolean isCreated) {
            BasicDBList currentList = UpdateEngine.this.expressionParser.typecast(this.command + " only works on arrays", subObject.get(subKey), BasicDBList.class);
            if (currentList != null && currentList.size() > 0) {
                BasicDBList newList = new BasicDBList();
                if (ExpressionParser.isDbObject(object)) {
                    ValueFilter filter = UpdateEngine.this.expressionParser.buildValueFilter(ExpressionParser.toDbObject(object));
                    for (Object item : currentList) {
                        if (filter.apply(item)) continue;
                        newList.add(item);
                    }
                } else if (object != null) {
                    for (Object item : currentList) {
                        if (UpdateEngine.this.expressionParser.compareObjects(object, item) == 0) continue;
                        newList.add(item);
                    }
                }
                subObject.put(subKey, (Object)newList);
            }
        }
    }, new BasicUpdate("$pullAll", false){

        @Override
        void mergeAction(String subKey, DBObject subObject, Object object, DBObject objOriginal, boolean isCreated) {
            BasicDBList currentList = UpdateEngine.this.expressionParser.typecast(this.command + " only works on arrays", subObject.get(subKey), BasicDBList.class);
            if (currentList != null && currentList.size() > 0) {
                HashSet pullSet = new HashSet(UpdateEngine.this.expressionParser.typecast(this.command, object, List.class));
                BasicDBList newList = new BasicDBList();
                for (Object item : currentList) {
                    if (pullSet.contains(item)) continue;
                    newList.add(item);
                }
                subObject.put(subKey, (Object)newList);
            }
        }
    }, new BasicUpdate("$bit", false){

        @Override
        void mergeAction(String subKey, DBObject subObject, Object object, DBObject objOriginal, boolean isCreated) {
            Number currentNumber = UpdateEngine.this.expressionParser.typecast(this.command + " only works on integers", subObject.get(subKey), Number.class);
            if (currentNumber != null) {
                if (currentNumber instanceof Float || currentNumber instanceof Double) {
                    throw new FongoException(this.command + " only works on integers");
                }
                DBObject bitOps = UpdateEngine.this.expressionParser.typecast(this.command, object, DBObject.class);
                for (String op : bitOps.keySet()) {
                    Number opValue = UpdateEngine.this.expressionParser.typecast(this.command + "." + op, bitOps.get(op), Number.class);
                    if ("and".equals(op)) {
                        if (opValue instanceof Long || currentNumber instanceof Long) {
                            currentNumber = currentNumber.longValue() & opValue.longValue();
                            continue;
                        }
                        currentNumber = currentNumber.intValue() & opValue.intValue();
                        continue;
                    }
                    if ("or".equals(op)) {
                        if (opValue instanceof Long || currentNumber instanceof Long) {
                            currentNumber = currentNumber.longValue() | opValue.longValue();
                            continue;
                        }
                        currentNumber = currentNumber.intValue() | opValue.intValue();
                        continue;
                    }
                    throw new FongoException(this.command + "." + op + " is not valid.");
                }
                subObject.put(subKey, (Object)currentNumber);
            }
        }
    }, new BasicUpdate("$currentDate", true){

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        void mergeAction(String subKey, DBObject subObject, Object object, DBObject objOriginal, boolean isCreated) {
            if (Boolean.TRUE.equals(object)) {
                subObject.put(subKey, (Object)new Date());
                return;
            } else {
                if (objOriginal == null || !ExpressionParser.isDbObject(object)) throw new FongoException(this.command + " parameters should be either a boolean true or a document specifying a type");
                Object typeObject = ExpressionParser.toDbObject(object).get("$type");
                String type = UpdateEngine.this.expressionParser.typecast(this.command, typeObject, String.class);
                if (!"date".equals(type)) throw new FongoException(this.command + " called with unsupported type");
                subObject.put(subKey, (Object)new Date());
            }
        }
    });
    final Map<String, BasicUpdate> commandMap = this.createCommandMap();
    private final BasicUpdate basicUpdateForUpsert = new BasicUpdate("upsert", true){

        @Override
        void mergeAction(String subKey, DBObject subObject, Object object, DBObject objOriginal, boolean isCreated) {
            subObject.put(subKey, object);
        }
    };

    void keyCheck(String key, Set<String> seenKeys) {
        if (!seenKeys.add(key)) {
            throw new FongoException("attempting more than one atomic update on on " + key);
        }
    }

    private Map<String, BasicUpdate> createCommandMap() {
        HashMap<String, BasicUpdate> map = new HashMap<String, BasicUpdate>();
        for (BasicUpdate item : this.commands) {
            map.put(item.command, item);
        }
        return map;
    }

    public DBObject doUpdate(DBObject obj, DBObject update) {
        return this.doUpdate(obj, update, (DBObject)new BasicDBObject(), true);
    }

    public DBObject doUpdate(DBObject obj, DBObject update, DBObject query, boolean isCreated) {
        boolean updateDone = false;
        HashSet<String> seenKeys = new HashSet<String>();
        for (String command : update.keySet()) {
            BasicUpdate basicUpdate = this.commandMap.get(command);
            if (basicUpdate != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Doing update for command {}", (Object)command);
                }
                basicUpdate.doUpdate(obj, update, seenKeys, query, isCreated);
                updateDone = true;
                continue;
            }
            if (!command.startsWith("$")) continue;
            throw new FongoException("unsupported update: " + update);
        }
        if (!updateDone) {
            Iterator iter = obj.keySet().iterator();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                if (key.equals("_id")) continue;
                iter.remove();
            }
            obj.putAll((BSONObject)update);
        }
        return obj;
    }

    public void mergeEmbeddedValueFromQuery(BasicDBObject newObject, DBObject q) {
        this.basicUpdateForUpsert.doUpdate((DBObject)newObject, (DBObject)new BasicDBObject(this.basicUpdateForUpsert.command, (Object)q), new HashSet<String>(), q, false);
    }

    abstract class BasicUpdate {
        private final boolean createMissing;
        final String command;

        public BasicUpdate(String command, boolean createMissing) {
            this.command = command;
            this.createMissing = createMissing;
        }

        abstract void mergeAction(String var1, DBObject var2, Object var3, DBObject var4, boolean var5);

        public DBObject doUpdate(DBObject obj, DBObject update, Set<String> seenKeys, DBObject query, boolean isCreated) {
            DBObject updateObject = ExpressionParser.toDbObject(update.get(this.command));
            HashSet keySet = new HashSet(updateObject.keySet());
            LOG.debug("KeySet is of length {}", (Object)keySet.size());
            for (String updateKey : keySet) {
                LOG.debug("\tfound a key {}", (Object)updateKey);
                UpdateEngine.this.keyCheck(updateKey, seenKeys);
                this.doSingleKeyUpdate(updateKey, obj, updateObject.get(updateKey), query, isCreated);
            }
            return obj;
        }

        void doSingleKeyUpdate(String updateKey, DBObject objOriginal, Object object, DBObject query, boolean isCreated) {
            List<String> path = Util.split(updateKey);
            String subKey = path.get(0);
            DBObject obj = objOriginal;
            boolean isPositional = updateKey.contains(".$");
            if (isPositional) {
                LOG.debug("got a positional for query {}", (Object)query);
            }
            for (int i = 0; i < path.size() - 1; ++i) {
                Object value;
                if (!obj.containsField(subKey)) {
                    if (this.createMissing && !isPositional) {
                        obj.put(subKey, (Object)new BasicDBObject());
                    } else {
                        return;
                    }
                }
                if ((value = obj.get(subKey)) instanceof List && "$".equals(path.get(i + 1))) {
                    this.handlePositionalUpdate(updateKey, object, (List)value, obj, query, objOriginal);
                } else if (ExpressionParser.isDbObject(value)) {
                    obj = ExpressionParser.toDbObject(value);
                } else if (value instanceof List) {
                    BasicDBList newList = Util.wrap((List)value);
                    obj = newList;
                } else {
                    throw new FongoException("subfield must be object. " + updateKey + " not in " + objOriginal);
                }
                subKey = path.get(i + 1);
            }
            if (!isPositional) {
                LOG.debug("Subobject is {}", (Object)obj);
                this.mergeAction(subKey, obj, object, objOriginal, isCreated);
                LOG.debug("Full object is {}", (Object)objOriginal);
            }
        }

        public void handlePositionalUpdate(String updateKey, Object object, List valueList, DBObject ownerObj, DBObject query, DBObject objOriginal) {
            int dollarIndex = updateKey.indexOf("$");
            String postPath = dollarIndex == updateKey.length() - 1 ? "" : updateKey.substring(dollarIndex + 2);
            String prePath = updateKey.substring(0, dollarIndex - 1);
            Filter filter = null;
            for (String key : query.keySet()) {
                if (!key.startsWith(prePath)) continue;
                String matchKey = prePath.equals(key) ? key : key.substring(prePath.length() + 1);
                filter = UpdateEngine.this.expressionParser.buildFilter((DBObject)new BasicDBObject(matchKey, query.get(key)));
            }
            if (filter == null) {
                throw new FongoException("positional operator " + updateKey + " must be used on query key " + query);
            }
            for (int i = 0; i < valueList.size(); ++i) {
                DBObject o;
                Object listItem = valueList.get(i);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("found a positional list item " + listItem + " " + prePath + " " + postPath);
                }
                if (!postPath.isEmpty()) {
                    if (!ExpressionParser.isDbObject(listItem)) {
                        throw new FongoException("can not update \"" + postPath + "\" field of non-DBObject object");
                    }
                    BasicDBList listWithSingleItem = new BasicDBList();
                    listWithSingleItem.add(listItem);
                    if (!filter.apply(ExpressionParser.toDbObject(listItem)) && !filter.apply((DBObject)new BasicDBObject(prePath, (Object)listWithSingleItem))) continue;
                    this.doSingleKeyUpdate(postPath, ExpressionParser.toDbObject(listItem), object, query, false);
                    break;
                }
                Object object2 = o = ExpressionParser.isDbObject(listItem) ? ExpressionParser.toDbObject(listItem) : new BasicDBObject(prePath, listItem);
                if (!filter.apply(o)) continue;
                BasicDBList newList = new BasicDBList();
                newList.addAll((Collection)valueList);
                this.mergeAction(String.valueOf(i), (DBObject)newList, object, objOriginal, false);
                valueList.clear();
                valueList.addAll(newList);
                break;
            }
        }
    }
}

