/*
 * Decompiled with CFR 0.152.
 */
package com.github.fakemongo.impl.aggregation;

import com.github.fakemongo.impl.ExpressionParser;
import com.github.fakemongo.impl.Util;
import com.github.fakemongo.impl.aggregation.PipelineKeyword;
import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.MongoException;
import com.mongodb.annotations.ThreadSafe;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class Group
extends PipelineKeyword {
    private static final Logger LOG = LoggerFactory.getLogger(Group.class);
    public static final Group INSTANCE = new Group();

    private Group() {
    }

    @Override
    public DBCollection apply(DB originalDB, DBCollection coll, DBObject object) {
        DBObject group = ExpressionParser.toDbObject(object.get(this.getKeyword()));
        if (!group.containsField("_id")) {
            fongo.errorResult(15955, "a group specification must include an _id").throwOnError();
        }
        Object id = group.removeField("_id");
        LOG.debug("group() for _id : {}", id);
        Map<DBObject, Mapping> mapping = this.createMapping(coll, id);
        for (Map.Entry entry : group.toMap().entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (!ExpressionParser.isDbObject(value)) continue;
            DBObject objectValue = ExpressionParser.toDbObject(value);
            block1: for (Map.Entry<DBObject, Mapping> entryMapping : mapping.entrySet()) {
                DBCollection workColl = entryMapping.getValue().collection;
                for (GroupKeyword keyword : GroupKeyword.values()) {
                    if (!keyword.canApply(objectValue)) continue;
                    Object result = keyword.apply(workColl, objectValue);
                    if (result != null || keyword.isCanReturnNull()) {
                        LOG.debug("_id:{}, keyword:{}, result:{}", new Object[]{entryMapping.getKey(), key, result});
                        entryMapping.getValue().result.put(key, result);
                        continue block1;
                    }
                    LOG.warn("result is null for entry {}", entry);
                    continue block1;
                }
            }
        }
        coll = this.dropAndInsert(coll, new ArrayList<DBObject>());
        for (Map.Entry<Object, Object> entry : mapping.entrySet()) {
            coll.insert(new DBObject[]{((Mapping)entry.getValue()).result});
            ((Mapping)entry.getValue()).collection.drop();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("group() : {} result : {}", (Object)object, (Object)coll.find().toArray());
        }
        return coll;
    }

    private Map<DBObject, Mapping> createMapping(DBCollection coll, Object id) {
        HashMap<DBObject, Mapping> mapping = new HashMap<DBObject, Mapping>();
        List objects = coll.find().toArray();
        for (DBObject dbObject : objects) {
            DBObject criteria = this.criteriaForId(id, dbObject);
            if (mapping.containsKey(criteria)) continue;
            List newCollection = coll.find(criteria).toArray();
            DBObject key = this.keyForId(id, dbObject);
            mapping.put(criteria, new Mapping(key, this.createAndInsert(newCollection), Util.clone(key)));
            LOG.trace("createMapping() new criteria : {}", (Object)criteria);
        }
        return mapping;
    }

    private DBObject keyForId(Object id, DBObject dbObject) {
        BasicDBObject result = new BasicDBObject();
        if (ExpressionParser.isDbObject(id)) {
            BasicDBObject subKey = new BasicDBObject();
            this.extractKeys(ExpressionParser.toDbObject(id), dbObject, (DBObject)subKey);
            result.put("_id", (Object)subKey);
        } else if (id != null) {
            String field = Group.fieldName(id);
            result.put("_id", Util.extractField(dbObject, field));
        } else {
            result.put("_id", null);
        }
        LOG.debug("keyForId() id:{}, dbObject:{}, result:{}", new Object[]{id, dbObject, result});
        return result;
    }

    private void extractKeys(DBObject id, DBObject dbObject, DBObject subKey) {
        for (Map.Entry entry : id.toMap().entrySet()) {
            if (entry.getValue() instanceof DBObject) {
                DBObject keywordDBObject = (DBObject)entry.getValue();
                String keywordString = (String)keywordDBObject.keySet().iterator().next();
                Keyword extracted = Keyword.keyword(keywordString);
                if (extracted != null) {
                    subKey.put((String)entry.getKey(), extracted.apply(Util.extractField(dbObject, Group.fieldName(keywordDBObject.get(keywordString)))));
                    continue;
                }
                LOG.error("cannot find keywork for {}", entry);
                throw new MongoException(15999, String.format("invalid operator '%s'", keywordString));
            }
            subKey.put((String)entry.getKey(), Util.extractField(dbObject, Group.fieldName(entry.getValue())));
        }
    }

    private DBObject criteriaForId(Object id, DBObject dbObject) {
        BasicDBObject result = new BasicDBObject();
        if (ExpressionParser.isDbObject(id)) {
            this.extractKeys(ExpressionParser.toDbObject(id), dbObject, (DBObject)result);
        } else if (id != null) {
            String field = Group.fieldName(id);
            result.put(field, Util.extractField(dbObject, field));
        }
        LOG.debug("criteriaForId() id:{}, dbObject:{}, result:{}", new Object[]{id, dbObject, result});
        return result;
    }

    private static String fieldName(Object name) {
        String field = name.toString();
        if (name instanceof String && name.toString().startsWith("$")) {
            field = name.toString().substring(1);
        }
        return field;
    }

    private static Object sum(DBCollection coll, Object value) {
        Number result = null;
        if (value.toString().startsWith("$")) {
            String field = value.toString().substring(1);
            List objects = coll.find(null, (DBObject)new BasicDBObject(field, (Object)1).append("_id", (Object)0)).toArray();
            for (DBObject object : objects) {
                if (!Util.containsField(object, field)) continue;
                if (result == null) {
                    result = (Number)Util.extractField(object, field);
                    continue;
                }
                Number other = (Number)Util.extractField(object, field);
                result = Group.addWithSameType(result, other);
            }
        } else {
            Number iValue = (Number)value;
            if (iValue instanceof Float || iValue instanceof Double) {
                result = (double)coll.count() * iValue.doubleValue();
            } else if (iValue instanceof Byte || iValue instanceof Short || iValue instanceof Integer) {
                result = Group.intOrLong(coll.count() * iValue.longValue());
            } else if (iValue instanceof Long) {
                result = coll.count() * iValue.longValue();
            } else {
                LOG.warn("type of field not handled for sum:{}", result == null ? null : result.getClass());
            }
        }
        return result;
    }

    private static Number intOrLong(long number) {
        if (number <= Integer.MAX_VALUE && number >= Integer.MIN_VALUE) {
            return (int)number;
        }
        return number;
    }

    private static Double avg(DBCollection coll, Object value) {
        Number result = null;
        long count = 1L;
        if (value.toString().startsWith("$")) {
            String field = value.toString().substring(1);
            List objects = coll.find(null, (DBObject)new BasicDBObject(field, (Object)1).append("_id", (Object)0)).toArray();
            for (DBObject object : objects) {
                LOG.debug("avg object {} ", (Object)object);
                if (!Util.containsField(object, field)) continue;
                if (result == null) {
                    result = (Number)Util.extractField(object, field);
                    continue;
                }
                ++count;
                Number other = (Number)Util.extractField(object, field);
                result = Group.addWithSameType(result, other);
            }
        } else {
            LOG.error("Sorry, doesn't know what to do...");
            return null;
        }
        return result == null ? null : Double.valueOf(result.doubleValue() / (double)count);
    }

    private static Object firstlast(DBCollection coll, Object value, boolean first) {
        LOG.debug("first({})/last({}) on {}", new Object[]{first, !first, value});
        Object result = null;
        if (value.toString().startsWith("$")) {
            String field = value.toString().substring(1);
            DBCursor cursor = coll.find();
            while (cursor.hasNext()) {
                result = Group.extractFieldOrAggregationException(cursor.next(), field);
                if (!first) continue;
                break;
            }
        } else {
            LOG.error("Sorry, doesn't know what to do...");
        }
        LOG.debug("first({})/last({}) on {}, result : {}", new Object[]{first, !first, value, result});
        return result;
    }

    private static BasicDBList pushAddToSet(DBCollection coll, Object value, boolean uniqueness) {
        LOG.debug("pushAddToSet() on {}", value);
        BasicDBList result = null;
        if (value.toString().startsWith("$")) {
            result = new BasicDBList();
            String field = value.toString().substring(1);
            DBCursor cursor = coll.find();
            while (cursor.hasNext()) {
                Object fieldValue = Group.extractFieldOrAggregationException(cursor.next(), field);
                if (uniqueness && result.contains(fieldValue)) continue;
                result.add(fieldValue);
            }
        } else {
            LOG.error("Sorry, doesn't know what to do...");
        }
        LOG.debug("pushAddToSet() on {}, result : {}", value, (Object)result);
        return result;
    }

    private static Object minmax(DBCollection coll, Object value, int valueComparable) {
        if (value.toString().startsWith("$")) {
            String field = value.toString().substring(1);
            DBCursor cursor = coll.find();
            Comparable comparable = null;
            while (cursor.hasNext()) {
                DBObject object = cursor.next();
                if (!Util.containsField(object, field)) continue;
                if (comparable == null) {
                    comparable = (Comparable)Util.extractField(object, field);
                    continue;
                }
                Comparable other = (Comparable)Util.extractField(object, field);
                if (comparable.compareTo(other) != valueComparable) continue;
                comparable = other;
            }
            return comparable;
        }
        LOG.error("Sorry, doesn't know what to do...");
        return null;
    }

    private static Number addWithSameType(Number result, Number other) {
        if (result instanceof Float) {
            result = Float.valueOf(result.floatValue() + other.floatValue());
        } else if (result instanceof Double) {
            result = result.doubleValue() + other.doubleValue();
        } else if (result instanceof Integer) {
            result = result.intValue() + other.intValue();
        } else if (result instanceof Long) {
            result = result.longValue() + other.longValue();
        } else {
            LOG.warn("type of field not handled for sum : {}", result.getClass());
        }
        return result;
    }

    public static <T> T extractFieldOrAggregationException(DBObject object, String field) {
        if ("$ROOT".equals(field)) {
            return (T)object;
        }
        return Util.extractField(object, field);
    }

    @Override
    public String getKeyword() {
        return "$group";
    }

    static enum Keyword {
        DAYOFYEAR("$dayOfYear", 6),
        DAYOFMONTH("$dayOfMonth", 5),
        DAYOFWEEK("$dayOfWeek", 7),
        YEAR("$year", 1),
        MONTH("$month", 2, 1),
        WEEK("$week", 3, -1),
        HOUR("$hour", 11),
        MINUTE("$minute", 12),
        SECOND("$second", 13),
        MILLISECOND("$millisecond", 14);

        final String keyword;
        final int fromCalendar;
        final int modifier;

        private Keyword(String keyword, int fromCalendar, int modifier) {
            this.keyword = keyword;
            this.fromCalendar = fromCalendar;
            this.modifier = modifier;
        }

        private Keyword(String keyword, int fromCalendar) {
            this(keyword, fromCalendar, 0);
        }

        Object apply(Object value) {
            if (value == null) {
                return null;
            }
            Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"), Locale.ENGLISH);
            calendar.setTimeInMillis(((Date)value).getTime());
            int extracted = calendar.get(this.fromCalendar) + this.modifier;
            return extracted;
        }

        static Keyword keyword(String word) {
            for (Keyword keyword : Keyword.values()) {
                if (!keyword.keyword.equals(word)) continue;
                return keyword;
            }
            return null;
        }
    }

    @ThreadSafe
    static enum GroupKeyword {
        MIN("$min"){

            @Override
            Object work(DBCollection coll, Object keywordParameter) {
                return Group.minmax(coll, keywordParameter, 1);
            }
        }
        ,
        MAX("$max"){

            @Override
            Object work(DBCollection coll, Object keywordParameter) {
                return Group.minmax(coll, keywordParameter, -1);
            }
        }
        ,
        FIRST("$first", true){

            @Override
            Object work(DBCollection coll, Object keywordParameter) {
                return Group.firstlast(coll, keywordParameter, true);
            }
        }
        ,
        LAST("$last", true){

            @Override
            Object work(DBCollection coll, Object keywordParameter) {
                return Group.firstlast(coll, keywordParameter, false);
            }
        }
        ,
        AVG("$avg"){

            @Override
            Object work(DBCollection coll, Object keywordParameter) {
                return Group.avg(coll, keywordParameter);
            }
        }
        ,
        SUM("$sum"){

            @Override
            Object work(DBCollection coll, Object keywordParameter) {
                return Group.sum(coll, keywordParameter);
            }
        }
        ,
        PUSH("$push"){

            @Override
            Object work(DBCollection coll, Object keywordParameter) {
                return Group.pushAddToSet(coll, keywordParameter, false);
            }
        }
        ,
        ADD_TO_SET("$addToSet"){

            @Override
            Object work(DBCollection coll, Object keywordParameter) {
                return Group.pushAddToSet(coll, keywordParameter, true);
            }
        };

        private final String keyword;
        private final boolean canReturnNull;

        private GroupKeyword(String keyword) {
            this(keyword, false);
        }

        private GroupKeyword(String keyword, boolean canReturnNull) {
            this.keyword = keyword;
            this.canReturnNull = canReturnNull;
        }

        abstract Object work(DBCollection var1, Object var2);

        public Object apply(DBCollection coll, DBObject parameter) {
            return this.work(coll, parameter.get(this.keyword));
        }

        public boolean canApply(DBObject parameter) {
            return parameter.containsField(this.keyword);
        }

        public boolean isCanReturnNull() {
            return this.canReturnNull;
        }

        public String getKeyword() {
            return this.keyword;
        }
    }

    static class Mapping {
        private final DBObject key;
        private final DBCollection collection;
        private final DBObject result;

        public Mapping(DBObject key, DBCollection collection, DBObject result) {
            this.key = key;
            this.collection = collection;
            this.result = result;
        }

        public String toString() {
            return "Mapping{keyword=" + this.key + ", collection=" + this.collection + ", result=" + this.result + '}';
        }
    }
}

