/*
 * Decompiled with CFR 0.152.
 */
package com.github.fakemongo.impl.aggregation;

import com.github.fakemongo.impl.ExpressionParser;
import com.github.fakemongo.impl.Util;
import com.github.fakemongo.impl.aggregation.PipelineKeyword;
import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.FongoDB;
import com.mongodb.FongoDBCollection;
import com.mongodb.MongoException;
import com.mongodb.annotations.ThreadSafe;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class Project
extends PipelineKeyword {
    private static final Logger LOG = LoggerFactory.getLogger(Project.class);
    public static final Project INSTANCE = new Project();

    private Project() {
    }

    @Override
    public DBCollection apply(DB originalDB, DBCollection coll, DBObject object) {
        LOG.debug("project() : {}", (Object)object);
        DBObject project = ExpressionParser.toDbObject(object.get(this.getKeyword()));
        DBObject projectResult = Util.clone(project);
        HashMap<String, List<ProjectedAbstract>> projectedFields = new HashMap<String, List<ProjectedAbstract>>();
        for (Map.Entry<String, Object> entry : Util.entrySet(project)) {
            if (entry.getValue() == null) continue;
            ProjectedAbstract.createMapping(coll, projectResult, projectedFields, entry.getKey(), entry.getValue(), "", ProjectedRename.newInstance(entry.getKey(), coll, null));
        }
        LOG.debug("project() of {} renamed {}", (Object)projectResult, projectedFields);
        List objects = coll.find(null, projectResult).toArray();
        ArrayList<DBObject> objectsResults = new ArrayList<DBObject>(objects.size());
        for (DBObject result : objects) {
            BasicDBObject renamed = new BasicDBObject("_id", result.get("_id"));
            for (Map.Entry entry : projectedFields.entrySet()) {
                if (!Util.containsField(result, (String)entry.getKey())) continue;
                for (ProjectedAbstract projected : (List)entry.getValue()) {
                    projected.unapply((DBObject)renamed, result, (String)entry.getKey());
                }
            }
            for (List projecteds : projectedFields.values()) {
                for (ProjectedAbstract projected : projecteds) {
                    projected.unapply((DBObject)renamed, result, null);
                }
            }
            objectsResults.add((DBObject)renamed);
        }
        coll = this.dropAndInsert(coll, objectsResults);
        LOG.debug("project() : {}, result : {}", (Object)object, (Object)objects);
        return coll;
    }

    @Override
    public String getKeyword() {
        return "$project";
    }

    public static class ProjectedFilter
    extends ProjectedAbstract<ProjectedFilter> {
        public static final String KEYWORD = "$filter";
        private static final String INPUT = "input";
        private static final String COND = "cond";
        private static final String ITEMS = "items";
        private static final String AS = "as";

        public ProjectedFilter(String destName, DBCollection coll, DBObject object) {
            this(KEYWORD, destName, coll, object);
        }

        ProjectedFilter(String keyword, String destName, DBCollection coll, DBObject pipeline) {
            super(KEYWORD, destName, pipeline);
        }

        @Override
        public void unapply(DBObject result, DBObject object, String key) {
            Object items = result.get(ITEMS);
            if (items == null && key == null) {
                result.put(ITEMS, null);
                return;
            }
            BasicDBObject basicDBObject = (BasicDBObject)object;
            BasicDBList elementToAdd = (BasicDBList)basicDBObject.get(key);
            if (elementToAdd == null) {
                return;
            }
            result.put(ITEMS, (Object)elementToAdd);
        }

        @Override
        void doWork(DBCollection coll, DBObject projectResult, Map<String, List<ProjectedAbstract>> projectedFields, String items_key, Object pipeline, String namespace) {
            BasicDBObject pipelineOasicDBObject = (BasicDBObject)pipeline;
            String input = this.getInput(pipelineOasicDBObject);
            BasicDBObject queryToDelete = new BasicDBObject("$pull", (Object)new BasicDBObject(input, (Object)this.projectQuery(new ArrayList<BasicDBObject>(), new BasicDBObject(), this.getAs(pipelineOasicDBObject), this.getCond(pipelineOasicDBObject))));
            DBCollection tmpCollection = this.getClonedCollection(coll);
            tmpCollection.updateMulti((DBObject)new BasicDBObject(), (DBObject)queryToDelete);
            this.subtraction(input, tmpCollection, coll);
            ProjectedFilter.createMapping(coll, projectResult, projectedFields, INPUT, input, namespace, this);
        }

        private DBCollection getClonedCollection(DBCollection coll) {
            FongoDBCollection tmpCollection = new FongoDBCollection((FongoDB)coll.getDB(), "tmp");
            DBCursor cursor = coll.find();
            while (cursor.hasNext()) {
                tmpCollection.insert(new DBObject[]{cursor.next()});
            }
            return tmpCollection;
        }

        private String getInput(BasicDBObject pipelineOasicDBObject) {
            String input = pipelineOasicDBObject.getString(INPUT);
            return input.startsWith("$") ? input.substring(1, input.length()) : input;
        }

        private String getAs(BasicDBObject pipelineOasicDBObject) {
            return pipelineOasicDBObject.getString(AS);
        }

        private BasicDBObject getCond(BasicDBObject pipelineOasicDBObject) {
            return (BasicDBObject)pipelineOasicDBObject.get(COND);
        }

        private boolean isLeaf(Object element) {
            return !(element instanceof BasicDBObject);
        }

        private BasicDBObject projectQuery(List<BasicDBObject> leaves, BasicDBObject result, String as, BasicDBObject cond) {
            if (cond.isEmpty()) {
                return new BasicDBObject();
            }
            for (String function : cond.keySet()) {
                BasicDBList functionParameters = (BasicDBList)cond.get(function);
                if (!(functionParameters instanceof List)) continue;
                for (Object ele : functionParameters) {
                    if (this.isLeaf(ele)) {
                        return this.getLeafBasicDBObject(ele, as, functionParameters, function);
                    }
                    BasicDBObject leaf = this.projectQuery(leaves, result, as, (BasicDBObject)ele);
                    leaves.addAll(Arrays.asList(leaf));
                    result.append(function, leaves);
                }
            }
            return result;
        }

        private BasicDBObject getLeafBasicDBObject(Object ele, String as, BasicDBList functionParameters, String function) {
            if (!(ele instanceof String)) {
                return new BasicDBObject();
            }
            String[] functionValue = ((String)ele).split("\\.");
            String alias = functionValue[0];
            if (!alias.replaceAll("\\$", "").equals(as)) {
                throw new IllegalArgumentException("Use of undefined variable: " + alias.replaceAll("\\$", ""));
            }
            String valueToApplay = functionValue[1];
            Object value = functionParameters.get(1);
            BasicDBObject condition = new BasicDBObject(function, value);
            BasicDBObject result = new BasicDBObject(valueToApplay, (Object)condition);
            return result;
        }

        private void subtraction(String input, DBCollection sourceCollection, DBCollection targetCollection) {
            DBCursor cursor = sourceCollection.find();
            while (cursor.hasNext()) {
                DBObject document = cursor.next();
                BasicDBList arrayEmelents = (BasicDBList)document.get(input);
                if (arrayEmelents == null) continue;
                for (int i = 0; i <= arrayEmelents.size() - 1; ++i) {
                    BasicDBObject arrayObjectToDelete = (BasicDBObject)arrayEmelents.get(i);
                    targetCollection.updateMulti((DBObject)new BasicDBObject(), (DBObject)new BasicDBObject("$pull", (Object)new BasicDBObject(input, (Object)arrayObjectToDelete)));
                }
            }
        }
    }

    static class ProjectedDateMillisecond
    extends ProjectedDate<ProjectedDateMillisecond> {
        public static final String KEYWORD = "$millisecond";

        public ProjectedDateMillisecond(String destName, DBCollection coll, DBObject object) {
            super(KEYWORD, 14, 0, destName, coll, object);
        }
    }

    static class ProjectedDateSecond
    extends ProjectedDate<ProjectedDateSecond> {
        public static final String KEYWORD = "$second";

        public ProjectedDateSecond(String destName, DBCollection coll, DBObject object) {
            super(KEYWORD, 13, 0, destName, coll, object);
        }
    }

    static class ProjectedDateMinute
    extends ProjectedDate<ProjectedDateMinute> {
        public static final String KEYWORD = "$minute";

        public ProjectedDateMinute(String destName, DBCollection coll, DBObject object) {
            super(KEYWORD, 12, 0, destName, coll, object);
        }
    }

    static class ProjectedDateHour
    extends ProjectedDate<ProjectedDateHour> {
        public static final String KEYWORD = "$hour";

        public ProjectedDateHour(String destName, DBCollection coll, DBObject object) {
            super(KEYWORD, 11, 0, destName, coll, object);
        }
    }

    static class ProjectedDateWeek
    extends ProjectedDate<ProjectedDateWeek> {
        public static final String KEYWORD = "$week";

        public ProjectedDateWeek(String destName, DBCollection coll, DBObject object) {
            super(KEYWORD, 3, -1, destName, coll, object);
        }
    }

    static class ProjectedDateMonth
    extends ProjectedDate<ProjectedDateMonth> {
        public static final String KEYWORD = "$month";

        public ProjectedDateMonth(String destName, DBCollection coll, DBObject object) {
            super(KEYWORD, 2, 1, destName, coll, object);
        }
    }

    static class ProjectedDateYear
    extends ProjectedDate<ProjectedDateYear> {
        public static final String KEYWORD = "$year";

        public ProjectedDateYear(String destName, DBCollection coll, DBObject object) {
            super(KEYWORD, 1, 0, destName, coll, object);
        }
    }

    static class ProjectedDateDayOfWeek
    extends ProjectedDate<ProjectedDateDayOfWeek> {
        public static final String KEYWORD = "$dayOfWeek";

        public ProjectedDateDayOfWeek(String destName, DBCollection coll, DBObject object) {
            super(KEYWORD, 7, 0, destName, coll, object);
        }
    }

    static class ProjectedDateDayOfMonth
    extends ProjectedDate<ProjectedDateDayOfMonth> {
        public static final String KEYWORD = "$dayOfMonth";

        public ProjectedDateDayOfMonth(String destName, DBCollection coll, DBObject object) {
            super(KEYWORD, 5, 0, destName, coll, object);
        }
    }

    static class ProjectedDateDayOfYear
    extends ProjectedDate<ProjectedDateDayOfYear> {
        public static final String KEYWORD = "$dayOfYear";

        public ProjectedDateDayOfYear(String destName, DBCollection coll, DBObject object) {
            super(KEYWORD, 6, 0, destName, coll, object);
        }
    }

    static abstract class ProjectedDate<T extends ProjectedDate>
    extends ProjectedAbstract<T> {
        private final String field;
        private final int fromCalendar;
        private final int modifier;

        public ProjectedDate(String keyword, int fromCalendar, int modifier, String destName, DBCollection coll, DBObject object) {
            super(keyword, destName, object);
            Object value = object.get(keyword);
            this.fromCalendar = fromCalendar;
            this.modifier = modifier;
            if (value instanceof List) {
                List list = (List)value;
                if (list.size() != 1) {
                    ProjectedDate.errorResult(coll, 16020, "Expression " + keyword + " takes exactly 1 arguments. " + list.size() + " were passed in.");
                }
                value = list.get(0);
            }
            if (!(value instanceof String)) {
                ProjectedDate.errorResult(coll, 16020, "the " + keyword + " operator requires a field name");
            }
            this.field = (String)value;
        }

        @Override
        void doWork(DBCollection coll, DBObject projectResult, Map<String, List<ProjectedAbstract>> projectedFields, String key, Object value, String namespace) {
            ProjectedDate.createMapping(coll, projectResult, projectedFields, this.field, this.field, namespace, this);
        }

        @Override
        public void unapply(DBObject result, DBObject object, String key) {
            Object value = ProjectedDate.extractValue(object, this.field);
            Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"), Locale.ENGLISH);
            calendar.setTimeInMillis(((Date)value).getTime());
            int extracted = calendar.get(this.fromCalendar) + this.modifier;
            result.put(this.destName, (Object)extracted);
        }
    }

    static class ProjectedToSubtract
    extends ProjectedAbstract<ProjectedToSubtract> {
        static final String KEYWORD = "$subtract";
        private final List<Object> expressions;

        public ProjectedToSubtract(String destName, DBCollection coll, DBObject object) {
            this(KEYWORD, destName, coll, object);
        }

        ProjectedToSubtract(String keyword, String destName, DBCollection coll, DBObject object) {
            super(KEYWORD, destName, object);
            Object value = object.get(keyword);
            if (!(value instanceof List) || ((List)value).size() != 2) {
                ProjectedToSubtract.errorResult(coll, 16020, "Expression " + keyword + " takes exactly 2 arguments.");
            }
            this.expressions = (List)value;
        }

        @Override
        void doWork(DBCollection coll, DBObject projectResult, Map<String, List<ProjectedAbstract>> projectedFields, String key, Object value, String namespace) {
            for (Object expression : this.expressions) {
                ProjectedToSubtract.createMapping(coll, projectResult, projectedFields, this.destName, expression, namespace, this);
            }
        }

        @Override
        public void unapply(DBObject result, DBObject object, String key) {
            Number add = (Number)ProjectedToSubtract.extractValue(object, this.expressions.get(0));
            for (int i = 1; i < this.expressions.size(); ++i) {
                add = Util.genericSub(add, (Number)ProjectedToSubtract.extractValue(object, this.expressions.get(i)));
            }
            result.put(this.destName, (Object)add);
        }
    }

    static class ProjectedToAdd
    extends ProjectedAbstract<ProjectedToAdd> {
        static final String KEYWORD = "$add";
        private final List<Object> expressions;

        public ProjectedToAdd(String destName, DBCollection coll, DBObject object) {
            this(KEYWORD, destName, coll, object);
        }

        ProjectedToAdd(String keyword, String destName, DBCollection coll, DBObject object) {
            super(KEYWORD, destName, object);
            Object value = object.get(keyword);
            if (!(value instanceof List) || ((List)value).size() < 1) {
                ProjectedToAdd.errorResult(coll, 16020, "the " + keyword + " operator requires an array with at least 1 operand");
            }
            this.expressions = (List)value;
        }

        @Override
        void doWork(DBCollection coll, DBObject projectResult, Map<String, List<ProjectedAbstract>> projectedFields, String key, Object value, String namespace) {
            for (Object expression : this.expressions) {
                ProjectedToAdd.createMapping(coll, projectResult, projectedFields, this.destName, expression, namespace, this);
            }
        }

        @Override
        public void unapply(DBObject result, DBObject object, String key) {
            Number add = (Number)ProjectedToAdd.extractValue(object, this.expressions.get(0));
            if (this.expressions.size() > 1) {
                for (int i = 1; i < this.expressions.size(); ++i) {
                    add = Util.genericAdd(add, (Number)ProjectedToAdd.extractValue(object, this.expressions.get(i)));
                }
            }
            result.put(this.destName, (Object)add);
        }
    }

    static class ProjectedToMultiply
    extends ProjectedAbstract<ProjectedToMultiply> {
        static final String KEYWORD = "$multiply";
        private final Object expression1;
        private final Object expression2;

        public ProjectedToMultiply(String destName, DBCollection coll, DBObject object) {
            this(KEYWORD, destName, coll, object);
        }

        ProjectedToMultiply(String keyword, String destName, DBCollection coll, DBObject object) {
            super(KEYWORD, destName, object);
            Object value = object.get(keyword);
            if (!(value instanceof List) || ((List)value).size() != 2) {
                ProjectedToMultiply.errorResult(coll, 16020, "the " + keyword + " operator requires an array of 2 operands");
            }
            List values = (List)value;
            this.expression1 = values.get(0);
            this.expression2 = values.get(1);
        }

        @Override
        void doWork(DBCollection coll, DBObject projectResult, Map<String, List<ProjectedAbstract>> projectedFields, String key, Object value, String namespace) {
            ProjectedToMultiply.createMapping(coll, projectResult, projectedFields, this.destName, this.expression1, namespace, this);
            ProjectedToMultiply.createMapping(coll, projectResult, projectedFields, this.destName, this.expression2, namespace, this);
        }

        @Override
        public void unapply(DBObject result, DBObject object, String key) {
            Number left = (Number)ProjectedToMultiply.extractValue(object, this.expression1);
            Number right = (Number)ProjectedToMultiply.extractValue(object, this.expression2);
            result.put(this.destName, (Object)Util.genericMul(left, right));
        }
    }

    static class ProjectedToMod
    extends ProjectedAbstract<ProjectedToMod> {
        static final String KEYWORD = "$mod";
        private final Object expression1;
        private final Object expression2;

        public ProjectedToMod(String destName, DBCollection coll, DBObject object) {
            this(KEYWORD, destName, coll, object);
        }

        ProjectedToMod(String keyword, String destName, DBCollection coll, DBObject object) {
            super(KEYWORD, destName, object);
            Object value = object.get(keyword);
            if (!(value instanceof List) || ((List)value).size() != 2) {
                ProjectedToMod.errorResult(coll, 16020, "the " + keyword + " operator requires an array of 2 operands");
            }
            List values = (List)value;
            this.expression1 = values.get(0);
            this.expression2 = values.get(1);
        }

        @Override
        void doWork(DBCollection coll, DBObject projectResult, Map<String, List<ProjectedAbstract>> projectedFields, String key, Object value, String namespace) {
            ProjectedToMod.createMapping(coll, projectResult, projectedFields, this.destName, this.expression1, namespace, this);
            ProjectedToMod.createMapping(coll, projectResult, projectedFields, this.destName, this.expression2, namespace, this);
        }

        @Override
        public void unapply(DBObject result, DBObject object, String key) {
            Number left = (Number)ProjectedToMod.extractValue(object, this.expression1);
            Number right = (Number)ProjectedToMod.extractValue(object, this.expression2);
            result.put(this.destName, (Object)Util.genericMod(left, right));
        }
    }

    static class ProjectedToDivide
    extends ProjectedAbstract<ProjectedToDivide> {
        static final String KEYWORD = "$divide";
        private final Object expression1;
        private final Object expression2;

        public ProjectedToDivide(String destName, DBCollection coll, DBObject object) {
            this(KEYWORD, destName, coll, object);
        }

        ProjectedToDivide(String keyword, String destName, DBCollection coll, DBObject object) {
            super(KEYWORD, destName, object);
            Object value = object.get(keyword);
            if (!(value instanceof List) || ((List)value).size() != 2) {
                ProjectedToDivide.errorResult(coll, 16020, "the " + keyword + " operator requires an array of 2 operands");
            }
            List values = (List)value;
            this.expression1 = values.get(0);
            this.expression2 = values.get(1);
        }

        @Override
        void doWork(DBCollection coll, DBObject projectResult, Map<String, List<ProjectedAbstract>> projectedFields, String key, Object value, String namespace) {
            ProjectedToDivide.createMapping(coll, projectResult, projectedFields, this.destName, this.expression1, namespace, this);
            ProjectedToDivide.createMapping(coll, projectResult, projectedFields, this.destName, this.expression2, namespace, this);
        }

        @Override
        public void unapply(DBObject result, DBObject object, String key) {
            Number left = (Number)ProjectedToDivide.extractValue(object, this.expression1);
            Number right = (Number)ProjectedToDivide.extractValue(object, this.expression2);
            result.put(this.destName, (Object)Util.genericDiv(left, right));
        }
    }

    static class ProjectedToUpper
    extends ProjectedToLower {
        static final String KEYWORD = "$toUpper";

        public ProjectedToUpper(String destName, DBCollection coll, DBObject object) {
            super(KEYWORD, destName, coll, object);
        }

        @Override
        protected String transformValue(String value) {
            return value.toUpperCase();
        }
    }

    static class ProjectedToLower
    extends ProjectedAbstract<ProjectedToLower> {
        static final String KEYWORD = "$toLower";
        private final String field;

        public ProjectedToLower(String destName, DBCollection coll, DBObject object) {
            this(KEYWORD, destName, coll, object);
        }

        ProjectedToLower(String keyword, String destName, DBCollection coll, DBObject object) {
            super(KEYWORD, destName, object);
            Object value = object.get(keyword);
            if (value instanceof List) {
                List values = (List)value;
                if (values.size() != 1) {
                    ProjectedToLower.errorResult(coll, 16020, "the " + keyword + " operator requires 1 operand(s)");
                }
                this.field = (String)values.get(0);
            } else {
                this.field = value.toString();
            }
        }

        @Override
        void doWork(DBCollection coll, DBObject projectResult, Map<String, List<ProjectedAbstract>> projectedFields, String key, Object value, String namespace) {
            ProjectedToLower.createMapping(coll, projectResult, projectedFields, this.field, this.field, namespace, this);
        }

        @Override
        public void unapply(DBObject result, DBObject object, String key) {
            Object value = ProjectedToLower.extractValue(object, this.field);
            value = value == null ? "" : this.transformValue(value.toString());
            result.put(this.destName, value);
        }

        String transformValue(String value) {
            return value.toLowerCase();
        }
    }

    static class ProjectedStrcasecmp
    extends ProjectedCmp {
        static final String KEYWORD = "$strcasecmp";

        public ProjectedStrcasecmp(String destName, DBCollection coll, DBObject object) {
            super(KEYWORD, destName, coll, object);
        }

        @Override
        protected int compare(String value1, String value2) {
            return value1.compareToIgnoreCase(value2);
        }
    }

    static class ProjectedCond
    extends ProjectedAbstract<ProjectedCond> {
        static final String KEYWORD = "$cond";
        private final DBObject cond;
        private final Object cThen;
        private final Object cElse;

        public ProjectedCond(String destName, DBCollection coll, DBObject object) {
            this(KEYWORD, destName, coll, object);
        }

        ProjectedCond(String keyword, String destName, DBCollection coll, DBObject object) {
            super(keyword, destName, object);
            Object value = object.get(keyword);
            if (value instanceof List) {
                if (((List)value).size() != 3) {
                    ProjectedCond.errorResult(coll, 16020, "the " + keyword + " operator requires an array of 3 operands");
                }
                List values = (List)value;
                this.cond = (DBObject)values.get(0);
                this.cThen = values.get(1);
                this.cElse = values.get(2);
            } else {
                this.cond = null;
                this.cThen = null;
                this.cElse = null;
            }
        }

        @Override
        void doWork(DBCollection coll, DBObject projectResult, Map<String, List<ProjectedAbstract>> projectedFields, String key, Object value, String namespace) {
        }

        @Override
        public void unapply(DBObject result, DBObject object, String key) {
            String secondValue;
            String value = ProjectedCond.extractValue(object, this.cond).toString();
            int strcmp = this.compare(value, secondValue = ProjectedCond.extractValue(object, this.cond).toString());
            result.put(this.destName, (Object)(strcmp < 0 ? -1 : (strcmp > 1 ? 1 : 0)));
        }

        int compare(String value1, String value2) {
            return value1.compareTo(value2);
        }
    }

    static class ProjectedCmp
    extends ProjectedAbstract<ProjectedCmp> {
        public static final String KEYWORD = "$cmp";
        private final String field1;
        private final String field2;

        public ProjectedCmp(String destName, DBCollection coll, DBObject object) {
            this(KEYWORD, destName, coll, object);
        }

        public ProjectedCmp(String keyword, String destName, DBCollection coll, DBObject object) {
            super(keyword, destName, object);
            Object value = object.get(keyword);
            if (!(value instanceof List) || ((List)value).size() != 2) {
                ProjectedCmp.errorResult(coll, 16020, "the " + keyword + " operator requires an array of 2 operands");
            }
            List values = (List)value;
            this.field1 = (String)values.get(0);
            this.field2 = (String)values.get(1);
        }

        @Override
        void doWork(DBCollection coll, DBObject projectResult, Map<String, List<ProjectedAbstract>> projectedFields, String key, Object value, String namespace) {
            ProjectedCmp.createMapping(coll, projectResult, projectedFields, this.field1, this.field1, namespace, this);
            ProjectedCmp.createMapping(coll, projectResult, projectedFields, this.field2, this.field2, namespace, this);
        }

        @Override
        public void unapply(DBObject result, DBObject object, String key) {
            String secondValue;
            String value = ProjectedCmp.extractValue(object, this.field1).toString();
            int strcmp = this.compare(value, secondValue = ProjectedCmp.extractValue(object, this.field2).toString());
            result.put(this.destName, (Object)(strcmp < 0 ? -1 : (strcmp > 1 ? 1 : 0)));
        }

        int compare(String value1, String value2) {
            return value1.compareTo(value2);
        }
    }

    static class ProjectedSubstr
    extends ProjectedAbstract<ProjectedSubstr> {
        public static final String KEYWORD = "$substr";
        private final String field;
        private final int start;
        private final int end;

        public ProjectedSubstr(String destName, DBCollection coll, DBObject object) {
            super(KEYWORD, destName, object);
            Object value = object.get(this.keyword);
            if (!(value instanceof List) || ((List)value).size() != 3) {
                ProjectedSubstr.errorResult(coll, 16020, "the $substr operator requires an array of 3 operands");
            }
            List values = (List)value;
            this.field = (String)values.get(0);
            this.start = ((Number)values.get(1)).intValue();
            this.end = ((Number)values.get(2)).intValue();
        }

        @Override
        void doWork(DBCollection coll, DBObject projectResult, Map<String, List<ProjectedAbstract>> projectedFields, String key, Object value, String namespace) {
            ProjectedSubstr.createMapping(coll, projectResult, projectedFields, this.destName, this.destName, namespace, this);
        }

        @Override
        public void unapply(DBObject result, DBObject object, String key) {
            String value;
            Object exracted = ProjectedSubstr.extractValue(object, this.field);
            String string = value = exracted == null ? null : String.valueOf(exracted);
            value = value == null ? "" : (this.start >= value.length() ? "" : value.substring(this.start, Math.min(this.end, value.length())));
            result.put(this.destName, (Object)value);
        }
    }

    static class ProjectedConcat
    extends ProjectedAbstract<ProjectedConcat> {
        public static final String KEYWORD = "$concat";
        private List<Object> toConcat = null;

        public ProjectedConcat(String destName, DBCollection coll, DBObject object) {
            super(KEYWORD, destName, object);
            Object value = object.get(this.keyword);
            if (!(value instanceof List) || ((List)value).size() == 0) {
                ProjectedConcat.errorResult(coll, 16020, "the $concat operator requires an array of operands");
            }
            this.toConcat = (List)value;
        }

        @Override
        void doWork(DBCollection coll, DBObject projectResult, Map<String, List<ProjectedAbstract>> projectedFields, String key, Object value, String namespace) {
            for (Object field : this.toConcat) {
                if (field instanceof String) {
                    ProjectedConcat.createMapping(coll, projectResult, projectedFields, (String)field, field, namespace, this);
                    continue;
                }
                if (!ExpressionParser.isDbObject(field)) continue;
            }
        }

        @Override
        public void unapply(DBObject result, DBObject object, String key) {
            StringBuilder sb = new StringBuilder();
            for (Object info : this.toConcat) {
                Object value = ProjectedConcat.extractValue(object, info);
                if (value == null) {
                    result.put(this.destName, null);
                    return;
                }
                String str = value.toString();
                sb.append(str);
            }
            result.put(this.destName, (Object)sb.toString());
        }
    }

    static class ProjectedIfNull
    extends ProjectedAbstract<ProjectedIfNull> {
        public static final String KEYWORD = "$ifNull";
        private final String field;
        private final Object valueIfNull;

        public ProjectedIfNull(String destName, DBCollection coll, DBObject object) {
            super(KEYWORD, destName, object);
            Object value = object.get(this.keyword);
            if (!(value instanceof List) || ((List)value).size() != 2) {
                ProjectedIfNull.errorResult(coll, 16020, "the $ifNull operator requires an array of 2 operands");
            }
            List values = (List)value;
            this.field = (String)values.get(0);
            this.valueIfNull = values.get(1);
        }

        @Override
        void doWork(DBCollection coll, DBObject projectResult, Map<String, List<ProjectedAbstract>> projectedFields, String key, Object value, String namespace) {
            ProjectedIfNull.createMapping(coll, projectResult, projectedFields, this.field, this.field, namespace, this);
            ProjectedIfNull.createMapping(coll, projectResult, projectedFields, String.valueOf(this.valueIfNull), this.valueIfNull, namespace, this);
        }

        @Override
        public void unapply(DBObject result, DBObject object, String key) {
            Object value = ProjectedIfNull.extractValue(object, this.field);
            if (value == null) {
                value = ProjectedIfNull.extractValue(object, this.valueIfNull);
            }
            result.put(this.destName, value);
        }
    }

    static class ProjectedSize
    extends ProjectedAbstract<ProjectedSize> {
        public static final String KEYWORD = "$size";
        private final String field;
        private final DBCollection coll;

        public ProjectedSize(String destName, DBCollection coll, DBObject object) {
            this(KEYWORD, destName, coll, object);
        }

        ProjectedSize(String keyword, String destName, DBCollection coll, DBObject object) {
            super(KEYWORD, destName, object);
            this.coll = coll;
            Object value = object.get(keyword);
            this.field = this.parseOperand(value);
        }

        private String parseOperand(Object value) {
            if (!(value instanceof String || value instanceof List && ((List)value).size() == 1)) {
                ProjectedSize.errorResult(this.coll, 16020, "the " + this.keyword + " operator requires an array of 1 operand");
            }
            Object parsedValue = value instanceof List ? ((List)value).get(0) : value;
            return (String)parsedValue;
        }

        @Override
        void doWork(DBCollection coll, DBObject projectResult, Map<String, List<ProjectedAbstract>> projectedFields, String key, Object value, String namespace) {
            ProjectedSize.createMapping(coll, projectResult, projectedFields, this.destName, this.destName, namespace, this);
        }

        @Override
        public void unapply(DBObject result, DBObject object, String key) {
            int size = 0;
            Object value = ProjectedSize.extractValue(object, this.field);
            if (value instanceof Collection) {
                size = ((Collection)value).size();
            } else {
                ProjectedSize.errorResult(this.coll, 17124, "the $size operator requires an list.");
            }
            result.put(this.destName, (Object)size);
        }
    }

    static class ProjectedRename
    extends ProjectedAbstract<ProjectedRename> {
        public static final String KEYWORD = "$___fongo$internal$";

        private ProjectedRename(String destName, DBCollection coll, DBObject object) {
            super(KEYWORD, destName, object);
        }

        public static ProjectedRename newInstance(String destName, DBCollection coll, DBObject object) {
            return new ProjectedRename(destName, coll, object);
        }

        @Override
        public void unapply(DBObject result, DBObject object, String key) {
            if (key != null) {
                Object value = Util.extractField(object, key);
                Util.putValue(result, this.destName, value);
            }
        }

        @Override
        void doWork(DBCollection coll, DBObject projectResult, Map<String, List<ProjectedAbstract>> projectedFields, String key, Object value, String namespace) {
        }
    }

    static abstract class ProjectedAbstract<T extends ProjectedAbstract> {
        static final Map<String, Class<? extends ProjectedAbstract>> projectedAbstractMap = new HashMap<String, Class<? extends ProjectedAbstract>>();
        final String keyword;
        final String destName;

        private ProjectedAbstract(String keyword, String destName, DBObject object) {
            this.keyword = keyword;
            this.destName = destName;
        }

        public abstract void unapply(DBObject var1, DBObject var2, String var3);

        abstract void doWork(DBCollection var1, DBObject var2, Map<String, List<ProjectedAbstract>> var3, String var4, Object var5, String var6);

        public final void apply(DBCollection coll, DBObject projectResult, Map<String, List<ProjectedAbstract>> projectedFields, String key, DBObject value, String namespace) {
            this.doWork(coll, projectResult, projectedFields, key, value.get(this.keyword), namespace);
        }

        public static void createMapping(DBCollection coll, DBObject projectResult, Map<String, List<ProjectedAbstract>> projectedFields, String key, Object kvalue, String namespace, ProjectedAbstract projected) {
            if (kvalue instanceof String) {
                String value = kvalue.toString();
                if (value.startsWith("$")) {
                    String fieldName = kvalue.toString().substring(1);
                    ProjectedAbstract.multimapPut(projectedFields, fieldName, projected);
                    projectResult.removeField(key);
                    if (fieldName.contains(".")) {
                        projectResult.put(fieldName.substring(0, fieldName.indexOf(46)), (Object)1);
                    } else {
                        projectResult.put(fieldName, (Object)1);
                    }
                } else {
                    ProjectedAbstract.multimapPut(projectedFields, value, projected);
                }
            } else if (ExpressionParser.isDbObject(kvalue)) {
                DBObject value = ExpressionParser.toDbObject(kvalue);
                ProjectedAbstract projectedAbstract = ProjectedAbstract.getProjected(value, coll, key);
                if (projectedAbstract != null) {
                    projectResult.removeField(key);
                    projectedAbstract.apply(coll, projectResult, projectedFields, key, value, namespace);
                } else {
                    projectResult.removeField(key);
                    for (Map.Entry<String, Object> subentry : Util.entrySet(value)) {
                        ProjectedAbstract.createMapping(coll, projectResult, projectedFields, subentry.getKey(), subentry.getValue(), namespace + key + ".", ProjectedRename.newInstance(namespace + key + "." + subentry.getKey(), coll, null));
                    }
                }
            } else {
                ProjectedAbstract.multimapPut(projectedFields, key, projected);
            }
        }

        private static void multimapPut(Map<String, List<ProjectedAbstract>> projectedFields, String key, ProjectedAbstract projected) {
            if (projectedFields.containsKey(key)) {
                projectedFields.get(key).add(projected);
            } else {
                ArrayList<ProjectedAbstract> list = new ArrayList<ProjectedAbstract>();
                list.add(projected);
                projectedFields.put(key, list);
            }
        }

        private static ProjectedAbstract getProjected(DBObject value, DBCollection coll, String destName) {
            for (Map.Entry<String, Class<? extends ProjectedAbstract>> entry : projectedAbstractMap.entrySet()) {
                if (!value.containsField(entry.getKey())) continue;
                try {
                    return entry.getValue().getConstructor(String.class, DBCollection.class, DBObject.class).newInstance(destName, coll, value);
                }
                catch (InstantiationException e) {
                    throw new RuntimeException(e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                catch (InvocationTargetException e) {
                    if (e.getTargetException() instanceof MongoException) {
                        throw (MongoException)e.getTargetException();
                    }
                    throw new RuntimeException(e);
                }
                catch (NoSuchMethodException e) {
                    throw new RuntimeException(e);
                }
            }
            return null;
        }

        static void errorResult(DBCollection coll, int code, String err) {
            ((FongoDB)coll.getDB()).notOkErrorResult(code, err).throwOnError();
        }

        static <T> T extractValue(DBObject object, Object fieldOrValue) {
            if (fieldOrValue instanceof String && fieldOrValue.toString().startsWith("$")) {
                return Util.extractField(object, fieldOrValue.toString().substring(1));
            }
            return (T)fieldOrValue;
        }

        static {
            projectedAbstractMap.put("$size", ProjectedSize.class);
            projectedAbstractMap.put("$strcasecmp", ProjectedStrcasecmp.class);
            projectedAbstractMap.put("$cmp", ProjectedCmp.class);
            projectedAbstractMap.put("$cond", ProjectedCond.class);
            projectedAbstractMap.put("$substr", ProjectedSubstr.class);
            projectedAbstractMap.put("$ifNull", ProjectedIfNull.class);
            projectedAbstractMap.put("$concat", ProjectedConcat.class);
            projectedAbstractMap.put("$toLower", ProjectedToLower.class);
            projectedAbstractMap.put("$toUpper", ProjectedToUpper.class);
            projectedAbstractMap.put("$divide", ProjectedToDivide.class);
            projectedAbstractMap.put("$mod", ProjectedToMod.class);
            projectedAbstractMap.put("$multiply", ProjectedToMultiply.class);
            projectedAbstractMap.put("$add", ProjectedToAdd.class);
            projectedAbstractMap.put("$subtract", ProjectedToSubtract.class);
            projectedAbstractMap.put("$dayOfYear", ProjectedDateDayOfYear.class);
            projectedAbstractMap.put("$dayOfMonth", ProjectedDateDayOfMonth.class);
            projectedAbstractMap.put("$dayOfWeek", ProjectedDateDayOfWeek.class);
            projectedAbstractMap.put("$year", ProjectedDateYear.class);
            projectedAbstractMap.put("$month", ProjectedDateMonth.class);
            projectedAbstractMap.put("$week", ProjectedDateWeek.class);
            projectedAbstractMap.put("$hour", ProjectedDateHour.class);
            projectedAbstractMap.put("$minute", ProjectedDateMinute.class);
            projectedAbstractMap.put("$second", ProjectedDateSecond.class);
            projectedAbstractMap.put("$millisecond", ProjectedDateMillisecond.class);
            projectedAbstractMap.put("$filter", ProjectedFilter.class);
        }
    }
}

