/*
 * Decompiled with CFR 0.152.
 */
package com.github.ferstl.depgraph;

import com.github.ferstl.depgraph.DependencyGraphMojo;
import com.github.ferstl.depgraph.dependency.DependencyNode;
import com.github.ferstl.depgraph.dependency.GraphFactory;
import com.github.ferstl.depgraph.dependency.GraphStyleConfigurer;
import com.github.ferstl.depgraph.graph.GraphBuilder;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.graph.DefaultDependencyNode;
import org.eclipse.aether.graph.Dependency;

@Mojo(name="example", aggregator=true, defaultPhase=LifecyclePhase.NONE, requiresDependencyCollection=ResolutionScope.NONE, threadSafe=true)
public class ExampleDependencyGraphMojo
extends DependencyGraphMojo {
    @Override
    protected GraphFactory createGraphFactory(ArtifactFilter globalFilter, ArtifactFilter transitiveIncludeExcludeFilter, ArtifactFilter targetFilter, GraphStyleConfigurer graphStyleConfigurer) {
        GraphBuilder<DependencyNode> graphBuilder = this.createGraphBuilder(graphStyleConfigurer);
        return new ExampleGraphFactory(graphBuilder, globalFilter, targetFilter);
    }

    static class ExampleGraphFactory
    implements GraphFactory {
        private final GraphBuilder<DependencyNode> graphBuilder;
        private final ArtifactFilter globalFilter;
        private final ArtifactFilter targetFilter;

        ExampleGraphFactory(GraphBuilder<DependencyNode> graphBuilder, ArtifactFilter globalFilter, ArtifactFilter targetFilter) {
            this.graphBuilder = graphBuilder;
            this.globalFilter = globalFilter;
            this.targetFilter = targetFilter;
        }

        @Override
        public String createGraph(MavenProject project) {
            org.apache.maven.artifact.DefaultArtifact aA = new org.apache.maven.artifact.DefaultArtifact("com.example", "artifact-a", "1.0.0", "compile", "jar", "", null);
            org.apache.maven.artifact.DefaultArtifact aB = new org.apache.maven.artifact.DefaultArtifact("com.example", "artifact-b", "1.0.0", "compile", "jar", "", null);
            org.apache.maven.artifact.DefaultArtifact aC = new org.apache.maven.artifact.DefaultArtifact("com.example", "artifact-c", "2.0.0", "compile", "jar", "", null);
            org.apache.maven.artifact.DefaultArtifact aD = new org.apache.maven.artifact.DefaultArtifact("com.example", "artifact-d", "1.0.0", "compile", "jar", "", null);
            org.apache.maven.artifact.DefaultArtifact aE = new org.apache.maven.artifact.DefaultArtifact("com.example.sub", "artifact-e", "1.0.0", "provided", "jar", "", null);
            org.apache.maven.artifact.DefaultArtifact aF = new org.apache.maven.artifact.DefaultArtifact("com.example.sub", "artifact-f", "1.0.0", "runtime", "jar", "", null);
            org.apache.maven.artifact.DefaultArtifact aG = new org.apache.maven.artifact.DefaultArtifact("com.example.sub", "artifact-g", "1.0.0", "test", "jar", "", null);
            org.apache.maven.artifact.DefaultArtifact aZ = new org.apache.maven.artifact.DefaultArtifact("com.example.sub", "artifact-zip", "1.0.0", "compile", "zip", "", null);
            DependencyNode nA = new DependencyNode((org.apache.maven.artifact.Artifact)aA);
            DependencyNode nB = new DependencyNode((org.apache.maven.artifact.Artifact)aB);
            DependencyNode nC = new DependencyNode((org.apache.maven.artifact.Artifact)aC);
            DependencyNode nCDup = ExampleGraphFactory.createConflict((org.apache.maven.artifact.Artifact)aC, aC.getVersion());
            DependencyNode nCConfl = ExampleGraphFactory.createConflict((org.apache.maven.artifact.Artifact)aC, "1.0.0");
            DependencyNode nD = new DependencyNode((org.apache.maven.artifact.Artifact)aD);
            DependencyNode nE = new DependencyNode((org.apache.maven.artifact.Artifact)aE);
            DependencyNode nF = new DependencyNode((org.apache.maven.artifact.Artifact)aF);
            DependencyNode nG = new DependencyNode((org.apache.maven.artifact.Artifact)aG);
            DependencyNode nZ = new DependencyNode((org.apache.maven.artifact.Artifact)aZ);
            this.addEdge(nA, nB);
            this.addEdge(nA, nD);
            this.addEdge(nG, nCConfl);
            this.addEdge(nB, nC);
            this.addEdge(nB, nD);
            this.addEdge(nZ, nCDup);
            this.addEdge(nD, nE);
            this.addEdge(nD, nF);
            this.addEdge(nB, nG);
            this.addEdge(nB, nZ);
            return this.graphBuilder.toString();
        }

        private void addEdge(DependencyNode from, DependencyNode to) {
            if (this.globalFilter.include(from.getArtifact()) && this.globalFilter.include(to.getArtifact()) && this.targetFilter.include(to.getArtifact())) {
                this.graphBuilder.addEdge(from, to);
            }
        }

        private static DependencyNode createConflict(org.apache.maven.artifact.Artifact artifact, String winningVersion) {
            DefaultArtifact aetherArtifact = new DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getClassifier(), artifact.getType(), artifact.getVersion());
            DefaultArtifact winnerArtifact = new DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getClassifier(), artifact.getType(), winningVersion);
            DefaultDependencyNode dependencyNode = new DefaultDependencyNode(new Dependency((Artifact)aetherArtifact, artifact.getScope()));
            dependencyNode.setData((Object)"conflict.winner", (Object)new DefaultDependencyNode(new Dependency((Artifact)winnerArtifact, "compile")));
            return new DependencyNode((org.eclipse.aether.graph.DependencyNode)dependencyNode);
        }
    }
}

