/*******************************************************************************
 * Copyright (c) 2010 Haifeng Li
 *   
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *  
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *******************************************************************************/

/**
 * Probability distributions. In probability theory, a probability mass,
 * probability density, or probability distribution is a function that
 * describes the probability of a random variable taking certain values.
 * <p>
 * In the discrete case, one can easily assign a probability to each possible
 * value. In contrast, when a random variable takes values from a continuum,
 * probabilities are nonzero only if they refer to finite intervals.
 * <p>
 * If total order is defined for the random variable, the cumulative
 * distribution function gives the probability that the random variable
 * is not larger than a given value; it is the integral of the non-cumulative
 * distribution.
 *
 * @author Haifeng Li
 */
package smile.stat.distribution;