/*
 * Decompiled with CFR 0.152.
 */
package com.github.jsonzou.jmockdata;

import com.github.jsonzou.jmockdata.mockdata.JMockDataManager;
import com.github.jsonzou.jmockdata.mockdata.JmockDataContext;
import com.github.jsonzou.jmockdata.mockdata.JmockDataWrapper;
import com.github.jsonzou.jmockdata.mockdata.JmockdataWrapperMetaDataAll;
import com.github.jsonzou.jmockdata.mockdata.JmockdataWrapperMetaDataSingle;
import com.github.jsonzou.jmockdata.mockdata.MockData;
import com.github.jsonzou.jmockdata.utils.ReflectionUtil;
import com.github.jsonzou.jmockdata.utils.TypeReference;
import sun.reflect.generics.reflectiveObjects.ParameterizedTypeImpl;

public class JMockData {
    private static final JmockdataWrapperMetaDataSingle jmockdataWrapperMetaDataSingle = new JmockdataWrapperMetaDataSingle();

    public static <T extends JmockDataWrapper> T mock(Class<T> mockType) {
        JmockDataContext context = JmockDataContext.newRootInstance(mockType);
        JmockDataWrapper data = (JmockDataWrapper)JMockDataManager.getInstance().getMockDataBean(mockType).mock(context);
        data.setJmockDataContext(context);
        context.printTree();
        return (T)data;
    }

    public static <T> T mockCollection(TypeReference<T> type) {
        ParameterizedTypeImpl dtype = (ParameterizedTypeImpl)type.getType();
        try {
            if (!ReflectionUtil.isContainer(ReflectionUtil.getClass(dtype))) {
                return null;
            }
            JmockDataContext context = JmockDataContext.newRootInstance(ReflectionUtil.getClass(dtype));
            MockData<?> md = JMockDataManager.getInstance().getMockDataBean(ReflectionUtil.getClass(dtype), ReflectionUtil.getParameterizedType(dtype));
            Object data = md.mock(context);
            context.printTree();
            return (T)data;
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T> T mockSimpleType(Class<T> simpleType) {
        JmockDataContext context = JmockDataContext.newRootInstance(simpleType);
        T simple = JMockDataManager.getInstance().getMockDataBean(simpleType).mock(context);
        context.printTree();
        return simple;
    }

    public static JmockdataWrapperMetaDataAll mockMetaDataAll() {
        return JMockData.mock(JmockdataWrapperMetaDataAll.class);
    }

    public static JmockdataWrapperMetaDataSingle mockMetaDataSingle() {
        return jmockdataWrapperMetaDataSingle;
    }
}

