/*
 * Decompiled with CFR 0.152.
 */
package com.github.jsonzou.jmockdata.utils;

import java.util.regex.Pattern;

public class StringUtil {
    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static boolean isNotEmpty(String str) {
        return !StringUtil.isEmpty(str);
    }

    public static boolean isNumber(String num) {
        if (StringUtil.isEmpty(num)) {
            return false;
        }
        return Pattern.matches("-?\\d+\\.?\\d*", num);
    }

    public static double ifNumberToDoubleElseDefault(String num, double defaultNum) {
        if (StringUtil.isNumber(num)) {
            return Double.parseDouble(num);
        }
        return defaultNum;
    }

    public static String firstLetterToUpperCase(String str) {
        if (StringUtil.isNotEmpty(str)) {
            return str.substring(0, 1).toUpperCase().concat(str.substring(1));
        }
        return str;
    }

    public static String replace(String inString, String oldPattern, String newPattern) {
        if (!StringUtil.hasLength(inString) || !StringUtil.hasLength(oldPattern) || newPattern == null) {
            return inString;
        }
        StringBuilder sb = new StringBuilder();
        int pos = 0;
        int index = inString.indexOf(oldPattern);
        int patLen = oldPattern.length();
        while (index >= 0) {
            sb.append(inString.substring(pos, index));
            sb.append(newPattern);
            pos = index + patLen;
            index = inString.indexOf(oldPattern, pos);
        }
        sb.append(inString.substring(pos));
        return sb.toString();
    }

    public static boolean hasLength(String str) {
        return StringUtil.hasLength((CharSequence)str);
    }

    public static boolean hasLength(CharSequence str) {
        return str != null && str.length() > 0;
    }

    public static String[] splitString(String str, String regex) {
        if (StringUtil.isEmpty(str)) {
            return null;
        }
        return str.split(regex);
    }

    public static Integer[] splitInteger(String str, String regex) {
        String[] strArr = StringUtil.splitString(str, regex);
        if (strArr == null) {
            return null;
        }
        Integer[] arr = new Integer[strArr.length];
        for (int i = 0; i < strArr.length; ++i) {
            arr[i] = Integer.parseInt(strArr[i].trim());
        }
        return arr;
    }

    public static Double[] splitDouble(String str, String regex) {
        String[] strArr = StringUtil.splitString(str, regex);
        if (strArr == null) {
            return null;
        }
        Double[] arr = new Double[strArr.length];
        for (int i = 0; i < strArr.length; ++i) {
            arr[i] = Double.parseDouble(strArr[i].trim());
        }
        return arr;
    }

    public static Long[] splitLong(String str, String regex) {
        String[] strArr = StringUtil.splitString(str, regex);
        if (strArr == null) {
            return null;
        }
        Long[] arr = new Long[strArr.length];
        for (int i = 0; i < strArr.length; ++i) {
            arr[i] = Long.parseLong(strArr[i].trim());
        }
        return arr;
    }

    public static Float[] splitFloat(String str, String regex) {
        String[] strArr = StringUtil.splitString(str, regex);
        if (strArr == null) {
            return null;
        }
        Float[] arr = new Float[strArr.length];
        for (int i = 0; i < strArr.length; ++i) {
            arr[i] = Float.valueOf(Float.parseFloat(strArr[i].trim()));
        }
        return arr;
    }

    public static Character[] splitCharacter(String str, String regex) {
        String[] strArr = StringUtil.splitString(str, regex);
        if (strArr == null) {
            return null;
        }
        Character[] arr = new Character[strArr.length];
        for (int i = 0; i < strArr.length; ++i) {
            arr[i] = Character.valueOf(strArr[i].trim().charAt(0));
        }
        return arr;
    }

    public static Short[] splitShort(String str, String regex) {
        String[] strArr = StringUtil.splitString(str, regex);
        if (strArr == null) {
            return null;
        }
        Short[] arr = new Short[strArr.length];
        for (int i = 0; i < strArr.length; ++i) {
            arr[i] = Short.parseShort(strArr[i].trim());
        }
        return arr;
    }
}

