/*
 * Decompiled with CFR 0.152.
 */
package com.github.kwai.open.api;

import com.github.kwai.open.KwaiOpenException;
import com.github.kwai.open.KwaiOpenResultCode;
import com.github.kwai.open.api.IOpenAPI;
import com.github.kwai.open.model.UserPhoneInfo;
import com.github.kwai.open.request.UserInfoRequest;
import com.github.kwai.open.request.UserPhoneRequest;
import com.github.kwai.open.response.UserInfoResponse;
import com.github.kwai.open.response.UserPhoneResponse;
import com.github.kwai.open.utils.AESUtils;
import com.github.kwai.open.utils.HttpUtils;
import com.github.kwai.open.utils.JsonUtils;
import com.github.kwai.open.utils.ValidatorUtils;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.codec.binary.Base64;

public class KwaiOpenUserApi
implements IOpenAPI {
    private String appId = "";

    private KwaiOpenUserApi(String appId) {
        this.appId = appId;
    }

    public static KwaiOpenUserApi init(String appId) {
        return new KwaiOpenUserApi(appId);
    }

    @Override
    public String getAppId() {
        return this.appId;
    }

    public UserInfoResponse getUserInfo(UserInfoRequest request) throws KwaiOpenException {
        ValidatorUtils.valid(request);
        return HttpUtils.get("https://open.kuaishou.com/openapi/user_info", request.toQueryParam(this), UserInfoResponse.class);
    }

    public UserPhoneResponse getUserPhone(UserPhoneRequest request) throws KwaiOpenException {
        ValidatorUtils.valid(request);
        try {
            UserPhoneResponse userPhoneResponse = HttpUtils.get("https://open.kuaishou.com/openapi/user_phone", request.toQueryParam(this), UserPhoneResponse.class);
            List<String> array = Arrays.asList(userPhoneResponse.getEncryptedPhone().split(":"));
            byte[] iv = Base64.decodeBase64((String)array.get(0));
            String cipherPhone = array.get(1);
            byte[] decryptBytes = AESUtils.decrypt(Base64.decodeBase64((String)request.getAppSecret()), iv, cipherPhone);
            String plainPhone = new String(decryptBytes, "utf-8");
            UserPhoneInfo userPhoneInfo = JsonUtils.readValue(plainPhone, UserPhoneInfo.class);
            userPhoneResponse.setUserPhoneInfo(userPhoneInfo);
            return userPhoneResponse;
        }
        catch (KwaiOpenException e) {
            throw e;
        }
        catch (Exception e) {
            throw new KwaiOpenException(KwaiOpenResultCode.SDK_ERROR, "\u5ba2\u6237\u7aef\u89e3\u6790\u5931\u8d25", e);
        }
    }
}

