/*
 * Decompiled with CFR 0.152.
 */
package com.github.liaochong.myexcel.core;

import com.github.liaochong.myexcel.core.SimpleExcelBuilder;
import com.github.liaochong.myexcel.core.WorkbookType;
import com.github.liaochong.myexcel.core.annotation.ExcelColumn;
import com.github.liaochong.myexcel.core.annotation.ExcelTable;
import com.github.liaochong.myexcel.core.annotation.ExcludeColumn;
import com.github.liaochong.myexcel.core.constant.BooleanDropDownList;
import com.github.liaochong.myexcel.core.constant.DropDownList;
import com.github.liaochong.myexcel.core.constant.LinkEmail;
import com.github.liaochong.myexcel.core.constant.LinkUrl;
import com.github.liaochong.myexcel.core.constant.NumberDropDownList;
import com.github.liaochong.myexcel.core.container.Pair;
import com.github.liaochong.myexcel.core.container.ParallelContainer;
import com.github.liaochong.myexcel.core.converter.WriteConverterContext;
import com.github.liaochong.myexcel.core.parser.ContentTypeEnum;
import com.github.liaochong.myexcel.core.parser.Table;
import com.github.liaochong.myexcel.core.parser.Td;
import com.github.liaochong.myexcel.core.parser.Tr;
import com.github.liaochong.myexcel.core.reflect.ClassFieldContainer;
import com.github.liaochong.myexcel.core.strategy.AutoWidthStrategy;
import com.github.liaochong.myexcel.utils.ReflectUtil;
import com.github.liaochong.myexcel.utils.StringUtil;
import com.github.liaochong.myexcel.utils.StyleUtil;
import com.github.liaochong.myexcel.utils.TdUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import lombok.NonNull;

public abstract class AbstractSimpleExcelBuilder
implements SimpleExcelBuilder {
    private Map<String, String> commonTdStyle;
    private Map<String, String> evenTdStyle;
    private Map<String, String> linkCommonStyle;
    private Map<String, String> linkEvenStyle;
    protected List<String> titles;
    private String sheetName;
    protected List<String> fieldDisplayOrder;
    protected WorkbookType workbookType = WorkbookType.XLSX;
    protected int rowAccessWindowSize;
    protected List<Field> filteredFields;
    protected Class<?> dataType;
    protected boolean noStyle;
    protected boolean fixedTitles;
    protected AutoWidthStrategy autoWidthStrategy = AutoWidthStrategy.COMPUTE_AUTO_WIDTH;
    private String globalDefaultValue;
    private Map<Field, String> defaultValueMap;
    private Map<Integer, Integer> customWidthMap;
    private boolean wrapText = true;
    protected int titleLevel = 0;
    private String titleSeparator = "->";
    private Map<String, Map<String, String>> customStyle = new HashMap<String, Map<String, String>>();
    protected Map<Integer, Integer> widths;

    @Override
    public AbstractSimpleExcelBuilder titles(@NonNull List<String> titles) {
        if (titles == null) {
            throw new NullPointerException("titles is marked non-null but is null");
        }
        this.titles = titles;
        return this;
    }

    @Override
    public AbstractSimpleExcelBuilder sheetName(@NonNull String sheetName) {
        if (sheetName == null) {
            throw new NullPointerException("sheetName is marked non-null but is null");
        }
        this.sheetName = sheetName;
        return this;
    }

    @Override
    public AbstractSimpleExcelBuilder fieldDisplayOrder(@NonNull List<String> fieldDisplayOrder) {
        if (fieldDisplayOrder == null) {
            throw new NullPointerException("fieldDisplayOrder is marked non-null but is null");
        }
        this.fieldDisplayOrder = fieldDisplayOrder;
        return this;
    }

    @Override
    public AbstractSimpleExcelBuilder rowAccessWindowSize(int rowAccessWindowSize) {
        if (rowAccessWindowSize <= 0) {
            throw new IllegalArgumentException("RowAccessWindowSize must be greater than 0");
        }
        this.rowAccessWindowSize = rowAccessWindowSize;
        return this;
    }

    @Override
    public AbstractSimpleExcelBuilder workbookType(@NonNull WorkbookType workbookType) {
        if (workbookType == null) {
            throw new NullPointerException("workbookType is marked non-null but is null");
        }
        this.workbookType = workbookType;
        return this;
    }

    @Override
    public AbstractSimpleExcelBuilder noStyle() {
        this.noStyle = true;
        return this;
    }

    @Override
    public AbstractSimpleExcelBuilder autoWidthStrategy(@NonNull AutoWidthStrategy autoWidthStrategy) {
        if (autoWidthStrategy == null) {
            throw new NullPointerException("autoWidthStrategy is marked non-null but is null");
        }
        this.autoWidthStrategy = autoWidthStrategy;
        return this;
    }

    @Override
    public AbstractSimpleExcelBuilder fixedTitles() {
        this.fixedTitles = true;
        return this;
    }

    @Override
    public AbstractSimpleExcelBuilder widths(int ... widths) {
        if (widths.length == 0) {
            return this;
        }
        this.widths = new HashMap<Integer, Integer>(widths.length);
        int size = widths.length;
        for (int i = 0; i < size; ++i) {
            this.widths.put(i, widths[i]);
        }
        this.customWidthMap = this.widths;
        return this;
    }

    protected List<Table> getTableWithHeader() {
        ArrayList<Table> tableList = new ArrayList<Table>();
        Table table = this.createTable();
        tableList.add(table);
        List<Tr> thead = this.createThead();
        if (thead != null) {
            table.getTrList().addAll(thead);
        }
        return tableList;
    }

    protected Table createTable() {
        Table table = new Table();
        table.setCaption(this.sheetName);
        table.setTrList(new LinkedList<Tr>());
        return table;
    }

    protected List<Tr> createThead() {
        Map<String, String> thStyle;
        if (this.titles == null || this.titles.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList tdLists = new ArrayList();
        for (int i = 0; i < this.titles.size(); ++i) {
            String string = this.titles.get(i);
            if (string == null) continue;
            ArrayList<Td> tds = new ArrayList<Td>();
            String[] multiTitles = string.split(this.titleSeparator);
            if (multiTitles.length > this.titleLevel) {
                this.titleLevel = multiTitles.length;
            }
            for (int j = 0; j < multiTitles.length; ++j) {
                Td td2 = new Td(j, i);
                td2.setTh(true);
                td2.setContent(multiTitles[j]);
                tds.add(td2);
            }
            tdLists.add(tds);
        }
        for (List list2 : tdLists) {
            Td last = (Td)list2.get(list2.size() - 1);
            last.setRowSpan(this.titleLevel - last.getRow());
        }
        int i = 0;
        while (i < this.titleLevel) {
            int n = i++;
            Map<String, List<List>> groups = tdLists.stream().filter(list -> list.size() > level).collect(Collectors.groupingBy(list -> ((Td)list.get(level)).getContent()));
            groups.forEach((k, v) -> {
                if (v.size() == 1) {
                    return;
                }
                List tds = v.stream().map(list -> (Td)list.get(level)).sorted(Comparator.comparing(Td::getCol)).collect(Collectors.toList());
                LinkedList subTds = new LinkedList();
                Map<Integer, List<Td>> partitions = tds.stream().collect(Collectors.groupingBy(Td::getRowSpan));
                partitions.forEach((col, subTdList) -> {
                    int splitIndex = 0;
                    int size = subTdList.size() - 1;
                    for (int j = 0; j < size; ++j) {
                        Td current = (Td)subTdList.get(j);
                        Td next = (Td)subTdList.get(j + 1);
                        if (current.getCol() + 1 == next.getCol()) continue;
                        List sub = subTdList.subList(splitIndex, j + 1);
                        splitIndex = j + 1;
                        if (sub.size() <= 1) continue;
                        subTds.add(sub);
                    }
                    subTds.add(subTdList.subList(splitIndex, subTdList.size()));
                });
                subTds.forEach(val -> {
                    if (val.size() == 1) {
                        return;
                    }
                    Td t = (Td)val.get(0);
                    t.setColSpan(val.size());
                    for (int j = 1; j < val.size(); ++j) {
                        ((Td)val.get(j)).setRow(-1);
                    }
                });
            });
        }
        if (this.noStyle) {
            thStyle = Collections.emptyMap();
        } else {
            thStyle = new HashMap(7);
            thStyle.put("font-weight", "bold");
            thStyle.put("font-size", "14");
            thStyle.put("text-align", "center");
            thStyle.put("vertical-align", "middle");
            thStyle.put("border-bottom-style", "thin");
            thStyle.put("border-left-style", "thin");
            thStyle.put("border-right-style", "thin");
        }
        Map<Integer, List<Td>> map = tdLists.stream().flatMap(Collection::stream).filter(td -> td.getRow() > -1).collect(Collectors.groupingBy(Td::getRow));
        ArrayList<Tr> trs = new ArrayList<Tr>();
        boolean isComputeAutoWidth = AutoWidthStrategy.isComputeAutoWidth(this.autoWidthStrategy);
        map.forEach((k, v) -> {
            Tr tr = new Tr((int)k);
            tr.setColWidthMap(isComputeAutoWidth ? new HashMap(this.titles.size()) : Collections.emptyMap());
            List<Td> tds = v.stream().sorted(Comparator.comparing(Td::getCol)).peek(td -> {
                if (!this.noStyle && !this.customStyle.isEmpty()) {
                    Map<String, String> style = this.customStyle.getOrDefault("title&" + td.getCol(), Collections.emptyMap());
                    td.setStyle(style);
                } else {
                    td.setStyle(thStyle);
                }
                if (isComputeAutoWidth) {
                    tr.getColWidthMap().put(td.getCol(), TdUtil.getStringWidth(td.getContent(), 0.25));
                }
            }).collect(Collectors.toList());
            tr.setTdList(tds);
            trs.add(tr);
        });
        return trs;
    }

    protected List<Tr> createTbody(List<List<Pair<? extends Class, ?>>> contents, int shift) {
        List result = IntStream.range(0, contents.size()).parallel().mapToObj(index -> this.createTr((List)contents.get(index), index, shift)).collect(Collectors.toCollection(LinkedList::new));
        contents.clear();
        return result;
    }

    protected Tr createTr(List<Pair<? extends Class, ?>> contents, int index, int shift) {
        boolean isComputeAutoWidth = AutoWidthStrategy.isComputeAutoWidth(this.autoWidthStrategy);
        boolean isCustomWidth = AutoWidthStrategy.isCustomWidth(this.autoWidthStrategy);
        int trIndex = index + shift;
        Tr tr = new Tr(trIndex);
        tr.setColWidthMap(isComputeAutoWidth || isCustomWidth ? new HashMap(contents.size()) : Collections.emptyMap());
        boolean isCommon = (index & 1) == 0;
        Map<String, String> tdStyle = isCommon ? this.commonTdStyle : this.evenTdStyle;
        Map<String, String> linkStyle = isCommon ? this.linkCommonStyle : this.linkEvenStyle;
        List<Td> tdList = IntStream.range(0, contents.size()).mapToObj(i -> {
            Td td = new Td(trIndex, i);
            Pair pair = (Pair)contents.get(i);
            td.setContent(pair.getValue() == null ? null : String.valueOf(pair.getValue()));
            Class fieldType = (Class)pair.getKey();
            this.setTdContentType(td, fieldType);
            if (!this.noStyle && !this.customStyle.isEmpty()) {
                Map<String, String> style = this.customStyle.getOrDefault("cell&" + i, Collections.emptyMap());
                td.setStyle(style);
            } else if (ContentTypeEnum.isLink(td.getTdContentType())) {
                td.setStyle(linkStyle);
            } else {
                td.setStyle(tdStyle);
            }
            if (isComputeAutoWidth) {
                tr.getColWidthMap().put(i, TdUtil.getStringWidth(td.getContent()));
            }
            return td;
        }).collect(Collectors.toList());
        if (isCustomWidth) {
            tr.setColWidthMap(this.customWidthMap);
        }
        tr.setTdList(tdList);
        return tr;
    }

    private void setTdContentType(Td td, Class fieldType) {
        if (String.class == fieldType) {
            return;
        }
        if (ReflectUtil.isNumber(fieldType)) {
            td.setTdContentType(ContentTypeEnum.DOUBLE);
            return;
        }
        if (ReflectUtil.isBool(fieldType)) {
            td.setTdContentType(ContentTypeEnum.BOOLEAN);
            return;
        }
        if (fieldType == DropDownList.class) {
            td.setTdContentType(ContentTypeEnum.DROP_DOWN_LIST);
            return;
        }
        if (fieldType == NumberDropDownList.class) {
            td.setTdContentType(ContentTypeEnum.NUMBER_DROP_DOWN_LIST);
            return;
        }
        if (fieldType == BooleanDropDownList.class) {
            td.setTdContentType(ContentTypeEnum.BOOLEAN_DROP_DOWN_LIST);
            return;
        }
        if (td.getContent() != null && fieldType == LinkUrl.class) {
            td.setTdContentType(ContentTypeEnum.LINK_URL);
            String[] splits = td.getContent().split("->");
            if (splits.length == 1) {
                td.setLink(td.getContent());
            } else {
                td.setContent(splits[0]);
                td.setLink(splits[1]);
            }
            return;
        }
        if (td.getContent() != null && fieldType == LinkEmail.class) {
            td.setTdContentType(ContentTypeEnum.LINK_EMAIL);
            String[] splits = td.getContent().split("->");
            if (splits.length == 1) {
                td.setLink(td.getContent());
            } else {
                td.setContent(splits[0]);
                td.setLink(splits[1]);
            }
        }
    }

    protected void initStyleMap() {
        if (this.noStyle) {
            this.linkEvenStyle = Collections.emptyMap();
            this.linkCommonStyle = this.linkEvenStyle;
            this.evenTdStyle = this.linkEvenStyle;
            this.commonTdStyle = this.linkEvenStyle;
        } else {
            this.commonTdStyle = new HashMap<String, String>(3);
            this.commonTdStyle.put("border-bottom-style", "thin");
            this.commonTdStyle.put("border-left-style", "thin");
            this.commonTdStyle.put("border-right-style", "thin");
            this.commonTdStyle.put("vertical-align", "middle");
            if (this.wrapText) {
                this.commonTdStyle.put("word-break", "break-all");
            }
            this.evenTdStyle = new HashMap<String, String>(4);
            this.evenTdStyle.put("background-color", "#f6f8fa");
            this.evenTdStyle.putAll(this.commonTdStyle);
            this.linkCommonStyle = new HashMap<String, String>(this.commonTdStyle);
            this.linkCommonStyle.put("color", "blue");
            this.linkCommonStyle.put("text-decoration", "underline");
            this.linkEvenStyle = new HashMap<String, String>(this.linkCommonStyle);
            this.linkEvenStyle.putAll(this.evenTdStyle);
        }
    }

    protected List<Field> getFilteredFields(ClassFieldContainer classFieldContainer, Class<?> ... groups) {
        ExcelTable excelTable = classFieldContainer.getClazz().getAnnotation(ExcelTable.class);
        boolean excelTableExist = Objects.nonNull(excelTable);
        boolean excludeParent = false;
        boolean includeAllField = false;
        boolean ignoreStaticFields = true;
        if (excelTableExist) {
            this.setWorkbookWithExcelTableAnnotation(excelTable);
            excludeParent = excelTable.excludeParent();
            includeAllField = excelTable.includeAllField();
            if (!excelTable.defaultValue().isEmpty()) {
                this.globalDefaultValue = excelTable.defaultValue();
            }
            this.wrapText = excelTable.wrapText();
            this.titleSeparator = excelTable.titleSeparator();
            ignoreStaticFields = excelTable.ignoreStaticFields();
        }
        List<Field> preElectionFields = this.getPreElectionFields(classFieldContainer, excludeParent, includeAllField);
        if (ignoreStaticFields) {
            preElectionFields = preElectionFields.stream().filter(field -> !Modifier.isStatic(field.getModifiers())).collect(Collectors.toList());
        }
        List selectedGroupList = Objects.nonNull(groups) ? Arrays.stream(groups).filter(Objects::nonNull).collect(Collectors.toList()) : Collections.emptyList();
        boolean useFieldNameAsTitle = excelTableExist && excelTable.useFieldNameAsTitle();
        ArrayList<String> titles = new ArrayList<String>(preElectionFields.size());
        List<Field> sortedFields = preElectionFields.stream().filter(field -> !field.isAnnotationPresent(ExcludeColumn.class) && this.filterFields(selectedGroupList, (Field)field)).sorted(this::sortFields).collect(Collectors.toList());
        this.defaultValueMap = new HashMap<Field, String>(preElectionFields.size());
        if (this.customWidthMap == null) {
            this.customWidthMap = new HashMap<Integer, Integer>(sortedFields.size());
        }
        boolean needToAddTitle = Objects.isNull(this.titles);
        int size = sortedFields.size();
        for (int i = 0; i < size; ++i) {
            Field field2 = (Field)sortedFields.get(i);
            ExcelColumn excelColumn = field2.getAnnotation(ExcelColumn.class);
            if (excelColumn != null) {
                if (needToAddTitle) {
                    if (useFieldNameAsTitle && excelColumn.title().isEmpty()) {
                        titles.add(field2.getName());
                    } else {
                        titles.add(excelColumn.title());
                    }
                }
                if (!excelColumn.defaultValue().isEmpty()) {
                    this.defaultValueMap.put(field2, excelColumn.defaultValue());
                }
                if (this.widths == null && excelColumn.width() > 0) {
                    this.customWidthMap.put(i, excelColumn.width());
                }
                if (this.noStyle || excelColumn.style().length <= 0) continue;
                this.setCustomStyle(i, excelColumn);
                continue;
            }
            if (!needToAddTitle) continue;
            if (useFieldNameAsTitle) {
                titles.add(field2.getName());
                continue;
            }
            titles.add(null);
        }
        boolean hasTitle = titles.stream().anyMatch(StringUtil::isNotBlank);
        if (hasTitle) {
            this.titles = titles;
        }
        return sortedFields;
    }

    private void setCustomStyle(int i, ExcelColumn excelColumn) {
        String[] styles;
        for (String style : styles = excelColumn.style()) {
            if (StringUtil.isBlank(style)) {
                throw new IllegalArgumentException("Illegal style");
            }
            String[] splits = style.split("->");
            if (splits.length == 1) {
                this.customStyle.put("cell&" + i, StyleUtil.parseStyle(splits[0]));
                break;
            }
            this.customStyle.put(splits[0] + "&" + i, StyleUtil.parseStyle(splits[1]));
        }
    }

    private List<Field> getPreElectionFields(ClassFieldContainer classFieldContainer, boolean excludeParent, boolean includeAllField) {
        if (Objects.nonNull(this.fieldDisplayOrder) && !this.fieldDisplayOrder.isEmpty()) {
            this.selfAdaption();
            return this.fieldDisplayOrder.stream().map(classFieldContainer::getFieldByName).collect(Collectors.toList());
        }
        if (includeAllField) {
            List<Field> preElectionFields = excludeParent ? classFieldContainer.getDeclaredFields() : classFieldContainer.getFields();
            return preElectionFields;
        }
        List<Field> preElectionFields = excludeParent ? classFieldContainer.getDeclaredFields().stream().filter(field -> field.isAnnotationPresent(ExcelColumn.class)).collect(Collectors.toList()) : classFieldContainer.getFieldsByAnnotation(ExcelColumn.class);
        return preElectionFields;
    }

    private boolean filterFields(List<Class<?>> selectedGroupList, Field field) {
        if (selectedGroupList.isEmpty()) {
            return true;
        }
        ExcelColumn excelColumn = field.getAnnotation(ExcelColumn.class);
        if (excelColumn == null) {
            return false;
        }
        Class<?>[] groupArr = excelColumn.groups();
        if (groupArr.length == 0) {
            return false;
        }
        List reservedGroupList = Arrays.stream(groupArr).collect(Collectors.toList());
        return reservedGroupList.stream().anyMatch(selectedGroupList::contains);
    }

    private int sortFields(Field field1, Field field2) {
        int defaultOrder;
        ExcelColumn excelColumn1 = field1.getAnnotation(ExcelColumn.class);
        ExcelColumn excelColumn2 = field2.getAnnotation(ExcelColumn.class);
        if (excelColumn1 == null && excelColumn2 == null) {
            return 0;
        }
        int order1 = defaultOrder = 0;
        if (excelColumn1 != null) {
            order1 = excelColumn1.order();
        }
        int order2 = defaultOrder;
        if (excelColumn2 != null) {
            order2 = excelColumn2.order();
        }
        if (order1 == order2) {
            return 0;
        }
        return order1 > order2 ? 1 : -1;
    }

    private void setWorkbookWithExcelTableAnnotation(ExcelTable excelTable) {
        String sheetName;
        int rowAccessWindowSize;
        if (this.workbookType == null) {
            this.workbookType = excelTable.workbookType();
        }
        if (this.rowAccessWindowSize <= 0 && (rowAccessWindowSize = excelTable.rowAccessWindowSize()) > 0) {
            this.rowAccessWindowSize = rowAccessWindowSize;
        }
        if (StringUtil.isBlank(this.sheetName) && StringUtil.isNotBlank(sheetName = excelTable.sheetName())) {
            this.sheetName = sheetName;
        }
    }

    private void selfAdaption() {
        if (this.titles == null || this.titles.isEmpty()) {
            return;
        }
        if (this.fieldDisplayOrder.size() > this.titles.size()) {
            int size = this.fieldDisplayOrder.size() - this.titles.size();
            for (int i = 0; i < size; ++i) {
                this.titles.add(null);
            }
        }
    }

    protected List<List<Pair<? extends Class, ?>>> getRenderContent(List<?> data, List<Field> sortedFields) {
        List resolvedDataContainers = IntStream.range(0, data.size()).parallel().mapToObj(index -> {
            List<Pair<Class, ?>> resolvedDataList = this.getRenderContent(data.get(index), sortedFields);
            return new ParallelContainer(index, resolvedDataList);
        }).collect(Collectors.toCollection(LinkedList::new));
        data.clear();
        return resolvedDataContainers.stream().sorted(Comparator.comparing(ParallelContainer::getIndex)).map(ParallelContainer::getData).collect(Collectors.toCollection(LinkedList::new));
    }

    protected <T> List<Pair<? extends Class, ?>> getRenderContent(T data, List<Field> sortedFields) {
        return sortedFields.stream().map(field -> {
            Pair<? extends Class, Object> value = WriteConverterContext.convert(field, data);
            if (value.getValue() != null) {
                return value;
            }
            String defaultValue = this.defaultValueMap.get(field);
            if (defaultValue != null) {
                return Pair.of(field.getType(), defaultValue);
            }
            if (this.globalDefaultValue != null) {
                return Pair.of(field.getType(), this.globalDefaultValue);
            }
            return value;
        }).collect(Collectors.toCollection(LinkedList::new));
    }
}

