/*
 * Decompiled with CFR 0.152.
 */
package com.github.liaochong.myexcel.core.converter.writer;

import com.github.liaochong.myexcel.core.annotation.ExcelColumn;
import com.github.liaochong.myexcel.core.constant.LinkEmail;
import com.github.liaochong.myexcel.core.constant.LinkType;
import com.github.liaochong.myexcel.core.constant.LinkUrl;
import com.github.liaochong.myexcel.core.container.Pair;
import com.github.liaochong.myexcel.core.converter.WriteConverter;
import java.lang.reflect.Field;

public class LinkWriteConverter
implements WriteConverter {
    @Override
    public Pair<Class, Object> convert(Field field, Object fieldVal) {
        LinkType linkType = field.getAnnotation(ExcelColumn.class).linkType();
        switch (linkType) {
            case URL: {
                return Pair.of(LinkUrl.class, fieldVal);
            }
            case EMAIL: {
                return Pair.of(LinkEmail.class, fieldVal);
            }
        }
        throw new IllegalArgumentException("Illegal linkType type, only URL or email");
    }

    @Override
    public boolean support(Field field, Object fieldVal) {
        ExcelColumn excelColumn = field.getAnnotation(ExcelColumn.class);
        return excelColumn != null && !LinkType.NONE.equals((Object)excelColumn.linkType());
    }
}

