/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.spring.quartz;

import com.github.ltsopensource.autoconfigure.PropertiesConfigurationFactory;
import com.github.ltsopensource.core.logger.Logger;
import com.github.ltsopensource.core.logger.LoggerFactory;
import com.github.ltsopensource.core.properties.JobClientProperties;
import com.github.ltsopensource.core.properties.TaskTrackerProperties;
import com.github.ltsopensource.spring.quartz.QuartzLTSConfig;
import com.github.ltsopensource.spring.quartz.QuartzLTSProxyAgent;
import com.github.ltsopensource.spring.quartz.QuartzProxyContext;
import com.github.ltsopensource.spring.quartz.QuartzSchedulerBeanRegistrar;
import org.springframework.beans.BeansException;
import org.springframework.beans.PropertyEditorRegistrar;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;

public class QuartzLTSProxyBean
implements BeanFactoryPostProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(QuartzLTSProxyBean.class);
    private boolean ltsEnable = true;
    private String[] locations;

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        if (this.ltsEnable) {
            LOGGER.info("========LTS====== Proxy Quartz Scheduler");
            JobClientProperties jobClientProperties = (JobClientProperties)PropertiesConfigurationFactory.createPropertiesConfiguration(JobClientProperties.class, (String[])this.locations);
            jobClientProperties.checkProperties();
            TaskTrackerProperties taskTrackerProperties = (TaskTrackerProperties)PropertiesConfigurationFactory.createPropertiesConfiguration(TaskTrackerProperties.class, (String[])this.locations);
            taskTrackerProperties.checkProperties();
            QuartzLTSConfig quartzLTSConfig = new QuartzLTSConfig();
            quartzLTSConfig.setJobClientProperties(jobClientProperties);
            quartzLTSConfig.setTaskTrackerProperties(taskTrackerProperties);
            QuartzLTSConfig.JobProperties jobProperties = (QuartzLTSConfig.JobProperties)PropertiesConfigurationFactory.createPropertiesConfiguration(QuartzLTSConfig.JobProperties.class, (String[])this.locations);
            quartzLTSConfig.setJobProperties(jobProperties);
            QuartzLTSProxyAgent agent = new QuartzLTSProxyAgent(quartzLTSConfig);
            QuartzProxyContext context = new QuartzProxyContext(quartzLTSConfig, agent);
            QuartzSchedulerBeanRegistrar registrar = new QuartzSchedulerBeanRegistrar(context);
            beanFactory.addPropertyEditorRegistrar((PropertyEditorRegistrar)registrar);
        }
    }

    public void setLtsEnable(boolean ltsEnable) {
        this.ltsEnable = ltsEnable;
    }

    public void setLocations(String ... locations) {
        this.locations = locations;
    }
}

