/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.spring.quartz;

import com.github.ltsopensource.core.logger.Logger;
import com.github.ltsopensource.core.logger.LoggerFactory;
import com.github.ltsopensource.spring.quartz.QuartzProxyContext;
import com.github.ltsopensource.spring.quartz.QuartzSchedulerBeanTargetEditor;
import java.beans.PropertyEditor;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.PropertyEditorRegistrar;
import org.springframework.beans.PropertyEditorRegistry;

class QuartzSchedulerBeanRegistrar
implements PropertyEditorRegistrar {
    private static final Logger LOGGER = LoggerFactory.getLogger(QuartzSchedulerBeanRegistrar.class);
    private static final String SchedulerFactoryBean = "org.springframework.scheduling.quartz.SchedulerFactoryBean";
    private QuartzProxyContext context;

    public QuartzSchedulerBeanRegistrar(QuartzProxyContext context) {
        this.context = context;
    }

    public void registerCustomEditors(PropertyEditorRegistry registry) {
        if (!(registry instanceof BeanWrapperImpl)) {
            return;
        }
        BeanWrapperImpl beanWrapper = (BeanWrapperImpl)registry;
        Class<?> clazz = null;
        try {
            clazz = Class.forName(SchedulerFactoryBean, true, registry.getClass().getClassLoader());
        }
        catch (Throwable e) {
            LOGGER.info("cannot find class for org.springframework.scheduling.quartz.SchedulerFactoryBean", e);
        }
        if (null == clazz || null == beanWrapper.getWrappedClass() || !clazz.isAssignableFrom(beanWrapper.getWrappedClass())) {
            return;
        }
        registry.registerCustomEditor(Object.class, "triggers", (PropertyEditor)new QuartzSchedulerBeanTargetEditor(this.context));
    }
}

