/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.spring.quartz;

import com.github.ltsopensource.core.logger.Logger;
import com.github.ltsopensource.core.logger.LoggerFactory;
import com.github.ltsopensource.spring.quartz.QuartzJobContext;
import com.github.ltsopensource.spring.quartz.QuartzJobType;
import com.github.ltsopensource.spring.quartz.QuartzProxyContext;
import com.github.ltsopensource.spring.quartz.QuartzProxyException;
import com.github.ltsopensource.spring.quartz.invoke.JobDetailJobExecution;
import com.github.ltsopensource.spring.quartz.invoke.MethodInvokeJobExecution;
import java.beans.PropertyEditorSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.Trigger;
import org.quartz.impl.triggers.CronTriggerImpl;
import org.quartz.impl.triggers.SimpleTriggerImpl;
import org.springframework.util.MethodInvoker;

class QuartzSchedulerBeanTargetEditor
extends PropertyEditorSupport {
    private static final Logger LOGGER = LoggerFactory.getLogger(QuartzSchedulerBeanTargetEditor.class);
    private QuartzProxyContext context;

    public QuartzSchedulerBeanTargetEditor(QuartzProxyContext context) {
        this.context = context;
    }

    @Override
    public void setValue(Object value) {
        ArrayList<Trigger> nativeQuartzTriggers = new ArrayList<Trigger>();
        if (value != null && value instanceof Collection) {
            Collection triggers = (Collection)value;
            ArrayList<QuartzJobContext> quartzJobContexts = new ArrayList<QuartzJobContext>(triggers.size());
            for (Trigger trigger : triggers) {
                if (trigger instanceof CronTriggerImpl) {
                    quartzJobContexts.add(this.buildQuartzCronJob((CronTriggerImpl)trigger));
                    continue;
                }
                if (trigger instanceof SimpleTriggerImpl) {
                    quartzJobContexts.add(this.buildQuartzSimpleJob((SimpleTriggerImpl)trigger));
                    continue;
                }
                LOGGER.warn("Can't Proxy " + trigger.getClass().getName() + " Then Use Quartz Scheduler");
                nativeQuartzTriggers.add(trigger);
            }
            this.context.getAgent().startProxy(quartzJobContexts);
        }
        super.setValue(nativeQuartzTriggers);
    }

    private QuartzJobContext buildQuartzCronJob(CronTriggerImpl cronTrigger) {
        QuartzJobContext quartzJobContext = new QuartzJobContext();
        quartzJobContext.setTrigger((Trigger)cronTrigger);
        quartzJobContext.setType(QuartzJobType.CRON);
        quartzJobContext.setName(cronTrigger.getName());
        this.buildQuartzJobContext(quartzJobContext, (Trigger)cronTrigger);
        return quartzJobContext;
    }

    private QuartzJobContext buildQuartzSimpleJob(SimpleTriggerImpl simpleTrigger) {
        QuartzJobContext quartzJobContext = new QuartzJobContext();
        quartzJobContext.setTrigger((Trigger)simpleTrigger);
        quartzJobContext.setName(simpleTrigger.getName());
        quartzJobContext.setType(QuartzJobType.SIMPLE_REPEAT);
        this.buildQuartzJobContext(quartzJobContext, (Trigger)simpleTrigger);
        return quartzJobContext;
    }

    private QuartzJobContext buildQuartzJobContext(QuartzJobContext quartzJobContext, Trigger trigger) {
        JobDataMap triggerJobDataMap = trigger.getJobDataMap();
        JobDetail jobDetail = (JobDetail)triggerJobDataMap.get((Object)"jobDetail");
        MethodInvoker methodInvoker = (MethodInvoker)jobDetail.getJobDataMap().get((Object)"methodInvoker");
        HashMap<String, Object> jobDataMap = new HashMap<String, Object>();
        jobDataMap.putAll((Map<String, Object>)triggerJobDataMap);
        jobDataMap.putAll((Map<String, Object>)jobDetail.getJobDataMap());
        jobDataMap.remove("jobDetail");
        jobDataMap.remove("methodInvoker");
        quartzJobContext.setJobDataMap(jobDataMap);
        if (methodInvoker != null) {
            quartzJobContext.setJobExecution(new MethodInvokeJobExecution(methodInvoker));
        } else {
            Class jobClass = jobDetail.getJobClass();
            try {
                Job job = (Job)jobClass.newInstance();
                quartzJobContext.setJobExecution(new JobDetailJobExecution(job));
            }
            catch (Exception e) {
                throw new QuartzProxyException("Instance JobClass[" + (jobClass == null ? null : jobClass.getName()) + "] error", e);
            }
        }
        return quartzJobContext;
    }
}

