/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.spring.tasktracker;

import com.github.ltsopensource.core.commons.utils.StringUtils;
import com.github.ltsopensource.spring.tasktracker.JobRunnerBuilder;
import com.github.ltsopensource.spring.tasktracker.JobRunnerHolder;
import java.lang.reflect.Method;
import org.springframework.beans.factory.InitializingBean;

public class MethodInvokingJobRunner
implements InitializingBean {
    private Object targetObject;
    private String targetMethod;
    private String shardValue;

    public void afterPropertiesSet() throws Exception {
        if (this.targetObject == null) {
            throw new IllegalArgumentException("targetObject can not be null");
        }
        if (StringUtils.isEmpty((String)this.targetMethod)) {
            throw new IllegalArgumentException("targetMethod can not be null");
        }
        if (StringUtils.isEmpty((String)this.shardValue)) {
            throw new IllegalArgumentException("shardValue can not be null");
        }
        Class<?> clazz = this.targetObject.getClass();
        Method[] methods = clazz.getMethods();
        Method method = null;
        if (methods != null && methods.length > 0) {
            for (Method m : methods) {
                if (!m.getName().equals(this.targetMethod)) continue;
                if (method != null) {
                    throw new IllegalArgumentException("Duplicate targetMethod can not be found in " + this.targetObject.getClass().getName());
                }
                method = m;
            }
        }
        if (method == null) {
            throw new IllegalArgumentException("targetMethod can not be found in " + this.targetObject.getClass().getName());
        }
        JobRunnerHolder.add(this.shardValue, JobRunnerBuilder.build(this.targetObject, method, method.getParameterTypes()));
    }

    public void setTargetObject(Object targetObject) {
        this.targetObject = targetObject;
    }

    public void setTargetMethod(String targetMethod) {
        this.targetMethod = targetMethod;
    }

    public void setShardValue(String shardValue) {
        this.shardValue = shardValue;
    }
}

