/*
 * Decompiled with CFR 0.152.
 */
package com.github.microwww.redis.database;

import com.github.microwww.redis.database.AbstractValueData;
import com.github.microwww.redis.database.Bytes;
import com.github.microwww.redis.database.DataLock;
import com.github.microwww.redis.database.HashKey;
import com.github.microwww.redis.database.RedisDatabase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.function.Function;
import java.util.stream.Collectors;

public class SetData
extends AbstractValueData<Set<Bytes>>
implements DataLock {
    private final Set<Bytes> origin;

    public SetData() {
        this(-1);
    }

    public SetData(int exp) {
        this(new ConcurrentSkipListSet<Bytes>(), exp);
    }

    public SetData(Set<Bytes> origin, int exp) {
        this.origin = origin;
        this.data = Collections.unmodifiableSet(this.origin);
        this.expire = exp;
    }

    @Override
    public String getType() {
        return "set";
    }

    public synchronized int add(Bytes ... bytes) {
        int i = 0;
        for (Bytes a : bytes) {
            boolean success = this.origin.add(a);
            if (!success) continue;
            ++i;
        }
        if (bytes.length > 0) {
            this.version.incrementAndGet();
        }
        return i;
    }

    public synchronized Set<Bytes> diff(RedisDatabase db, HashKey[] ms) {
        HashSet<Bytes> origin = new HashSet<Bytes>(this.origin);
        for (HashKey m : ms) {
            Optional<SetData> sd = db.get(m, SetData.class);
            sd.ifPresent(ee -> origin.removeAll((Collection)ee.getData()));
        }
        return origin;
    }

    public synchronized SetData diffStore(RedisDatabase db, HashKey dest, HashKey[] ms) {
        Set<Bytes> diff = this.diff(db, ms);
        SetData target = new SetData();
        db.put(dest, target);
        target.origin.addAll(diff);
        return target;
    }

    public synchronized Set<Bytes> interStore(RedisDatabase db, HashKey[] ms) {
        Optional<SetData> first = db.get(ms[0], SetData.class);
        if (!first.isPresent()) {
            return Collections.emptySet();
        }
        Map collect = ((Set)first.get().getData()).stream().collect(Collectors.groupingBy(Function.identity()));
        for (int i = 1; i < ms.length; ++i) {
            Optional<SetData> sd = db.get(ms[i], SetData.class);
            if (!sd.isPresent()) {
                return Collections.emptySet();
            }
            ((Set)sd.get().getData()).forEach(e -> {
                List list = (List)collect.get(e);
                if (list != null) {
                    list.add(e);
                }
            });
        }
        collect.forEach((k, v) -> {
            if (v.size() == ms.length) {
                this.origin.add((Bytes)k);
            }
        });
        return (Set)this.getData();
    }

    public boolean move(RedisDatabase db, HashKey dest, Bytes member) {
        boolean remove = this.origin.remove(member);
        if (remove) {
            this.version.incrementAndGet();
            SetData oc = db.getOrCreate(dest, SetData::new);
            oc.sync(() -> oc.origin.add(member));
        }
        return remove;
    }

    public synchronized List<Bytes> pop(int count) {
        List<Bytes> bytes = this.randMember(count);
        this.origin.removeAll(bytes);
        if (!bytes.isEmpty()) {
            this.version.incrementAndGet();
        }
        return bytes;
    }

    public List<Bytes> randMember(int len) {
        ArrayList<Bytes> list = new ArrayList<Bytes>(this.origin);
        for (int i = 0; i < len && i < list.size(); ++i) {
            int exchange = (int)(Math.random() * (double)list.size());
            list.set(i, (Bytes)list.set(exchange, (Bytes)list.get(i)));
        }
        return list.subList(0, len);
    }

    public List<Bytes> random(int len) {
        ArrayList<Bytes> list = new ArrayList<Bytes>(this.origin);
        ArrayList<Bytes> res = new ArrayList<Bytes>();
        for (int i = 0; i < len; ++i) {
            int ex = (int)(Math.random() * (double)list.size());
            res.add((Bytes)list.get(ex));
        }
        return res;
    }

    public synchronized int removeAll(Bytes ... os) {
        int count = 0;
        for (Bytes o : os) {
            boolean rm = this.origin.remove(o);
            if (!rm) continue;
            ++count;
        }
        if (count > 0) {
            this.version.incrementAndGet();
        }
        return count;
    }

    public synchronized Set<Bytes> union(RedisDatabase db, HashKey[] keys) {
        for (int i = 0; i < keys.length; ++i) {
            db.get(keys[i], SetData.class).ifPresent(e -> this.origin.addAll((Collection)e.getData()));
        }
        return (Set)this.getData();
    }
}

