/*
 * Decompiled with CFR 0.152.
 */
package com.github.microwww.redis.exception;

import com.github.microwww.redis.logger.Logger;
import java.util.concurrent.Callable;

@FunctionalInterface
public interface Run {
    public void run() throws Exception;

    public static void ignoreException(Logger logger, Run running) {
        try {
            running.run();
        }
        catch (Exception ex) {
            logger.warn("Sever Exception : {}", ex);
        }
    }

    public static void silentException(Run running) {
        try {
            running.run();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void wrapRunTimeException(Run running, String error) {
        try {
            running.run();
        }
        catch (Exception ex) {
            throw new RuntimeException(error, ex);
        }
    }

    public static Object wrapRunTimeException(Callable run, String error) {
        try {
            return run.call();
        }
        catch (Exception e) {
            throw new RuntimeException(error, e);
        }
    }

    public static <T> T wrapRunTimeException(Callable run, Class<T> clazz, String error) {
        try {
            return (T)run.call();
        }
        catch (Exception e) {
            throw new RuntimeException(error, e);
        }
    }
}

