/*
 * Decompiled with CFR 0.152.
 */
package com.github.microwww.redis.protocal.jedis;

import com.github.microwww.redis.protocal.jedis.JedisDataException;
import com.github.microwww.redis.protocal.jedis.JedisException;
import java.io.UnsupportedEncodingException;

public final class SafeEncoder {
    private SafeEncoder() {
        throw new InstantiationError("Must not instantiate this class");
    }

    public static byte[][] encodeMany(String ... strs) {
        byte[][] many = new byte[strs.length][];
        for (int i = 0; i < strs.length; ++i) {
            many[i] = SafeEncoder.encode(strs[i]);
        }
        return many;
    }

    public static byte[] encode(String str) {
        try {
            if (str == null) {
                throw new JedisDataException("value sent to redis cannot be null");
            }
            return str.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new JedisException(e);
        }
    }

    public static String encode(byte[] data) {
        try {
            return new String(data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new JedisException(e);
        }
    }
}

