/*
 * Decompiled with CFR 0.152.
 */
package com.github.microwww.redis.protocal.message;

import com.github.microwww.redis.protocal.HalfPackException;
import com.github.microwww.redis.protocal.message.AttrMessage;
import com.github.microwww.redis.protocal.message.BigIntMessage;
import com.github.microwww.redis.protocal.message.BooleanMessage;
import com.github.microwww.redis.protocal.message.BytesMessage;
import com.github.microwww.redis.protocal.message.DoubleMessage;
import com.github.microwww.redis.protocal.message.EOFMessage;
import com.github.microwww.redis.protocal.message.ErrorMessage;
import com.github.microwww.redis.protocal.message.LongMessage;
import com.github.microwww.redis.protocal.message.MapMessage;
import com.github.microwww.redis.protocal.message.MultiMessage;
import com.github.microwww.redis.protocal.message.NullMessage;
import com.github.microwww.redis.protocal.message.PushMessage;
import com.github.microwww.redis.protocal.message.RedisMessage;
import com.github.microwww.redis.protocal.message.SetsMessage;
import com.github.microwww.redis.protocal.message.StringMessage;
import com.github.microwww.redis.protocal.message.VerbatimMessage;
import com.github.microwww.redis.util.Assert;
import com.github.microwww.redis.util.SafeEncoder;
import java.nio.ByteBuffer;
import java.util.ArrayList;

public enum Type {
    STATUS('+'){

        @Override
        public StringMessage read(ByteBuffer bytes) {
            return new StringMessage(this, Type.readToCRLF(bytes));
        }
    }
    ,
    ERROR('-'){

        @Override
        public ErrorMessage read(ByteBuffer bytes) {
            return new ErrorMessage(this, Type.readToCRLF(bytes));
        }
    }
    ,
    ERRORS('!'){

        @Override
        public ErrorMessage read(ByteBuffer bytes) {
            return new ErrorMessage(this, BULK.read(bytes).getBytes());
        }
    }
    ,
    LONG(':'){

        @Override
        public LongMessage read(ByteBuffer bytes) {
            return new LongMessage(this, Type.readToCRLF(bytes));
        }
    }
    ,
    EOF('.'){

        @Override
        public EOFMessage read(ByteBuffer bytes) {
            Type.gotoCRLF(bytes);
            return new EOFMessage(this);
        }
    }
    ,
    GO_ON(';'){

        @Override
        public RedisMessage read(ByteBuffer bytes) {
            int len = Integer.parseInt(SafeEncoder.encode(6.readInt(bytes)));
            if (len <= 0) {
                return new EOFMessage(this);
            }
            byte[] bts = 6.readDataSkipCRLF(bytes, len);
            return new BytesMessage(this, bts);
        }
    }
    ,
    BULK('$'){

        @Override
        public StringMessage read(ByteBuffer bytes) {
            String s = new String(Type.readToCRLF(bytes));
            if ("?".equalsIgnoreCase(s)) {
                StringBuilder sb = new StringBuilder();
                while (true) {
                    7.assertNotHalf(bytes, "$? GO-ON");
                    RedisMessage r = Type.parseOne(bytes);
                    if (r instanceof EOFMessage) break;
                    Assert.isTrue(r instanceof BytesMessage, ";<NUMBER><CR><LF>");
                    sb.append(SafeEncoder.encode(r.getBytes()));
                }
                return new StringMessage(this, SafeEncoder.encode(sb.toString()));
            }
            int count = Integer.parseInt(s);
            if (count >= 0) {
                byte[] data = 7.readDataSkipCRLF(bytes, count);
                return new StringMessage(this, data);
            }
            return new StringMessage(this, null);
        }
    }
    ,
    MULTI('*'){

        @Override
        public MultiMessage read(ByteBuffer bytes) {
            String s = new String(Type.readToCRLF(bytes));
            if ("?".equalsIgnoreCase(s)) {
                ArrayList<RedisMessage> list = new ArrayList<RedisMessage>();
                while (true) {
                    8.assertNotHalf(bytes, "*? GO-ON");
                    RedisMessage r = Type.parseOne(bytes);
                    if (r instanceof EOFMessage) break;
                    list.add(r);
                }
                return new MultiMessage((Type)this, list.toArray(new RedisMessage[0]));
            }
            int count = Integer.parseInt(s);
            if (count >= 0) {
                if (count == 0) {
                    Type.readToCRLF(bytes);
                    return new MultiMessage((Type)this, new RedisMessage[0]);
                }
                RedisMessage[] pks = new RedisMessage[count];
                int i = 0;
                while (true) {
                    pks[i] = 8.parseOne(bytes);
                    if (i + 1 == count) {
                        return new MultiMessage((Type)this, pks);
                    }
                    ++i;
                }
            }
            return null;
        }
    }
    ,
    NULL('_'){

        @Override
        public NullMessage read(ByteBuffer bytes) {
            byte[] n = Type.readToCRLF(bytes);
            Assert.isTrue(n.length == 0, "`_<CR><LF>`");
            return new NullMessage(this);
        }
    }
    ,
    DECIMAL(','){

        @Override
        public DoubleMessage read(ByteBuffer bytes) {
            return new DoubleMessage(this, Type.readToCRLF(bytes));
        }
    }
    ,
    BOOLEAN('#'){

        @Override
        public BooleanMessage read(ByteBuffer bytes) {
            byte[] bts = Type.readToCRLF(bytes);
            return new BooleanMessage(this, bts);
        }
    }
    ,
    VERBATIM('='){

        @Override
        public VerbatimMessage read(ByteBuffer bytes) {
            byte[] len = Type.readToCRLF(bytes);
            byte[] bts = Type.readDataSkipCRLF(bytes, Integer.parseInt(new String(len)));
            return new VerbatimMessage(this, bts);
        }
    }
    ,
    BigInt('('){

        @Override
        public BigIntMessage read(ByteBuffer bytes) {
            return new BigIntMessage(this, Type.readToCRLF(bytes));
        }
    }
    ,
    MAP('%'){

        @Override
        public MapMessage read(ByteBuffer bytes) {
            byte[] rf = Type.readToCRLF(bytes);
            int count = Integer.parseInt(new String(rf));
            RedisMessage[] ns = new RedisMessage[count * 2];
            for (int i = 0; i < ns.length; ++i) {
                ns[i] = 14.parseOne(bytes);
            }
            return new MapMessage((Type)this, ns);
        }
    }
    ,
    SETS('~'){

        @Override
        public SetsMessage read(ByteBuffer bytes) {
            RedisMessage read = MULTI.read(bytes);
            return new SetsMessage((Type)this, read.getRedisMessages());
        }
    }
    ,
    ATTR('|'){

        @Override
        public RedisMessage read(ByteBuffer bytes) {
            RedisMessage m = MAP.read(bytes);
            AttrMessage arr = new AttrMessage((Type)this, m.getRedisMessages());
            16.assertNotHalf(bytes, "Attr must has next data");
            RedisMessage one = Type.parseOne(bytes);
            return one.setAttr(arr);
        }
    }
    ,
    PUSH('>'){

        @Override
        public PushMessage read(ByteBuffer bytes) {
            RedisMessage rm = MULTI.read(bytes);
            return new PushMessage((Type)this, rm.getRedisMessages());
        }
    };

    public final char prefix;
    public static final char CR = '\r';
    public static final char LF = '\n';

    public abstract RedisMessage read(ByteBuffer var1);

    private Type(char prefix) {
        this.prefix = prefix;
    }

    public static void assertNotHalf(ByteBuffer bytes, String message) {
        if (bytes.remaining() <= 0) {
            throw new HalfPackException(message);
        }
    }

    public static RedisMessage parseOne(ByteBuffer bytes) throws HalfPackException {
        Type.assertNotHalf(bytes, "No data to parse");
        byte bt = bytes.get();
        for (Type parse : Type.values()) {
            if (parse.prefix != bt) continue;
            return parse.read(bytes);
        }
        throw new IllegalArgumentException("Not support type: " + (char)bt);
    }

    public static int gotoCRLF(ByteBuffer bytes) throws HalfPackException {
        block0: while (bytes.remaining() > 0) {
            byte bt = bytes.get();
            while (bt == 13 && bytes.remaining() > 0) {
                bt = bytes.get();
                if (bt == 10) {
                    return bytes.position();
                }
                if (bt != 13) continue block0;
            }
        }
        throw new HalfPackException();
    }

    public static byte[] readToCRLF(ByteBuffer bytes) {
        int start = bytes.position();
        int to = Type.gotoCRLF(bytes);
        if (to < 0) {
            return null;
        }
        return Type.getData(bytes, start, to - 2);
    }

    public static byte[] readInt(ByteBuffer bytes) {
        byte[] bts = Type.readToCRLF(bytes);
        if (bts == null) {
            return new byte[0];
        }
        return bts;
    }

    public static byte[] readDataSkipCRLF(ByteBuffer bytes, int length) {
        if (bytes.remaining() < length + 2) {
            throw new HalfPackException("Read length: " + length);
        }
        int pt = bytes.position();
        byte[] data = Type.getData(bytes, pt, pt + length);
        bytes.position(pt + length);
        Assert.isTrue(13 == bytes.get(), "end with CR LF");
        Assert.isTrue(10 == bytes.get(), "end with CR LF");
        return data;
    }

    public static byte[] getData(ByteBuffer bytes, int from, int to) {
        if (bytes.limit() < to) {
            throw new HalfPackException();
        }
        byte[] bs = new byte[to - from];
        for (int i = 0; i < bs.length; ++i) {
            bs[i] = bytes.get(from + i);
        }
        return bs;
    }
}

