/*
 * Decompiled with CFR 0.152.
 */
package com.power.doc.utils;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.power.common.model.EnumDictionary;
import com.power.common.util.CollectionUtil;
import com.power.common.util.StringUtil;
import com.power.doc.model.ApiConfig;
import com.power.doc.model.ApiDocDict;
import com.power.doc.model.ApiErrorCode;
import com.power.doc.model.ApiMethodDoc;
import com.power.doc.model.ApiParam;
import com.power.doc.model.ApiReqParam;
import com.power.doc.model.DataDict;
import com.power.doc.model.JavaMethodDoc;
import com.power.doc.model.rpc.RpcApiDependency;
import com.power.doc.model.torna.Apis;
import com.power.doc.model.torna.CommonErrorCode;
import com.power.doc.model.torna.DebugEnv;
import com.power.doc.model.torna.HttpParam;
import com.power.doc.model.torna.TornaApi;
import com.power.doc.model.torna.TornaDic;
import com.power.doc.model.torna.TornaRequestInfo;
import com.power.doc.utils.DocUtil;
import com.power.doc.utils.JavaClassValidateUtil;
import com.thoughtworks.qdox.JavaProjectBuilder;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaParameter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class TornaUtil {
    public static boolean setDebugEnv(ApiConfig apiConfig, TornaApi tornaApi) {
        boolean hasDebugEnv = StringUtils.isNotBlank((CharSequence)apiConfig.getDebugEnvName()) && StringUtils.isNotBlank((CharSequence)apiConfig.getDebugEnvUrl());
        ArrayList<DebugEnv> debugEnvs = new ArrayList<DebugEnv>();
        if (hasDebugEnv) {
            DebugEnv debugEnv = new DebugEnv();
            debugEnv.setName(apiConfig.getDebugEnvName());
            debugEnv.setUrl(apiConfig.getDebugEnvUrl());
            debugEnvs.add(debugEnv);
        }
        tornaApi.setDebugEnvs(debugEnvs);
        return hasDebugEnv;
    }

    public static void printDebugInfo(ApiConfig apiConfig, String responseMsg, Map<String, String> requestJson, String category) {
        if (apiConfig.isTornaDebug()) {
            String sb = "Configuration information : \nOpenUrl: " + apiConfig.getOpenUrl() + "\nappToken: " + apiConfig.getAppToken() + "\n";
            System.out.println(sb);
            try {
                JsonElement element = JsonParser.parseString((String)responseMsg);
                TornaRequestInfo info = new TornaRequestInfo().of().setCategory(category).setCode(element.getAsJsonObject().get("code").getAsString()).setMessage(element.getAsJsonObject().get("msg").getAsString()).setRequestInfo(requestJson).setResponseInfo(responseMsg);
                System.out.println(info.buildInfo());
            }
            catch (Exception e) {
                System.out.println("Response Error : \n" + responseMsg);
            }
        }
    }

    public static List<Apis> buildApis(List<ApiMethodDoc> apiMethodDocs, boolean hasDebugEnv) {
        ArrayList<Apis> apis = new ArrayList<Apis>();
        for (ApiMethodDoc apiMethodDoc : apiMethodDocs) {
            Apis methodApi = new Apis();
            methodApi.setIsFolder("0");
            methodApi.setName(apiMethodDoc.getDesc());
            methodApi.setUrl(hasDebugEnv ? TornaUtil.subFirstUrlOrPath(apiMethodDoc.getPath()) : TornaUtil.subFirstUrlOrPath(apiMethodDoc.getUrl()));
            methodApi.setHttpMethod(apiMethodDoc.getType());
            methodApi.setContentType(apiMethodDoc.getContentType());
            methodApi.setDescription(apiMethodDoc.getDetail());
            methodApi.setIsShow("1");
            methodApi.setAuthor(apiMethodDoc.getAuthor());
            methodApi.setOrderIndex(apiMethodDoc.getOrder());
            methodApi.setHeaderParams(TornaUtil.buildHerder(apiMethodDoc.getRequestHeaders()));
            methodApi.setResponseParams(TornaUtil.buildParams(apiMethodDoc.getResponseParams()));
            methodApi.setIsRequestArray(apiMethodDoc.getIsRequestArray());
            methodApi.setIsResponseArray(apiMethodDoc.getIsResponseArray());
            methodApi.setRequestArrayType(apiMethodDoc.getRequestArrayType());
            methodApi.setResponseArrayType(apiMethodDoc.getResponseArrayType());
            methodApi.setDeprecated(apiMethodDoc.isDeprecated() ? "\u8be5\u63a5\u53e3\u5df2\u5e9f\u5f03" : null);
            if (CollectionUtil.isNotEmpty(apiMethodDoc.getPathParams())) {
                methodApi.setPathParams(TornaUtil.buildParams(apiMethodDoc.getPathParams()));
            }
            if (CollectionUtil.isNotEmpty(apiMethodDoc.getQueryParams()) && "multipart/form-data".equals(apiMethodDoc.getContentType())) {
                methodApi.setRequestParams(TornaUtil.buildParams(apiMethodDoc.getQueryParams()));
            } else if (CollectionUtil.isNotEmpty(apiMethodDoc.getQueryParams())) {
                methodApi.setQueryParams(TornaUtil.buildParams(apiMethodDoc.getQueryParams()));
            }
            if (CollectionUtil.isNotEmpty(apiMethodDoc.getRequestParams())) {
                methodApi.setRequestParams(TornaUtil.buildParams(apiMethodDoc.getRequestParams()));
            }
            apis.add(methodApi);
        }
        return apis;
    }

    public static List<Apis> buildDubboApis(List<JavaMethodDoc> apiMethodDocs) {
        ArrayList<Apis> apis = new ArrayList<Apis>();
        for (JavaMethodDoc apiMethodDoc : apiMethodDocs) {
            Apis methodApi = new Apis();
            methodApi.setIsFolder("0");
            methodApi.setName(apiMethodDoc.getDesc());
            methodApi.setDescription(apiMethodDoc.getDetail());
            methodApi.setIsShow("1");
            methodApi.setAuthor(apiMethodDoc.getAuthor());
            methodApi.setUrl(apiMethodDoc.getMethodDefinition());
            methodApi.setResponseParams(TornaUtil.buildParams(apiMethodDoc.getResponseParams()));
            methodApi.setOrderIndex(apiMethodDoc.getOrder());
            methodApi.setDeprecated(apiMethodDoc.isDeprecated() ? "Deprecated" : null);
            if (CollectionUtil.isNotEmpty(apiMethodDoc.getRequestParams())) {
                methodApi.setRequestParams(TornaUtil.buildParams(apiMethodDoc.getRequestParams()));
            }
            apis.add(methodApi);
        }
        return apis;
    }

    public static List<HttpParam> buildHerder(List<ApiReqParam> apiReqParams) {
        ArrayList<HttpParam> headers = new ArrayList<HttpParam>();
        for (ApiReqParam header : apiReqParams) {
            HttpParam httpParam = new HttpParam();
            httpParam.setName(header.getName());
            httpParam.setRequired(header.isRequired() ? "1" : "0");
            httpParam.setExample(StringUtil.removeQuotes((String)header.getValue()));
            httpParam.setDescription(header.getDesc());
            headers.add(httpParam);
        }
        return headers;
    }

    public static List<HttpParam> buildParams(List<ApiParam> apiParams) {
        ArrayList<HttpParam> bodies = new ArrayList<HttpParam>();
        for (ApiParam apiParam : apiParams) {
            HttpParam httpParam = new HttpParam();
            httpParam.setName(apiParam.getField());
            httpParam.setOrderIndex(apiParam.getId());
            httpParam.setMaxLength(apiParam.getMaxLength());
            String type = apiParam.getType();
            if (Objects.equals(type, "file") && apiParam.isHasItems()) {
                type = "file[]";
            }
            httpParam.setType(type);
            httpParam.setRequired(apiParam.isRequired() ? "1" : "0");
            httpParam.setExample(StringUtil.removeQuotes((String)apiParam.getValue()));
            httpParam.setDescription(DocUtil.replaceNewLineToHtmlBr(apiParam.getDesc()));
            httpParam.setEnumInfo(apiParam.getEnumInfo());
            if (apiParam.getChildren() != null) {
                httpParam.setChildren(TornaUtil.buildParams(apiParam.getChildren()));
            }
            bodies.add(httpParam);
        }
        return bodies;
    }

    public static String buildDependencies(List<RpcApiDependency> dependencies) {
        StringBuilder s = new StringBuilder();
        if (CollectionUtil.isNotEmpty(dependencies)) {
            for (RpcApiDependency r : dependencies) {
                s.append(r.toString()).append("\n\n");
            }
        }
        return s.toString();
    }

    public static List<CommonErrorCode> buildErrorCode(ApiConfig config, JavaProjectBuilder javaProjectBuilder) {
        ArrayList<CommonErrorCode> commonErrorCodes = new ArrayList<CommonErrorCode>();
        List<ApiErrorCode> errorCodes = DocUtil.errorCodeDictToList(config, javaProjectBuilder);
        if (CollectionUtil.isNotEmpty(errorCodes)) {
            for (EnumDictionary enumDictionary : errorCodes) {
                CommonErrorCode commonErrorCode = new CommonErrorCode();
                commonErrorCode.setCode(enumDictionary.getValue());
                commonErrorCode.setMsg(DocUtil.replaceNewLineToHtmlBr(enumDictionary.getDesc()));
                commonErrorCodes.add(commonErrorCode);
            }
        }
        return commonErrorCodes;
    }

    public static List<TornaDic> buildTornaDic(List<ApiDocDict> apiDocDicts) {
        ArrayList<TornaDic> dics = new ArrayList<TornaDic>();
        if (CollectionUtil.isNotEmpty(apiDocDicts)) {
            for (ApiDocDict doc : apiDocDicts) {
                TornaDic tornaDic = new TornaDic();
                tornaDic.setName(doc.getTitle()).setDescription(DocUtil.replaceNewLineToHtmlBr(doc.getDescription())).setItems(TornaUtil.buildTornaDicItems(doc.getDataDictList()));
                dics.add(tornaDic);
            }
        }
        return dics;
    }

    private static List<HttpParam> buildTornaDicItems(List<DataDict> dataDicts) {
        ArrayList<HttpParam> apis = new ArrayList<HttpParam>();
        if (CollectionUtil.isNotEmpty(dataDicts)) {
            for (EnumDictionary enumDictionary : dataDicts) {
                HttpParam api = new HttpParam();
                api.setName(enumDictionary.getName());
                api.setType(enumDictionary.getType());
                api.setValue(enumDictionary.getValue());
                api.setDescription(enumDictionary.getDesc());
                apis.add(api);
            }
        }
        return apis;
    }

    public static void setTornaArrayTags(List<JavaParameter> javaParameters, ApiMethodDoc apiMethodDoc, JavaClass returnClass, ApiConfig apiConfig) {
        apiMethodDoc.setIsResponseArray(0);
        apiMethodDoc.setIsRequestArray(0);
        if ((JavaClassValidateUtil.isCollection(returnClass.getFullyQualifiedName()) || JavaClassValidateUtil.isArray(returnClass.getFullyQualifiedName())) && apiConfig.getResponseBodyAdvice() == null) {
            apiMethodDoc.setIsResponseArray(1);
            String typeName = returnClass.getGenericFullyQualifiedName();
            String gicType = TornaUtil.getType(typeName);
            String simpleGicType = gicType.substring(gicType.lastIndexOf(".") + 1).toLowerCase();
            apiMethodDoc.setResponseArrayType(JavaClassValidateUtil.isPrimitive(gicType) ? simpleGicType : "object");
        }
        if (CollectionUtil.isNotEmpty(javaParameters) && apiConfig.getRequestBodyAdvice() == null) {
            for (JavaParameter parameter : javaParameters) {
                String typeName = parameter.getType().getGenericFullyQualifiedName();
                String name = parameter.getType().getFullyQualifiedName();
                String gicType = TornaUtil.getType(typeName);
                String simpleGicType = gicType.substring(gicType.lastIndexOf(".") + 1).toLowerCase();
                if (!JavaClassValidateUtil.isCollection(name) && !JavaClassValidateUtil.isArray(name)) continue;
                apiMethodDoc.setIsRequestArray(1);
                if (JavaClassValidateUtil.isPrimitive(gicType)) {
                    apiMethodDoc.setRequestArrayType(simpleGicType);
                    continue;
                }
                apiMethodDoc.setRequestArrayType("object");
            }
        }
    }

    private static String getType(String typeName) {
        String gicType = typeName.contains("<") ? typeName.substring(typeName.indexOf("<") + 1, typeName.lastIndexOf(">")) : typeName;
        if (gicType.contains("[")) {
            gicType = gicType.substring(0, gicType.indexOf("["));
        }
        return gicType;
    }

    private static String subFirstUrlOrPath(String url) {
        if (StringUtil.isEmpty((String)url)) {
            return "";
        }
        if (!url.contains(";\t")) {
            return url;
        }
        String[] split = StringUtil.split((String)url, (String)";\t");
        return split[0];
    }
}

