/*
 * Decompiled with CFR 0.152.
 */
package com.github.tjake.jlama.tensor.operations.util;

import java.lang.foreign.MemoryLayout;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.SegmentScope;
import java.lang.foreign.ValueLayout;
import java.util.function.Function;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class MemorySegmentSupport {
    private static final int MAX_BATCH_SIZE = 4;
    private static final ThreadLocal<MemorySegment[]> tmpArr = ThreadLocal.withInitial(() -> MemorySegmentSupport.scratchMemorySegments(4));

    private static MemorySegment[] scratchMemorySegments(int batchSize) {
        return new MemorySegment[]{MemorySegment.allocateNative((MemoryLayout)MemoryLayout.sequenceLayout(batchSize, ValueLayout.ADDRESS), (SegmentScope)SegmentScope.global()), MemorySegment.allocateNative((MemoryLayout)MemoryLayout.sequenceLayout(batchSize, ValueLayout.ADDRESS), (SegmentScope)SegmentScope.global()), MemorySegment.allocateNative((MemoryLayout)MemoryLayout.sequenceLayout(batchSize, ValueLayout.ADDRESS), (SegmentScope)SegmentScope.global())};
    }

    public static MemorySegment[] setupBatch(Function<Integer, MemorySegment> r, Function<Integer, MemorySegment> b, Function<Integer, MemorySegment> c, int limit) {
        MemorySegment[] tmp = tmpArr.get();
        MemorySegment ra = tmp[0];
        MemorySegment rb = tmp[1];
        MemorySegment rc = tmp[2];
        for (int i = 0; i < limit; ++i) {
            ra.setAtIndex((ValueLayout.OfAddress)ValueLayout.ADDRESS, i, r.apply(i));
            rb.setAtIndex((ValueLayout.OfAddress)ValueLayout.ADDRESS, i, b.apply(i));
            rc.setAtIndex((ValueLayout.OfAddress)ValueLayout.ADDRESS, i, c.apply(i));
        }
        return tmp;
    }
}

