/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.flipkart.zjsonpatch;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import wiremock.com.flipkart.zjsonpatch.InvalidJsonPatchException;

enum Operation {
    ADD("add"),
    REMOVE("remove"),
    REPLACE("replace"),
    MOVE("move"),
    COPY("copy"),
    TEST("test");

    private static final Map<String, Operation> OPS;
    private String rfcName;

    private static Map<String, Operation> createImmutableMap() {
        HashMap<String, Operation> map = new HashMap<String, Operation>();
        map.put(Operation.ADD.rfcName, ADD);
        map.put(Operation.REMOVE.rfcName, REMOVE);
        map.put(Operation.REPLACE.rfcName, REPLACE);
        map.put(Operation.MOVE.rfcName, MOVE);
        map.put(Operation.COPY.rfcName, COPY);
        map.put(Operation.TEST.rfcName, TEST);
        return Collections.unmodifiableMap(map);
    }

    private Operation(String rfcName) {
        this.rfcName = rfcName;
    }

    public static Operation fromRfcName(String rfcName) throws InvalidJsonPatchException {
        if (rfcName == null) {
            throw new InvalidJsonPatchException("rfcName cannot be null");
        }
        Operation op = OPS.get(rfcName.toLowerCase());
        if (op == null) {
            throw new InvalidJsonPatchException("unknown / unsupported operation " + rfcName);
        }
        return op;
    }

    public String rfcName() {
        return this.rfcName;
    }

    static {
        OPS = Operation.createImmutableMap();
    }
}

