/*
 * Decompiled with CFR 0.152.
 */
package com.github.xiaoymin.knife4j.spring.configuration;

import com.github.xiaoymin.knife4j.extend.filter.basic.JakartaServletSecurityBasicAuthFilter;
import com.github.xiaoymin.knife4j.extend.filter.basic.ServletSecurityBasicAuthFilter;
import com.github.xiaoymin.knife4j.spring.configuration.Knife4jProperties;
import com.github.xiaoymin.knife4j.spring.configuration.Knife4jSetting;
import com.github.xiaoymin.knife4j.spring.extension.Knife4jJakartaOperationCustomizer;
import com.github.xiaoymin.knife4j.spring.extension.Knife4jOpenApiCustomizer;
import com.github.xiaoymin.knife4j.spring.filter.ProductionSecurityFilter;
import com.github.xiaoymin.knife4j.spring.util.EnvironmentUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;
import org.springframework.web.filter.CorsFilter;

@Configuration
@EnableConfigurationProperties(value={Knife4jProperties.class, Knife4jSetting.class})
@ConditionalOnProperty(name={"knife4j.enable"}, havingValue="true")
public class Knife4jAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(Knife4jAutoConfiguration.class);
    private final Knife4jProperties properties;
    private final Environment environment;

    @Bean
    @ConditionalOnMissingBean
    public Knife4jOpenApiCustomizer knife4jOpenApiCustomizer() {
        log.debug("Register Knife4jOpenApiCustomizer");
        return new Knife4jOpenApiCustomizer(this.properties);
    }

    @Bean
    @ConditionalOnMissingBean
    public Knife4jJakartaOperationCustomizer knife4jJakartaOperationCustomizer() {
        return new Knife4jJakartaOperationCustomizer();
    }

    @Bean(value={"knife4jCorsFilter"})
    @ConditionalOnMissingBean(value={CorsFilter.class})
    @ConditionalOnProperty(name={"knife4j.cors"}, havingValue="true")
    public CorsFilter corsFilter() {
        log.info("init CorsFilter...");
        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        CorsConfiguration corsConfiguration = new CorsConfiguration();
        corsConfiguration.setAllowCredentials(Boolean.valueOf(true));
        corsConfiguration.addAllowedOrigin("*");
        corsConfiguration.addAllowedHeader("*");
        corsConfiguration.addAllowedMethod("*");
        corsConfiguration.setMaxAge(Long.valueOf(10000L));
        source.registerCorsConfiguration("/**", corsConfiguration);
        CorsFilter corsFilter = new CorsFilter((CorsConfigurationSource)source);
        return corsFilter;
    }

    @Bean
    @ConditionalOnMissingBean(value={ServletSecurityBasicAuthFilter.class})
    @ConditionalOnProperty(name={"knife4j.basic.enable"}, havingValue="true")
    public JakartaServletSecurityBasicAuthFilter securityBasicAuthFilter(Knife4jProperties knife4jProperties) {
        JakartaServletSecurityBasicAuthFilter authFilter = new JakartaServletSecurityBasicAuthFilter();
        if (knife4jProperties == null) {
            authFilter.setEnableBasicAuth(EnvironmentUtils.resolveBool(this.environment, "knife4j.basic.enable", Boolean.FALSE).booleanValue());
            authFilter.setUserName(EnvironmentUtils.resolveString(this.environment, "knife4j.basic.username", "admin"));
            authFilter.setPassword(EnvironmentUtils.resolveString(this.environment, "knife4j.basic.password", "123321"));
        } else if (knife4jProperties.getBasic() == null) {
            authFilter.setEnableBasicAuth(Boolean.FALSE.booleanValue());
            authFilter.setUserName("admin");
            authFilter.setPassword("123321");
        } else {
            authFilter.setEnableBasicAuth(knife4jProperties.getBasic().isEnable());
            authFilter.setUserName(knife4jProperties.getBasic().getUsername());
            authFilter.setPassword(knife4jProperties.getBasic().getPassword());
            authFilter.addRule(knife4jProperties.getBasic().getInclude());
        }
        return authFilter;
    }

    @Bean
    @ConditionalOnMissingBean(value={ProductionSecurityFilter.class})
    @ConditionalOnProperty(name={"knife4j.production"}, havingValue="true")
    public ProductionSecurityFilter productionSecurityFilter(Environment environment) {
        boolean prod = false;
        ProductionSecurityFilter p = null;
        if (this.properties == null) {
            if (environment != null) {
                String prodStr = environment.getProperty("knife4j.production");
                if (log.isDebugEnabled()) {
                    log.debug("swagger.production:{}", (Object)prodStr);
                }
                prod = Boolean.valueOf(prodStr);
            }
            p = new ProductionSecurityFilter(prod);
        } else {
            p = new ProductionSecurityFilter(this.properties.isProduction());
        }
        return p;
    }

    public Knife4jAutoConfiguration(Knife4jProperties properties, Environment environment) {
        this.properties = properties;
        this.environment = environment;
    }
}

