/*
 * Decompiled with CFR 0.152.
 */
package com.gomyck.trans4j.filter.dictionary;

import com.gomyck.trans4j.filter.dictionary.AbstractDicConverterFilter;
import com.gomyck.trans4j.handler.dictionary.AfterDicHandleInfo;
import com.gomyck.trans4j.support.ConverterUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

public class CustomValueFilter
extends AbstractDicConverterFilter {
    private final List<CVInfo> cvInfos = new ArrayList<CVInfo>();

    public static CustomValueFilter init() {
        return new CustomValueFilter();
    }

    @Override
    public void afterConvert(AfterDicHandleInfo convertInfo) {
        for (CVInfo cvInfo : this.cvInfos) {
            if (ConverterUtil.getCommonColName(cvInfo.getColName()).equals(convertInfo.getCommonColName())) {
                if (cvInfo.getCvFunc() != null) {
                    try {
                        convertInfo.setTargetValue(cvInfo.getCvFunc().apply(convertInfo));
                    }
                    catch (Exception exception) {}
                    break;
                }
                convertInfo.setTargetValue(cvInfo.getValue());
                break;
            }
            convertInfo.setTargetValue(convertInfo.getOriginValue());
        }
    }

    public CustomValueFilter addCVInfo(CVInfo cvInfo) {
        this.cvInfos.add(cvInfo);
        return this;
    }

    @Override
    public void clearProp() {
        this.cvInfos.clear();
    }

    public static class CVInfo {
        private String colName;
        private String value;
        private Function<AfterDicHandleInfo, Object> cvFunc;

        CVInfo(String colName, String value, Function<AfterDicHandleInfo, Object> cvFunc) {
            this.colName = colName;
            this.value = value;
            this.cvFunc = cvFunc;
        }

        public static CVInfoBuilder builder() {
            return new CVInfoBuilder();
        }

        public String getColName() {
            return this.colName;
        }

        public String getValue() {
            return this.value;
        }

        public Function<AfterDicHandleInfo, Object> getCvFunc() {
            return this.cvFunc;
        }

        public void setColName(String colName) {
            this.colName = colName;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public void setCvFunc(Function<AfterDicHandleInfo, Object> cvFunc) {
            this.cvFunc = cvFunc;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CVInfo)) {
                return false;
            }
            CVInfo other = (CVInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$colName = this.getColName();
            String other$colName = other.getColName();
            if (this$colName == null ? other$colName != null : !this$colName.equals(other$colName)) {
                return false;
            }
            String this$value = this.getValue();
            String other$value = other.getValue();
            if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
                return false;
            }
            Function<AfterDicHandleInfo, Object> this$cvFunc = this.getCvFunc();
            Function<AfterDicHandleInfo, Object> other$cvFunc = other.getCvFunc();
            return !(this$cvFunc == null ? other$cvFunc != null : !this$cvFunc.equals(other$cvFunc));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CVInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $colName = this.getColName();
            result = result * 59 + ($colName == null ? 43 : $colName.hashCode());
            String $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            Function<AfterDicHandleInfo, Object> $cvFunc = this.getCvFunc();
            result = result * 59 + ($cvFunc == null ? 43 : $cvFunc.hashCode());
            return result;
        }

        public String toString() {
            return "CustomValueFilter.CVInfo(colName=" + this.getColName() + ", value=" + this.getValue() + ", cvFunc=" + this.getCvFunc() + ")";
        }

        public static class CVInfoBuilder {
            private String colName;
            private String value;
            private Function<AfterDicHandleInfo, Object> cvFunc;

            CVInfoBuilder() {
            }

            public CVInfoBuilder colName(String colName) {
                this.colName = colName;
                return this;
            }

            public CVInfoBuilder value(String value) {
                this.value = value;
                return this;
            }

            public CVInfoBuilder cvFunc(Function<AfterDicHandleInfo, Object> cvFunc) {
                this.cvFunc = cvFunc;
                return this;
            }

            public CVInfo build() {
                return new CVInfo(this.colName, this.value, this.cvFunc);
            }

            public String toString() {
                return "CustomValueFilter.CVInfo.CVInfoBuilder(colName=" + this.colName + ", value=" + this.value + ", cvFunc=" + this.cvFunc + ")";
            }
        }
    }
}

