/*
 * Decompiled with CFR 0.152.
 */
package com.gomyck.trans4j.handler.dictionary;

import com.gomyck.trans4j.filter.InnerConverterFilter;
import com.gomyck.trans4j.filter.dictionary.DicI18NFilter;
import com.gomyck.trans4j.handler.AbstractConverterHandlerFactory;
import com.gomyck.trans4j.handler.ConverterHandlerComposite;
import com.gomyck.trans4j.handler.dictionary.DicConverterHandler;
import com.gomyck.trans4j.handler.dictionary.DicDescribeAdaptor;
import com.gomyck.trans4j.handler.dictionary.serialize.AutoEncoder;
import com.gomyck.trans4j.profile.DicConfig;
import com.gomyck.trans4j.profile.Trans4JProfiles;
import com.gomyck.util.CkFile;
import com.gomyck.util.CkNetWork;
import com.gomyck.util.ObjectJudge;
import com.gomyck.util.serialize.CKJSON;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.http.conn.ssl.TrustAllStrategy;
import org.apache.http.conn.ssl.TrustStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DicInfoConverterHandlerFactory
extends AbstractConverterHandlerFactory<DicConverterHandler> {
    private static final Logger log = LoggerFactory.getLogger(DicInfoConverterHandlerFactory.class);
    private Trans4JProfiles trans4jProfiles;
    private DataSource dataSource;
    private ConverterHandlerComposite converterHandlerComposite;
    private AutoEncoder autoEncoder = input -> input;
    private boolean fileExist = true;

    @Override
    public void init() {
        DicConfig.CkDicAdaptorConfig ckDicAdaptorConfig = this.trans4jProfiles.getDic().getAdaptor();
        DicConverterHandler dicConverterHandler = this.getDicConverterHandler(ckDicAdaptorConfig);
        this.initHandlerByDatabase(ckDicAdaptorConfig, dicConverterHandler);
        DicInfoConverterHandlerFactory.initHandlerByRestServer(ckDicAdaptorConfig, dicConverterHandler);
        this.initHandlerByFile(ckDicAdaptorConfig, dicConverterHandler);
        dicConverterHandler.refresh();
        this.object = dicConverterHandler;
    }

    private DicConverterHandler getDicConverterHandler(DicConfig.CkDicAdaptorConfig ckDicAdaptorConfig) {
        boolean ifOpenI18N = ObjectJudge.notNull((Object)ckDicAdaptorConfig.getI18nColumnName());
        DicDescribeAdaptor initDicAdaptor = ifOpenI18N ? DicDescribeAdaptor.initAdaptor(ckDicAdaptorConfig.getCode(), ckDicAdaptorConfig.getValue(), ckDicAdaptorConfig.getColumnName(), ckDicAdaptorConfig.getI18nColumnName(), ckDicAdaptorConfig.getDefaultI18nFlag()) : DicDescribeAdaptor.initAdaptor(ckDicAdaptorConfig.getCode(), ckDicAdaptorConfig.getValue(), ckDicAdaptorConfig.getColumnName());
        DicConverterHandler dicConverterHandler = new DicConverterHandler(initDicAdaptor, this.autoEncoder, this.converterHandlerComposite);
        if (ifOpenI18N) {
            DicI18NFilter dicI18NFilter = new DicI18NFilter();
            dicConverterHandler.addInnerFilter((InnerConverterFilter)dicI18NFilter);
        }
        return dicConverterHandler;
    }

    private void initHandlerByDatabase(DicConfig.CkDicAdaptorConfig ckDicAdaptorConfig, DicConverterHandler dicConverterHandler) {
        List<String> initDicSql = ckDicAdaptorConfig.getInitDicSql();
        if (ObjectJudge.isNull(initDicSql)) {
            return;
        }
        if (this.dataSource == null) {
            throw new RuntimeException("init dic info error, please declare a datasource on your server or delete init sql array in the yaml file");
        }
        dicConverterHandler.init(handler -> {
            ArrayList dicInfo = new ArrayList();
            initDicSql.forEach(sql -> {
                try (PreparedStatement preparedStatement = this.dataSource.getConnection().prepareStatement((String)sql);
                     ResultSet resultSet = preparedStatement.executeQuery();){
                    List<Map<String, Object>> result = this.convertDicInfo2ListMap(resultSet);
                    log.info(MessageFormat.format("init dic info with sql: {0}, result size is: {1}", sql, result.size()));
                    dicInfo.addAll(result);
                }
                catch (SQLException e) {
                    throw new RuntimeException(MessageFormat.format("init dic info error, sql is: {0}, error is: {1}", sql, e));
                }
            });
            return dicInfo;
        });
    }

    private List<Map<String, Object>> convertDicInfo2ListMap(ResultSet rs) throws SQLException {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        ResultSetMetaData md = rs.getMetaData();
        int columnCount = md.getColumnCount();
        while (rs.next()) {
            HashMap<String, Object> rowData = new HashMap<String, Object>();
            for (int i = 1; i <= columnCount; ++i) {
                String columnLabel = md.getColumnLabel(i);
                if (ObjectJudge.notNull((Object)columnLabel)) {
                    rowData.put(columnLabel, rs.getObject(i));
                    continue;
                }
                rowData.put(md.getColumnName(i), rs.getObject(i));
            }
            list.add(rowData);
        }
        return list;
    }

    private static void initHandlerByRestServer(DicConfig.CkDicAdaptorConfig ckDicAdaptorConfig, DicConverterHandler dicConverterHandler) {
        List<String> initDicUrl = ckDicAdaptorConfig.getInitDicUrl();
        if (ObjectJudge.isNull(initDicUrl)) {
            return;
        }
        dicConverterHandler.init(handler -> {
            CkNetWork ckNetWork = CkNetWork.init((TrustStrategy)TrustAllStrategy.INSTANCE);
            ArrayList dicInfo = new ArrayList();
            initDicUrl.forEach(url -> {
                try {
                    String s = ckNetWork.doGet(url);
                    List result = CKJSON.getInstance().parseListMap(s);
                    log.info(MessageFormat.format("init dic info with url: {0}, result size is: {1}", url, result.size()));
                    dicInfo.addAll(result);
                }
                catch (IOException e) {
                    throw new RuntimeException(MessageFormat.format("init dic info error, url is: {0}, error is: {1}", url, e));
                }
            });
            return dicInfo;
        });
    }

    private void initHandlerByFile(DicConfig.CkDicAdaptorConfig ckDicAdaptorConfig, DicConverterHandler dicConverterHandler) {
        String initDicFile = ckDicAdaptorConfig.getInitDicFile();
        dicConverterHandler.init(handler -> {
            if (!this.fileExist) {
                return null;
            }
            try {
                byte[] file = CkFile.getFile((String)initDicFile);
                String dicInfo = new String(file);
                try {
                    List maps = CKJSON.getInstance().parseListMap(dicInfo);
                    log.info(MessageFormat.format("init dic info with file: {0}, result size is: {1}", initDicFile, maps.size()));
                    return maps;
                }
                catch (Exception e) {
                    log.error("dicFile format error(must be json array), please check your file,  error is: ", (Throwable)e);
                    return null;
                }
            }
            catch (Exception e) {
                this.fileExist = false;
                if ("dic.json".equals(initDicFile)) {
                    log.debug("default dic file is not found.");
                } else {
                    log.error("dicFile is not found, please check your file path.");
                }
                return null;
            }
        });
    }

    public void setTrans4jProfiles(Trans4JProfiles trans4jProfiles) {
        this.trans4jProfiles = trans4jProfiles;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setConverterHandlerComposite(ConverterHandlerComposite converterHandlerComposite) {
        this.converterHandlerComposite = converterHandlerComposite;
    }

    public void setAutoEncoder(AutoEncoder autoEncoder) {
        this.autoEncoder = autoEncoder;
    }
}

