/*
 * Decompiled with CFR 0.152.
 */
package com.gomyck.trans4j.schedule;

import com.gomyck.trans4j.handler.dictionary.DicConverterHandler;
import com.gomyck.trans4j.handler.dictionary.DicConverterInitConditional;
import com.gomyck.trans4j.profile.Trans4JProfiles;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.SchedulingConfigurer;
import org.springframework.scheduling.config.ScheduledTaskRegistrar;
import org.springframework.stereotype.Component;

@Component
@EnableScheduling
@Conditional(value={DicConverterInitConditional.class})
public class DicConverterHandlerSchedule
implements SchedulingConfigurer {
    private static final Logger log = LoggerFactory.getLogger(DicConverterHandlerSchedule.class);
    private Trans4JProfiles trans4jProfiles;
    private DicConverterHandler dicConverterHandler;

    public void configureTasks(ScheduledTaskRegistrar taskRegistrar) {
        String cron = "0 */" + this.trans4jProfiles.getDic().getJob().getRefreshInterval() + " * * * *";
        log.info("registry refresh dic table info task on cron: {}...", (Object)cron);
        taskRegistrar.addCronTask(() -> {
            log.debug("refresh dic table info start...");
            this.dicConverterHandler.getInitDicInfoFunc().forEach(func -> {
                try {
                    this.dicConverterHandler.init((Function<Object, List<Map<String, Object>>>)func);
                }
                catch (Exception e) {
                    log.error("dic schedule in error: {}", (Object)e.toString());
                }
            });
            log.debug("refresh dic table info end...");
        }, cron);
    }

    public DicConverterHandlerSchedule(Trans4JProfiles trans4jProfiles, DicConverterHandler dicConverterHandler) {
        this.trans4jProfiles = trans4jProfiles;
        this.dicConverterHandler = dicConverterHandler;
    }
}

