/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services.model;

import com.obs.services.model.AvailableZoneEnum;
import com.obs.services.model.BucketTypeEnum;
import com.obs.services.model.OptionsInfoResult;
import com.obs.services.model.StorageClassEnum;
import java.util.List;

public class BucketMetadataInfoResult
extends OptionsInfoResult {
    protected StorageClassEnum storageClass;
    protected String location;
    protected String obsVersion;
    protected AvailableZoneEnum availableZone;
    protected String epid;
    protected BucketTypeEnum bucketType = BucketTypeEnum.OBJECT;

    public BucketMetadataInfoResult(String allowOrigin, List<String> allowHeaders, int maxAge, List<String> allowMethods, List<String> exposeHeaders, StorageClassEnum storageClass, String location, String obsVersion) {
        super(allowOrigin, allowHeaders, maxAge, allowMethods, exposeHeaders);
        this.storageClass = storageClass;
        this.location = location;
        this.obsVersion = obsVersion;
    }

    @Deprecated
    public BucketMetadataInfoResult(String allowOrigin, List<String> allowHeaders, int maxAge, List<String> allowMethods, List<String> exposeHeaders, StorageClassEnum storageClass, String location, String obsVersion, AvailableZoneEnum availableZone) {
        this(allowOrigin, allowHeaders, maxAge, allowMethods, exposeHeaders, storageClass, location, obsVersion);
        this.availableZone = availableZone;
    }

    @Deprecated
    public BucketMetadataInfoResult(String allowOrigin, List<String> allowHeaders, int maxAge, List<String> allowMethods, List<String> exposeHeaders, StorageClassEnum storageClass, String location, String obsVersion, AvailableZoneEnum availableZone, String epid, BucketTypeEnum bucketType) {
        this(allowOrigin, allowHeaders, maxAge, allowMethods, exposeHeaders, storageClass, location, obsVersion);
        this.availableZone = availableZone;
        this.epid = epid;
        this.bucketType = bucketType;
    }

    protected BucketMetadataInfoResult() {
    }

    private BucketMetadataInfoResult(Builder builder) {
        super(builder.allowOrigin, builder.allowHeaders, builder.maxAge, builder.allowMethods, builder.exposeHeaders);
        this.storageClass = builder.storageClass;
        this.location = builder.location;
        this.obsVersion = builder.obsVersion;
        this.availableZone = builder.availableZone;
        this.epid = builder.epid;
        this.bucketType = builder.bucketType;
    }

    @Deprecated
    public String getDefaultStorageClass() {
        return this.storageClass == null ? null : this.storageClass.getCode();
    }

    public StorageClassEnum getBucketStorageClass() {
        return this.storageClass;
    }

    public String getLocation() {
        return this.location;
    }

    public String getObsVersion() {
        return this.obsVersion;
    }

    public String getEpid() {
        return this.epid;
    }

    public AvailableZoneEnum getAvailableZone() {
        return this.availableZone;
    }

    @Override
    public String toString() {
        return "BucketMetadataInfoResult [storageClass=" + (Object)((Object)this.storageClass) + ", location=" + this.location + ", obsVersion=" + this.obsVersion + ", bucketType=" + this.bucketType.name() + "]";
    }

    public BucketTypeEnum getBucketType() {
        return this.bucketType;
    }

    public static final class Builder {
        private String allowOrigin;
        private List<String> allowHeaders;
        private int maxAge;
        private List<String> allowMethods;
        private List<String> exposeHeaders;
        private StorageClassEnum storageClass;
        private String location;
        private String obsVersion;
        private AvailableZoneEnum availableZone;
        private String epid;
        private BucketTypeEnum bucketType = BucketTypeEnum.OBJECT;

        public Builder allowOrigin(String allowOrigin) {
            this.allowOrigin = allowOrigin;
            return this;
        }

        public Builder allowHeaders(List<String> allowHeaders) {
            this.allowHeaders = allowHeaders;
            return this;
        }

        public Builder maxAge(int maxAge) {
            this.maxAge = maxAge;
            return this;
        }

        public Builder allowMethods(List<String> allowMethods) {
            this.allowMethods = allowMethods;
            return this;
        }

        public Builder exposeHeaders(List<String> exposeHeaders) {
            this.exposeHeaders = exposeHeaders;
            return this;
        }

        public Builder storageClass(StorageClassEnum storageClass) {
            this.storageClass = storageClass;
            return this;
        }

        public Builder location(String location) {
            this.location = location;
            return this;
        }

        public Builder obsVersion(String obsVersion) {
            this.obsVersion = obsVersion;
            return this;
        }

        public Builder availableZone(AvailableZoneEnum availableZone) {
            this.availableZone = availableZone;
            return this;
        }

        public Builder epid(String epid) {
            this.epid = epid;
            return this;
        }

        public Builder bucketType(BucketTypeEnum bucketType) {
            this.bucketType = bucketType;
            return this;
        }

        public BucketMetadataInfoResult build() {
            return new BucketMetadataInfoResult(this);
        }
    }
}

