/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services.model;

import com.obs.services.model.GenericRequest;
import com.obs.services.model.HttpMethodEnum;
import com.obs.services.model.KeyAndVersion;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class DeleteObjectsRequest
extends GenericRequest {
    private boolean quiet;
    private List<KeyAndVersion> keyAndVersions;
    private String encodingType;

    public DeleteObjectsRequest() {
        this.httpMethod = HttpMethodEnum.POST;
    }

    public DeleteObjectsRequest(String bucketName) {
        this.httpMethod = HttpMethodEnum.POST;
        this.bucketName = bucketName;
    }

    public DeleteObjectsRequest(String bucketName, boolean quiet, KeyAndVersion[] keyAndVersions) {
        this.httpMethod = HttpMethodEnum.POST;
        this.bucketName = bucketName;
        this.quiet = quiet;
        this.setKeyAndVersions(keyAndVersions);
    }

    public DeleteObjectsRequest(String bucketName, boolean quiet, KeyAndVersion[] keyAndVersions, String encodingType) {
        this.httpMethod = HttpMethodEnum.POST;
        this.bucketName = bucketName;
        this.quiet = quiet;
        this.setKeyAndVersions(keyAndVersions);
        this.setEncodingType(encodingType);
    }

    public boolean isQuiet() {
        return this.quiet;
    }

    public void setQuiet(boolean quiet) {
        this.quiet = quiet;
    }

    public void setEncodingType(String encodingType) {
        this.encodingType = encodingType;
    }

    public String getEncodingType() {
        return this.encodingType;
    }

    public List<KeyAndVersion> getKeyAndVersionsList() {
        if (this.keyAndVersions == null) {
            this.keyAndVersions = new ArrayList<KeyAndVersion>();
        }
        return this.keyAndVersions;
    }

    public KeyAndVersion addKeyAndVersion(String objectKey, String versionId) {
        KeyAndVersion kv = new KeyAndVersion(objectKey, versionId);
        this.getKeyAndVersionsList().add(kv);
        return kv;
    }

    public KeyAndVersion addKeyAndVersion(String objectKey) {
        return this.addKeyAndVersion(objectKey, null);
    }

    public KeyAndVersion[] getKeyAndVersions() {
        return this.getKeyAndVersionsList().toArray(new KeyAndVersion[this.getKeyAndVersionsList().size()]);
    }

    public void setKeyAndVersions(KeyAndVersion[] keyAndVersions) {
        if (keyAndVersions != null && keyAndVersions.length > 0) {
            this.keyAndVersions = new ArrayList<KeyAndVersion>(Arrays.asList(keyAndVersions));
        }
    }

    @Override
    public String toString() {
        return "DeleteObjectsRequest [bucketName=" + this.bucketName + ", quiet=" + this.quiet + ", encodingType=" + this.encodingType + ", keyAndVersions=" + this.keyAndVersions + "]";
    }
}

