/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.runtime.internal.xml;

import com.ibm.db2.cmx.runtime.internal.xml.PDQXml;
import com.ibm.db2.cmx.runtime.internal.xml.PDQXmlPackage;
import com.ibm.db2.cmx.runtime.internal.xml.PDQXmlParameterMetaData;
import com.ibm.db2.cmx.runtime.internal.xml.PDQXmlResultSetMetaData;
import com.ibm.db2.cmx.runtime.internal.xml.PDQXmlStatement;
import com.ibm.db2.cmx.runtime.internal.xml.PDQXmlStatementAttributes;
import com.ibm.db2.cmx.runtime.internal.xml.PDQXmlStatementDescriptor;
import com.ibm.db2.cmx.runtime.internal.xml.PDQXmlStatementSet;
import com.ibm.db2.cmx.runtime.internal.xml.XmlTags;
import com.ibm.db2.cmx.runtime.statement.SqlStatementType;
import com.ibm.db2.cmx.tools.internal.StatementUtilities;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.List;

public class PDQXmlWriter {
    private String encoding_;
    private StringWriter writer_;
    private Writer userWriter_;
    private int currentSectionNum_;

    public PDQXmlWriter(OutputStream outputStream) {
        try {
            this.encoding_ = "UTF-8";
            this.userWriter_ = new OutputStreamWriter(outputStream, "UTF-8");
            this.writer_ = new StringWriter();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
    }

    public PDQXmlWriter(Writer writer, String string) {
        this.userWriter_ = writer;
        this.writer_ = new StringWriter();
        this.encoding_ = string;
    }

    public void write(PDQXml pDQXml) throws IOException {
        this.startDocument(pDQXml);
        List<PDQXmlStatementSet> list = pDQXml.getStatementSets();
        for (PDQXmlStatementSet pDQXmlStatementSet : list) {
            this.startStatementSet(pDQXmlStatementSet);
            ArrayList<PDQXmlStatement> arrayList = pDQXmlStatementSet.getStatements();
            for (PDQXmlStatement pDQXmlStatement : arrayList) {
                this.addStatement(pDQXmlStatement);
            }
            this.endStatementSet(pDQXmlStatementSet);
        }
        this.endDocument(pDQXml);
    }

    public void startDocument(PDQXml pDQXml) throws IOException {
        this.currentSectionNum_ = 0;
        this.writer_.append("<?xml version=\"1.0\" encoding=\"" + this.encoding_ + "\"?>");
        this.writer_.append(XmlTags.CRLF);
        this.writer_.append(pDQXml.getXmlStart(0));
        this.writer_.flush();
    }

    public void endDocument(PDQXml pDQXml) throws IOException {
        this.writer_.append(XmlTags.CRLF);
        int n2 = PDQXml.lastCursorIndex__;
        int n3 = PDQXml.lastSqlIndex__;
        int n4 = PDQXml.nonParameterizedSqlCount__;
        this.writer_.append(pDQXml.getXmlEnd(0));
        this.writer_.flush();
        String string = this.writer_.getBuffer().toString();
        string = this.fixCaptureRecord(string, n2, n3, n4);
        this.userWriter_.append(string);
        this.userWriter_.flush();
        this.writer_.close();
    }

    private String fixCaptureRecord(String string, int n2, int n3, int n4) {
        string = string.replace("<captureRecord lastCursorIndex=\"0\" lastSqlIndex=\"0\" nonParameterizedSqlCount=\"0\"/>", "<captureRecord lastCursorIndex=\"" + n2 + "\" lastSqlIndex=\"" + n3 + "\" nonParameterizedSqlCount=\"" + n4 + "\"/>");
        return string;
    }

    public void startStatementSet(PDQXmlStatementSet pDQXmlStatementSet) throws IOException {
        this.currentSectionNum_ = 0;
        this.writer_.append(XmlTags.CRLF);
        this.writer_.append(pDQXmlStatementSet.getXmlStart(2));
        this.writer_.flush();
    }

    public void endStatementSet(PDQXmlStatementSet pDQXmlStatementSet) throws IOException {
        this.writer_.append(pDQXmlStatementSet.getXmlEnd(2));
        this.writer_.flush();
    }

    public void addStatement(PDQXmlStatement pDQXmlStatement) throws IOException {
        Object object;
        if (pDQXmlStatement.getPDQXmlStatementDescriptor() != null && (object = pDQXmlStatement.getPDQXmlStatementDescriptor().getSql()) != null && !((String)object).contains("?")) {
            ++PDQXml.nonParameterizedSqlCount__;
        }
        if ("OpenJPA".equals(PDQXml.currentOriginType__) && PDQXml.isDB2forZOS__) {
            ++this.currentSectionNum_;
            pDQXmlStatement.getPDQXmlStatementDescriptor().setSectionNumber(this.currentSectionNum_);
            if (SqlStatementType.INSERT == pDQXmlStatement.getPDQXmlStatementDescriptor().getStatementTypeEnum()) {
                this.currentSectionNum_ += 2;
                object = pDQXmlStatement.getPDQXmlStatementDescriptor().getStatementAttributes();
                if (object != null) {
                    ((PDQXmlStatementAttributes)object).setParameterType(2);
                }
                pDQXmlStatement.setNumReservedSections(2);
            } else if (SqlStatementType.MERGE == pDQXmlStatement.getPDQXmlStatementDescriptor().getStatementTypeEnum()) {
                ++this.currentSectionNum_;
                object = pDQXmlStatement.getPDQXmlStatementDescriptor().getStatementAttributes();
                if (object != null) {
                    ((PDQXmlStatementAttributes)object).setParameterType(2);
                }
                pDQXmlStatement.setNumReservedSections(1);
            }
            object = pDQXmlStatement.getPDQXmlStatementDescriptor().getSql();
            if (pDQXmlStatement.getPDQXmlStatementDescriptor() != null && pDQXmlStatement.getPDQXmlStatementDescriptor().getProcessedSql() != null) {
                object = pDQXmlStatement.getPDQXmlStatementDescriptor().getProcessedSql();
            }
            if (StatementUtilities.isSqlUpdatable((String)object, 0)) {
                ++this.currentSectionNum_;
                pDQXmlStatement.setNumReservedSections(1);
            }
        }
        this.writer_.append(pDQXmlStatement.getXml(6));
        this.writer_.append(XmlTags.CRLF);
        this.writer_.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        String string = stringArray[0];
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            try {
                Object object;
                ArrayList<PDQXmlStatement> arrayList = new ArrayList<PDQXmlStatement>();
                PDQXmlPackage pDQXmlPackage = new PDQXmlPackage();
                pDQXmlPackage.setPackageName("PACKAGE1");
                pDQXmlPackage.setCollectionName("NULLID");
                pDQXmlPackage.setConsistencyToken(System.currentTimeMillis());
                pDQXmlPackage.setPackageVersion("version1");
                PDQXmlStatementSet pDQXmlStatementSet = new PDQXmlStatementSet();
                pDQXmlStatementSet.setPackage(pDQXmlPackage);
                for (int i10 = 0; i10 < 1; ++i10) {
                    object = new PDQXmlStatementDescriptor();
                    ((PDQXmlStatementDescriptor)object).setParameterHandlerName(null);
                    PDQXmlParameterMetaData pDQXmlParameterMetaData = new PDQXmlParameterMetaData();
                    pDQXmlParameterMetaData.init((PreparedStatement)null);
                    ((PDQXmlStatementDescriptor)object).setParameterMetadata(pDQXmlParameterMetaData);
                    PDQXmlResultSetMetaData pDQXmlResultSetMetaData = new PDQXmlResultSetMetaData();
                    ((PDQXmlStatementDescriptor)object).setResultSetMetaData(pDQXmlResultSetMetaData);
                    ((PDQXmlStatementDescriptor)object).setResultHandlerName(null);
                    ((PDQXmlStatementDescriptor)object).setRowHandlerName(null);
                    PDQXmlStatementAttributes pDQXmlStatementAttributes = new PDQXmlStatementAttributes();
                    pDQXmlStatementAttributes.setHoldability(1);
                    ((PDQXmlStatementDescriptor)object).setStatementAttributes(pDQXmlStatementAttributes);
                    int n2 = 1;
                    ((PDQXmlStatementDescriptor)object).setSectionNumber(n2);
                    ((PDQXmlStatementDescriptor)object).setSql("select ...");
                    ((PDQXmlStatementDescriptor)object).setStatementType(SqlStatementType.QUERY);
                    PDQXmlStatement pDQXmlStatement = new PDQXmlStatement();
                    pDQXmlStatement.setPDQXmlStatementDescriptor((PDQXmlStatementDescriptor)object);
                    arrayList.add(pDQXmlStatement);
                }
                PDQXml pDQXml = new PDQXml();
                pDQXml.initOrigin((Connection)null, "OpenJPA");
                object = new PDQXmlWriter(fileOutputStream);
                ((PDQXmlWriter)object).startDocument(pDQXml);
                ((PDQXmlWriter)object).startStatementSet(pDQXmlStatementSet);
                for (int i11 = 0; i11 < arrayList.size(); ++i11) {
                    ((PDQXmlWriter)object).addStatement((PDQXmlStatement)arrayList.get(i11));
                }
                ((PDQXmlWriter)object).endStatementSet(pDQXmlStatementSet);
                ((PDQXmlWriter)object).endDocument(pDQXml);
            }
            finally {
                fileOutputStream.close();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

