/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.assistant.v1;

import com.google.gson.JsonObject;
import com.ibm.watson.developer_cloud.assistant.v1.model.Counterexample;
import com.ibm.watson.developer_cloud.assistant.v1.model.CounterexampleCollection;
import com.ibm.watson.developer_cloud.assistant.v1.model.CreateCounterexampleOptions;
import com.ibm.watson.developer_cloud.assistant.v1.model.CreateDialogNodeOptions;
import com.ibm.watson.developer_cloud.assistant.v1.model.CreateEntityOptions;
import com.ibm.watson.developer_cloud.assistant.v1.model.CreateExampleOptions;
import com.ibm.watson.developer_cloud.assistant.v1.model.CreateIntentOptions;
import com.ibm.watson.developer_cloud.assistant.v1.model.CreateSynonymOptions;
import com.ibm.watson.developer_cloud.assistant.v1.model.CreateValueOptions;
import com.ibm.watson.developer_cloud.assistant.v1.model.CreateWorkspaceOptions;
import com.ibm.watson.developer_cloud.assistant.v1.model.DeleteCounterexampleOptions;
import com.ibm.watson.developer_cloud.assistant.v1.model.DeleteDialogNodeOptions;
import com.ibm.watson.developer_cloud.assistant.v1.model.DeleteEntityOptions;
import com.ibm.watson.developer_cloud.assistant.v1.model.DeleteExampleOptions;
import com.ibm.watson.developer_cloud.assistant.v1.model.DeleteIntentOptions;
import com.ibm.watson.developer_cloud.assistant.v1.model.DeleteSynonymOptions;
import com.ibm.watson.developer_cloud.assistant.v1.model.DeleteValueOptions;
import com.ibm.watson.developer_cloud.assistant.v1.model.DeleteWorkspaceOptions;
import com.ibm.watson.developer_cloud.assistant.v1.model.DialogNode;
import com.ibm.watson.developer_cloud.assistant.v1.model.DialogNodeCollection;
import com.ibm.watson.developer_cloud.assistant.v1.model.Entity;
import com.ibm.watson.developer_cloud.assistant.v1.model.EntityCollection;
import com.ibm.watson.developer_cloud.assistant.v1.model.EntityExport;
import com.ibm.watson.developer_cloud.assistant.v1.model.Example;
import com.ibm.watson.developer_cloud.assistant.v1.model.ExampleCollection;
import com.ibm.watson.developer_cloud.assistant.v1.model.GetCounterexampleOptions;
import com.ibm.watson.developer_cloud.assistant.v1.model.GetDialogNodeOptions;
import com.ibm.watson.developer_cloud.assistant.v1.model.GetEntityOptions;
import com.ibm.watson.developer_cloud.assistant.v1.model.GetExampleOptions;
import com.ibm.watson.developer_cloud.assistant.v1.model.GetIntentOptions;
import com.ibm.watson.developer_cloud.assistant.v1.model.GetSynonymOptions;
import com.ibm.watson.developer_cloud.assistant.v1.model.GetValueOptions;
import com.ibm.watson.developer_cloud.assistant.v1.model.GetWorkspaceOptions;
import com.ibm.watson.developer_cloud.assistant.v1.model.Intent;
import com.ibm.watson.developer_cloud.assistant.v1.model.IntentCollection;
import com.ibm.watson.developer_cloud.assistant.v1.model.IntentExport;
import com.ibm.watson.developer_cloud.assistant.v1.model.ListAllLogsOptions;
import com.ibm.watson.developer_cloud.assistant.v1.model.ListCounterexamplesOptions;
import com.ibm.watson.developer_cloud.assistant.v1.model.ListDialogNodesOptions;
import com.ibm.watson.developer_cloud.assistant.v1.model.ListEntitiesOptions;
import com.ibm.watson.developer_cloud.assistant.v1.model.ListExamplesOptions;
import com.ibm.watson.developer_cloud.assistant.v1.model.ListIntentsOptions;
import com.ibm.watson.developer_cloud.assistant.v1.model.ListLogsOptions;
import com.ibm.watson.developer_cloud.assistant.v1.model.ListSynonymsOptions;
import com.ibm.watson.developer_cloud.assistant.v1.model.ListValuesOptions;
import com.ibm.watson.developer_cloud.assistant.v1.model.ListWorkspacesOptions;
import com.ibm.watson.developer_cloud.assistant.v1.model.LogCollection;
import com.ibm.watson.developer_cloud.assistant.v1.model.MessageOptions;
import com.ibm.watson.developer_cloud.assistant.v1.model.MessageResponse;
import com.ibm.watson.developer_cloud.assistant.v1.model.Synonym;
import com.ibm.watson.developer_cloud.assistant.v1.model.SynonymCollection;
import com.ibm.watson.developer_cloud.assistant.v1.model.UpdateCounterexampleOptions;
import com.ibm.watson.developer_cloud.assistant.v1.model.UpdateDialogNodeOptions;
import com.ibm.watson.developer_cloud.assistant.v1.model.UpdateEntityOptions;
import com.ibm.watson.developer_cloud.assistant.v1.model.UpdateExampleOptions;
import com.ibm.watson.developer_cloud.assistant.v1.model.UpdateIntentOptions;
import com.ibm.watson.developer_cloud.assistant.v1.model.UpdateSynonymOptions;
import com.ibm.watson.developer_cloud.assistant.v1.model.UpdateValueOptions;
import com.ibm.watson.developer_cloud.assistant.v1.model.UpdateWorkspaceOptions;
import com.ibm.watson.developer_cloud.assistant.v1.model.Value;
import com.ibm.watson.developer_cloud.assistant.v1.model.ValueCollection;
import com.ibm.watson.developer_cloud.assistant.v1.model.ValueExport;
import com.ibm.watson.developer_cloud.assistant.v1.model.Workspace;
import com.ibm.watson.developer_cloud.assistant.v1.model.WorkspaceCollection;
import com.ibm.watson.developer_cloud.assistant.v1.model.WorkspaceExport;
import com.ibm.watson.developer_cloud.http.RequestBuilder;
import com.ibm.watson.developer_cloud.http.ServiceCall;
import com.ibm.watson.developer_cloud.service.WatsonService;
import com.ibm.watson.developer_cloud.util.GsonSingleton;
import com.ibm.watson.developer_cloud.util.ResponseConverterUtils;
import com.ibm.watson.developer_cloud.util.Validator;
import okhttp3.HttpUrl;

public class Assistant
extends WatsonService {
    private static final String SERVICE_NAME = "assistant";
    private static final String URL = "https://gateway.watsonplatform.net/assistant/api";
    private String versionDate;

    public Assistant(String versionDate) {
        super(SERVICE_NAME);
        if (this.getEndPoint() == null || this.getEndPoint().isEmpty()) {
            this.setEndPoint(URL);
        }
        Validator.isTrue((versionDate != null && !versionDate.isEmpty() ? 1 : 0) != 0, (String)"version cannot be null.");
        this.versionDate = versionDate;
    }

    public Assistant(String versionDate, String username, String password) {
        this(versionDate);
        this.setUsernameAndPassword(username, password);
    }

    public ServiceCall<MessageResponse> message(MessageOptions messageOptions) {
        Validator.notNull((Object)((Object)messageOptions), (String)"messageOptions cannot be null");
        String[] pathSegments = new String[]{"v1/workspaces", "message"};
        String[] pathParameters = new String[]{messageOptions.workspaceId()};
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getEndPoint(), (String[])pathSegments, (String[])pathParameters));
        builder.query(new Object[]{"version", this.versionDate});
        if (messageOptions.nodesVisitedDetails() != null) {
            builder.query(new Object[]{"nodes_visited_details", String.valueOf(messageOptions.nodesVisitedDetails())});
        }
        JsonObject contentJson = new JsonObject();
        if (messageOptions.input() != null) {
            contentJson.add("input", GsonSingleton.getGson().toJsonTree((Object)messageOptions.input()));
        }
        if (messageOptions.alternateIntents() != null) {
            contentJson.addProperty("alternate_intents", messageOptions.alternateIntents());
        }
        if (messageOptions.context() != null) {
            contentJson.add("context", GsonSingleton.getGson().toJsonTree((Object)messageOptions.context()));
        }
        if (messageOptions.entities() != null) {
            contentJson.add("entities", GsonSingleton.getGson().toJsonTree(messageOptions.entities()));
        }
        if (messageOptions.intents() != null) {
            contentJson.add("intents", GsonSingleton.getGson().toJsonTree(messageOptions.intents()));
        }
        if (messageOptions.output() != null) {
            contentJson.add("output", GsonSingleton.getGson().toJsonTree((Object)messageOptions.output()));
        }
        builder.bodyJson(contentJson);
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getObject(MessageResponse.class));
    }

    public ServiceCall<Workspace> createWorkspace(CreateWorkspaceOptions createWorkspaceOptions) {
        String[] pathSegments = new String[]{"v1/workspaces"};
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getEndPoint(), (String[])pathSegments));
        builder.query(new Object[]{"version", this.versionDate});
        if (createWorkspaceOptions != null) {
            JsonObject contentJson = new JsonObject();
            if (createWorkspaceOptions.name() != null) {
                contentJson.addProperty("name", createWorkspaceOptions.name());
            }
            if (createWorkspaceOptions.description() != null) {
                contentJson.addProperty("description", createWorkspaceOptions.description());
            }
            if (createWorkspaceOptions.language() != null) {
                contentJson.addProperty("language", createWorkspaceOptions.language());
            }
            if (createWorkspaceOptions.intents() != null) {
                contentJson.add("intents", GsonSingleton.getGson().toJsonTree(createWorkspaceOptions.intents()));
            }
            if (createWorkspaceOptions.entities() != null) {
                contentJson.add("entities", GsonSingleton.getGson().toJsonTree(createWorkspaceOptions.entities()));
            }
            if (createWorkspaceOptions.dialogNodes() != null) {
                contentJson.add("dialog_nodes", GsonSingleton.getGson().toJsonTree(createWorkspaceOptions.dialogNodes()));
            }
            if (createWorkspaceOptions.counterexamples() != null) {
                contentJson.add("counterexamples", GsonSingleton.getGson().toJsonTree(createWorkspaceOptions.counterexamples()));
            }
            if (createWorkspaceOptions.metadata() != null) {
                contentJson.add("metadata", GsonSingleton.getGson().toJsonTree((Object)createWorkspaceOptions.metadata()));
            }
            if (createWorkspaceOptions.learningOptOut() != null) {
                contentJson.addProperty("learning_opt_out", createWorkspaceOptions.learningOptOut());
            }
            builder.bodyJson(contentJson);
        }
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getObject(Workspace.class));
    }

    public ServiceCall<Workspace> createWorkspace() {
        return this.createWorkspace(null);
    }

    public ServiceCall<Void> deleteWorkspace(DeleteWorkspaceOptions deleteWorkspaceOptions) {
        Validator.notNull((Object)((Object)deleteWorkspaceOptions), (String)"deleteWorkspaceOptions cannot be null");
        String[] pathSegments = new String[]{"v1/workspaces"};
        String[] pathParameters = new String[]{deleteWorkspaceOptions.workspaceId()};
        RequestBuilder builder = RequestBuilder.delete((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getEndPoint(), (String[])pathSegments, (String[])pathParameters));
        builder.query(new Object[]{"version", this.versionDate});
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getVoid());
    }

    public ServiceCall<WorkspaceExport> getWorkspace(GetWorkspaceOptions getWorkspaceOptions) {
        Validator.notNull((Object)((Object)getWorkspaceOptions), (String)"getWorkspaceOptions cannot be null");
        String[] pathSegments = new String[]{"v1/workspaces"};
        String[] pathParameters = new String[]{getWorkspaceOptions.workspaceId()};
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getEndPoint(), (String[])pathSegments, (String[])pathParameters));
        builder.query(new Object[]{"version", this.versionDate});
        if (getWorkspaceOptions.export() != null) {
            builder.query(new Object[]{"export", String.valueOf(getWorkspaceOptions.export())});
        }
        if (getWorkspaceOptions.includeAudit() != null) {
            builder.query(new Object[]{"include_audit", String.valueOf(getWorkspaceOptions.includeAudit())});
        }
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getObject(WorkspaceExport.class));
    }

    public ServiceCall<WorkspaceCollection> listWorkspaces(ListWorkspacesOptions listWorkspacesOptions) {
        String[] pathSegments = new String[]{"v1/workspaces"};
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getEndPoint(), (String[])pathSegments));
        builder.query(new Object[]{"version", this.versionDate});
        if (listWorkspacesOptions != null) {
            if (listWorkspacesOptions.pageLimit() != null) {
                builder.query(new Object[]{"page_limit", String.valueOf(listWorkspacesOptions.pageLimit())});
            }
            if (listWorkspacesOptions.includeCount() != null) {
                builder.query(new Object[]{"include_count", String.valueOf(listWorkspacesOptions.includeCount())});
            }
            if (listWorkspacesOptions.sort() != null) {
                builder.query(new Object[]{"sort", listWorkspacesOptions.sort()});
            }
            if (listWorkspacesOptions.cursor() != null) {
                builder.query(new Object[]{"cursor", listWorkspacesOptions.cursor()});
            }
            if (listWorkspacesOptions.includeAudit() != null) {
                builder.query(new Object[]{"include_audit", String.valueOf(listWorkspacesOptions.includeAudit())});
            }
        }
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getObject(WorkspaceCollection.class));
    }

    public ServiceCall<WorkspaceCollection> listWorkspaces() {
        return this.listWorkspaces(null);
    }

    public ServiceCall<Workspace> updateWorkspace(UpdateWorkspaceOptions updateWorkspaceOptions) {
        Validator.notNull((Object)((Object)updateWorkspaceOptions), (String)"updateWorkspaceOptions cannot be null");
        String[] pathSegments = new String[]{"v1/workspaces"};
        String[] pathParameters = new String[]{updateWorkspaceOptions.workspaceId()};
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getEndPoint(), (String[])pathSegments, (String[])pathParameters));
        builder.query(new Object[]{"version", this.versionDate});
        if (updateWorkspaceOptions.append() != null) {
            builder.query(new Object[]{"append", String.valueOf(updateWorkspaceOptions.append())});
        }
        JsonObject contentJson = new JsonObject();
        if (updateWorkspaceOptions.name() != null) {
            contentJson.addProperty("name", updateWorkspaceOptions.name());
        }
        if (updateWorkspaceOptions.description() != null) {
            contentJson.addProperty("description", updateWorkspaceOptions.description());
        }
        if (updateWorkspaceOptions.language() != null) {
            contentJson.addProperty("language", updateWorkspaceOptions.language());
        }
        if (updateWorkspaceOptions.intents() != null) {
            contentJson.add("intents", GsonSingleton.getGson().toJsonTree(updateWorkspaceOptions.intents()));
        }
        if (updateWorkspaceOptions.entities() != null) {
            contentJson.add("entities", GsonSingleton.getGson().toJsonTree(updateWorkspaceOptions.entities()));
        }
        if (updateWorkspaceOptions.dialogNodes() != null) {
            contentJson.add("dialog_nodes", GsonSingleton.getGson().toJsonTree(updateWorkspaceOptions.dialogNodes()));
        }
        if (updateWorkspaceOptions.counterexamples() != null) {
            contentJson.add("counterexamples", GsonSingleton.getGson().toJsonTree(updateWorkspaceOptions.counterexamples()));
        }
        if (updateWorkspaceOptions.metadata() != null) {
            contentJson.add("metadata", GsonSingleton.getGson().toJsonTree((Object)updateWorkspaceOptions.metadata()));
        }
        if (updateWorkspaceOptions.learningOptOut() != null) {
            contentJson.addProperty("learning_opt_out", updateWorkspaceOptions.learningOptOut());
        }
        builder.bodyJson(contentJson);
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getObject(Workspace.class));
    }

    public ServiceCall<Intent> createIntent(CreateIntentOptions createIntentOptions) {
        Validator.notNull((Object)((Object)createIntentOptions), (String)"createIntentOptions cannot be null");
        String[] pathSegments = new String[]{"v1/workspaces", "intents"};
        String[] pathParameters = new String[]{createIntentOptions.workspaceId()};
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getEndPoint(), (String[])pathSegments, (String[])pathParameters));
        builder.query(new Object[]{"version", this.versionDate});
        JsonObject contentJson = new JsonObject();
        contentJson.addProperty("intent", createIntentOptions.intent());
        if (createIntentOptions.description() != null) {
            contentJson.addProperty("description", createIntentOptions.description());
        }
        if (createIntentOptions.examples() != null) {
            contentJson.add("examples", GsonSingleton.getGson().toJsonTree(createIntentOptions.examples()));
        }
        builder.bodyJson(contentJson);
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getObject(Intent.class));
    }

    public ServiceCall<Void> deleteIntent(DeleteIntentOptions deleteIntentOptions) {
        Validator.notNull((Object)((Object)deleteIntentOptions), (String)"deleteIntentOptions cannot be null");
        String[] pathSegments = new String[]{"v1/workspaces", "intents"};
        String[] pathParameters = new String[]{deleteIntentOptions.workspaceId(), deleteIntentOptions.intent()};
        RequestBuilder builder = RequestBuilder.delete((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getEndPoint(), (String[])pathSegments, (String[])pathParameters));
        builder.query(new Object[]{"version", this.versionDate});
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getVoid());
    }

    public ServiceCall<IntentExport> getIntent(GetIntentOptions getIntentOptions) {
        Validator.notNull((Object)((Object)getIntentOptions), (String)"getIntentOptions cannot be null");
        String[] pathSegments = new String[]{"v1/workspaces", "intents"};
        String[] pathParameters = new String[]{getIntentOptions.workspaceId(), getIntentOptions.intent()};
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getEndPoint(), (String[])pathSegments, (String[])pathParameters));
        builder.query(new Object[]{"version", this.versionDate});
        if (getIntentOptions.export() != null) {
            builder.query(new Object[]{"export", String.valueOf(getIntentOptions.export())});
        }
        if (getIntentOptions.includeAudit() != null) {
            builder.query(new Object[]{"include_audit", String.valueOf(getIntentOptions.includeAudit())});
        }
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getObject(IntentExport.class));
    }

    public ServiceCall<IntentCollection> listIntents(ListIntentsOptions listIntentsOptions) {
        Validator.notNull((Object)((Object)listIntentsOptions), (String)"listIntentsOptions cannot be null");
        String[] pathSegments = new String[]{"v1/workspaces", "intents"};
        String[] pathParameters = new String[]{listIntentsOptions.workspaceId()};
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getEndPoint(), (String[])pathSegments, (String[])pathParameters));
        builder.query(new Object[]{"version", this.versionDate});
        if (listIntentsOptions.export() != null) {
            builder.query(new Object[]{"export", String.valueOf(listIntentsOptions.export())});
        }
        if (listIntentsOptions.pageLimit() != null) {
            builder.query(new Object[]{"page_limit", String.valueOf(listIntentsOptions.pageLimit())});
        }
        if (listIntentsOptions.includeCount() != null) {
            builder.query(new Object[]{"include_count", String.valueOf(listIntentsOptions.includeCount())});
        }
        if (listIntentsOptions.sort() != null) {
            builder.query(new Object[]{"sort", listIntentsOptions.sort()});
        }
        if (listIntentsOptions.cursor() != null) {
            builder.query(new Object[]{"cursor", listIntentsOptions.cursor()});
        }
        if (listIntentsOptions.includeAudit() != null) {
            builder.query(new Object[]{"include_audit", String.valueOf(listIntentsOptions.includeAudit())});
        }
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getObject(IntentCollection.class));
    }

    public ServiceCall<Intent> updateIntent(UpdateIntentOptions updateIntentOptions) {
        Validator.notNull((Object)((Object)updateIntentOptions), (String)"updateIntentOptions cannot be null");
        String[] pathSegments = new String[]{"v1/workspaces", "intents"};
        String[] pathParameters = new String[]{updateIntentOptions.workspaceId(), updateIntentOptions.intent()};
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getEndPoint(), (String[])pathSegments, (String[])pathParameters));
        builder.query(new Object[]{"version", this.versionDate});
        JsonObject contentJson = new JsonObject();
        if (updateIntentOptions.newIntent() != null) {
            contentJson.addProperty("intent", updateIntentOptions.newIntent());
        }
        if (updateIntentOptions.newExamples() != null) {
            contentJson.add("examples", GsonSingleton.getGson().toJsonTree(updateIntentOptions.newExamples()));
        }
        if (updateIntentOptions.newDescription() != null) {
            contentJson.addProperty("description", updateIntentOptions.newDescription());
        }
        builder.bodyJson(contentJson);
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getObject(Intent.class));
    }

    public ServiceCall<Example> createExample(CreateExampleOptions createExampleOptions) {
        Validator.notNull((Object)((Object)createExampleOptions), (String)"createExampleOptions cannot be null");
        String[] pathSegments = new String[]{"v1/workspaces", "intents", "examples"};
        String[] pathParameters = new String[]{createExampleOptions.workspaceId(), createExampleOptions.intent()};
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getEndPoint(), (String[])pathSegments, (String[])pathParameters));
        builder.query(new Object[]{"version", this.versionDate});
        JsonObject contentJson = new JsonObject();
        contentJson.addProperty("text", createExampleOptions.text());
        builder.bodyJson(contentJson);
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getObject(Example.class));
    }

    public ServiceCall<Void> deleteExample(DeleteExampleOptions deleteExampleOptions) {
        Validator.notNull((Object)((Object)deleteExampleOptions), (String)"deleteExampleOptions cannot be null");
        String[] pathSegments = new String[]{"v1/workspaces", "intents", "examples"};
        String[] pathParameters = new String[]{deleteExampleOptions.workspaceId(), deleteExampleOptions.intent(), deleteExampleOptions.text()};
        RequestBuilder builder = RequestBuilder.delete((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getEndPoint(), (String[])pathSegments, (String[])pathParameters));
        builder.query(new Object[]{"version", this.versionDate});
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getVoid());
    }

    public ServiceCall<Example> getExample(GetExampleOptions getExampleOptions) {
        Validator.notNull((Object)((Object)getExampleOptions), (String)"getExampleOptions cannot be null");
        String[] pathSegments = new String[]{"v1/workspaces", "intents", "examples"};
        String[] pathParameters = new String[]{getExampleOptions.workspaceId(), getExampleOptions.intent(), getExampleOptions.text()};
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getEndPoint(), (String[])pathSegments, (String[])pathParameters));
        builder.query(new Object[]{"version", this.versionDate});
        if (getExampleOptions.includeAudit() != null) {
            builder.query(new Object[]{"include_audit", String.valueOf(getExampleOptions.includeAudit())});
        }
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getObject(Example.class));
    }

    public ServiceCall<ExampleCollection> listExamples(ListExamplesOptions listExamplesOptions) {
        Validator.notNull((Object)((Object)listExamplesOptions), (String)"listExamplesOptions cannot be null");
        String[] pathSegments = new String[]{"v1/workspaces", "intents", "examples"};
        String[] pathParameters = new String[]{listExamplesOptions.workspaceId(), listExamplesOptions.intent()};
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getEndPoint(), (String[])pathSegments, (String[])pathParameters));
        builder.query(new Object[]{"version", this.versionDate});
        if (listExamplesOptions.pageLimit() != null) {
            builder.query(new Object[]{"page_limit", String.valueOf(listExamplesOptions.pageLimit())});
        }
        if (listExamplesOptions.includeCount() != null) {
            builder.query(new Object[]{"include_count", String.valueOf(listExamplesOptions.includeCount())});
        }
        if (listExamplesOptions.sort() != null) {
            builder.query(new Object[]{"sort", listExamplesOptions.sort()});
        }
        if (listExamplesOptions.cursor() != null) {
            builder.query(new Object[]{"cursor", listExamplesOptions.cursor()});
        }
        if (listExamplesOptions.includeAudit() != null) {
            builder.query(new Object[]{"include_audit", String.valueOf(listExamplesOptions.includeAudit())});
        }
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getObject(ExampleCollection.class));
    }

    public ServiceCall<Example> updateExample(UpdateExampleOptions updateExampleOptions) {
        Validator.notNull((Object)((Object)updateExampleOptions), (String)"updateExampleOptions cannot be null");
        String[] pathSegments = new String[]{"v1/workspaces", "intents", "examples"};
        String[] pathParameters = new String[]{updateExampleOptions.workspaceId(), updateExampleOptions.intent(), updateExampleOptions.text()};
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getEndPoint(), (String[])pathSegments, (String[])pathParameters));
        builder.query(new Object[]{"version", this.versionDate});
        JsonObject contentJson = new JsonObject();
        if (updateExampleOptions.newText() != null) {
            contentJson.addProperty("text", updateExampleOptions.newText());
        }
        builder.bodyJson(contentJson);
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getObject(Example.class));
    }

    public ServiceCall<Counterexample> createCounterexample(CreateCounterexampleOptions createCounterexampleOptions) {
        Validator.notNull((Object)((Object)createCounterexampleOptions), (String)"createCounterexampleOptions cannot be null");
        String[] pathSegments = new String[]{"v1/workspaces", "counterexamples"};
        String[] pathParameters = new String[]{createCounterexampleOptions.workspaceId()};
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getEndPoint(), (String[])pathSegments, (String[])pathParameters));
        builder.query(new Object[]{"version", this.versionDate});
        JsonObject contentJson = new JsonObject();
        contentJson.addProperty("text", createCounterexampleOptions.text());
        builder.bodyJson(contentJson);
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getObject(Counterexample.class));
    }

    public ServiceCall<Void> deleteCounterexample(DeleteCounterexampleOptions deleteCounterexampleOptions) {
        Validator.notNull((Object)((Object)deleteCounterexampleOptions), (String)"deleteCounterexampleOptions cannot be null");
        String[] pathSegments = new String[]{"v1/workspaces", "counterexamples"};
        String[] pathParameters = new String[]{deleteCounterexampleOptions.workspaceId(), deleteCounterexampleOptions.text()};
        RequestBuilder builder = RequestBuilder.delete((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getEndPoint(), (String[])pathSegments, (String[])pathParameters));
        builder.query(new Object[]{"version", this.versionDate});
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getVoid());
    }

    public ServiceCall<Counterexample> getCounterexample(GetCounterexampleOptions getCounterexampleOptions) {
        Validator.notNull((Object)((Object)getCounterexampleOptions), (String)"getCounterexampleOptions cannot be null");
        String[] pathSegments = new String[]{"v1/workspaces", "counterexamples"};
        String[] pathParameters = new String[]{getCounterexampleOptions.workspaceId(), getCounterexampleOptions.text()};
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getEndPoint(), (String[])pathSegments, (String[])pathParameters));
        builder.query(new Object[]{"version", this.versionDate});
        if (getCounterexampleOptions.includeAudit() != null) {
            builder.query(new Object[]{"include_audit", String.valueOf(getCounterexampleOptions.includeAudit())});
        }
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getObject(Counterexample.class));
    }

    public ServiceCall<CounterexampleCollection> listCounterexamples(ListCounterexamplesOptions listCounterexamplesOptions) {
        Validator.notNull((Object)((Object)listCounterexamplesOptions), (String)"listCounterexamplesOptions cannot be null");
        String[] pathSegments = new String[]{"v1/workspaces", "counterexamples"};
        String[] pathParameters = new String[]{listCounterexamplesOptions.workspaceId()};
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getEndPoint(), (String[])pathSegments, (String[])pathParameters));
        builder.query(new Object[]{"version", this.versionDate});
        if (listCounterexamplesOptions.pageLimit() != null) {
            builder.query(new Object[]{"page_limit", String.valueOf(listCounterexamplesOptions.pageLimit())});
        }
        if (listCounterexamplesOptions.includeCount() != null) {
            builder.query(new Object[]{"include_count", String.valueOf(listCounterexamplesOptions.includeCount())});
        }
        if (listCounterexamplesOptions.sort() != null) {
            builder.query(new Object[]{"sort", listCounterexamplesOptions.sort()});
        }
        if (listCounterexamplesOptions.cursor() != null) {
            builder.query(new Object[]{"cursor", listCounterexamplesOptions.cursor()});
        }
        if (listCounterexamplesOptions.includeAudit() != null) {
            builder.query(new Object[]{"include_audit", String.valueOf(listCounterexamplesOptions.includeAudit())});
        }
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getObject(CounterexampleCollection.class));
    }

    public ServiceCall<Counterexample> updateCounterexample(UpdateCounterexampleOptions updateCounterexampleOptions) {
        Validator.notNull((Object)((Object)updateCounterexampleOptions), (String)"updateCounterexampleOptions cannot be null");
        String[] pathSegments = new String[]{"v1/workspaces", "counterexamples"};
        String[] pathParameters = new String[]{updateCounterexampleOptions.workspaceId(), updateCounterexampleOptions.text()};
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getEndPoint(), (String[])pathSegments, (String[])pathParameters));
        builder.query(new Object[]{"version", this.versionDate});
        JsonObject contentJson = new JsonObject();
        if (updateCounterexampleOptions.newText() != null) {
            contentJson.addProperty("text", updateCounterexampleOptions.newText());
        }
        builder.bodyJson(contentJson);
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getObject(Counterexample.class));
    }

    public ServiceCall<Entity> createEntity(CreateEntityOptions createEntityOptions) {
        Validator.notNull((Object)((Object)createEntityOptions), (String)"createEntityOptions cannot be null");
        String[] pathSegments = new String[]{"v1/workspaces", "entities"};
        String[] pathParameters = new String[]{createEntityOptions.workspaceId()};
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getEndPoint(), (String[])pathSegments, (String[])pathParameters));
        builder.query(new Object[]{"version", this.versionDate});
        JsonObject contentJson = new JsonObject();
        contentJson.addProperty("entity", createEntityOptions.entity());
        if (createEntityOptions.description() != null) {
            contentJson.addProperty("description", createEntityOptions.description());
        }
        if (createEntityOptions.metadata() != null) {
            contentJson.add("metadata", GsonSingleton.getGson().toJsonTree((Object)createEntityOptions.metadata()));
        }
        if (createEntityOptions.values() != null) {
            contentJson.add("values", GsonSingleton.getGson().toJsonTree(createEntityOptions.values()));
        }
        if (createEntityOptions.fuzzyMatch() != null) {
            contentJson.addProperty("fuzzy_match", createEntityOptions.fuzzyMatch());
        }
        builder.bodyJson(contentJson);
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getObject(Entity.class));
    }

    public ServiceCall<Void> deleteEntity(DeleteEntityOptions deleteEntityOptions) {
        Validator.notNull((Object)((Object)deleteEntityOptions), (String)"deleteEntityOptions cannot be null");
        String[] pathSegments = new String[]{"v1/workspaces", "entities"};
        String[] pathParameters = new String[]{deleteEntityOptions.workspaceId(), deleteEntityOptions.entity()};
        RequestBuilder builder = RequestBuilder.delete((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getEndPoint(), (String[])pathSegments, (String[])pathParameters));
        builder.query(new Object[]{"version", this.versionDate});
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getVoid());
    }

    public ServiceCall<EntityExport> getEntity(GetEntityOptions getEntityOptions) {
        Validator.notNull((Object)((Object)getEntityOptions), (String)"getEntityOptions cannot be null");
        String[] pathSegments = new String[]{"v1/workspaces", "entities"};
        String[] pathParameters = new String[]{getEntityOptions.workspaceId(), getEntityOptions.entity()};
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getEndPoint(), (String[])pathSegments, (String[])pathParameters));
        builder.query(new Object[]{"version", this.versionDate});
        if (getEntityOptions.export() != null) {
            builder.query(new Object[]{"export", String.valueOf(getEntityOptions.export())});
        }
        if (getEntityOptions.includeAudit() != null) {
            builder.query(new Object[]{"include_audit", String.valueOf(getEntityOptions.includeAudit())});
        }
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getObject(EntityExport.class));
    }

    public ServiceCall<EntityCollection> listEntities(ListEntitiesOptions listEntitiesOptions) {
        Validator.notNull((Object)((Object)listEntitiesOptions), (String)"listEntitiesOptions cannot be null");
        String[] pathSegments = new String[]{"v1/workspaces", "entities"};
        String[] pathParameters = new String[]{listEntitiesOptions.workspaceId()};
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getEndPoint(), (String[])pathSegments, (String[])pathParameters));
        builder.query(new Object[]{"version", this.versionDate});
        if (listEntitiesOptions.export() != null) {
            builder.query(new Object[]{"export", String.valueOf(listEntitiesOptions.export())});
        }
        if (listEntitiesOptions.pageLimit() != null) {
            builder.query(new Object[]{"page_limit", String.valueOf(listEntitiesOptions.pageLimit())});
        }
        if (listEntitiesOptions.includeCount() != null) {
            builder.query(new Object[]{"include_count", String.valueOf(listEntitiesOptions.includeCount())});
        }
        if (listEntitiesOptions.sort() != null) {
            builder.query(new Object[]{"sort", listEntitiesOptions.sort()});
        }
        if (listEntitiesOptions.cursor() != null) {
            builder.query(new Object[]{"cursor", listEntitiesOptions.cursor()});
        }
        if (listEntitiesOptions.includeAudit() != null) {
            builder.query(new Object[]{"include_audit", String.valueOf(listEntitiesOptions.includeAudit())});
        }
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getObject(EntityCollection.class));
    }

    public ServiceCall<Entity> updateEntity(UpdateEntityOptions updateEntityOptions) {
        Validator.notNull((Object)((Object)updateEntityOptions), (String)"updateEntityOptions cannot be null");
        String[] pathSegments = new String[]{"v1/workspaces", "entities"};
        String[] pathParameters = new String[]{updateEntityOptions.workspaceId(), updateEntityOptions.entity()};
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getEndPoint(), (String[])pathSegments, (String[])pathParameters));
        builder.query(new Object[]{"version", this.versionDate});
        JsonObject contentJson = new JsonObject();
        if (updateEntityOptions.newFuzzyMatch() != null) {
            contentJson.addProperty("fuzzy_match", updateEntityOptions.newFuzzyMatch());
        }
        if (updateEntityOptions.newEntity() != null) {
            contentJson.addProperty("entity", updateEntityOptions.newEntity());
        }
        if (updateEntityOptions.newMetadata() != null) {
            contentJson.add("metadata", GsonSingleton.getGson().toJsonTree((Object)updateEntityOptions.newMetadata()));
        }
        if (updateEntityOptions.newValues() != null) {
            contentJson.add("values", GsonSingleton.getGson().toJsonTree(updateEntityOptions.newValues()));
        }
        if (updateEntityOptions.newDescription() != null) {
            contentJson.addProperty("description", updateEntityOptions.newDescription());
        }
        builder.bodyJson(contentJson);
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getObject(Entity.class));
    }

    public ServiceCall<Value> createValue(CreateValueOptions createValueOptions) {
        Validator.notNull((Object)((Object)createValueOptions), (String)"createValueOptions cannot be null");
        String[] pathSegments = new String[]{"v1/workspaces", "entities", "values"};
        String[] pathParameters = new String[]{createValueOptions.workspaceId(), createValueOptions.entity()};
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getEndPoint(), (String[])pathSegments, (String[])pathParameters));
        builder.query(new Object[]{"version", this.versionDate});
        JsonObject contentJson = new JsonObject();
        contentJson.addProperty("value", createValueOptions.value());
        if (createValueOptions.metadata() != null) {
            contentJson.add("metadata", GsonSingleton.getGson().toJsonTree((Object)createValueOptions.metadata()));
        }
        if (createValueOptions.synonyms() != null) {
            contentJson.add("synonyms", GsonSingleton.getGson().toJsonTree(createValueOptions.synonyms()));
        }
        if (createValueOptions.patterns() != null) {
            contentJson.add("patterns", GsonSingleton.getGson().toJsonTree(createValueOptions.patterns()));
        }
        if (createValueOptions.valueType() != null) {
            contentJson.addProperty("type", createValueOptions.valueType());
        }
        builder.bodyJson(contentJson);
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getObject(Value.class));
    }

    public ServiceCall<Void> deleteValue(DeleteValueOptions deleteValueOptions) {
        Validator.notNull((Object)((Object)deleteValueOptions), (String)"deleteValueOptions cannot be null");
        String[] pathSegments = new String[]{"v1/workspaces", "entities", "values"};
        String[] pathParameters = new String[]{deleteValueOptions.workspaceId(), deleteValueOptions.entity(), deleteValueOptions.value()};
        RequestBuilder builder = RequestBuilder.delete((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getEndPoint(), (String[])pathSegments, (String[])pathParameters));
        builder.query(new Object[]{"version", this.versionDate});
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getVoid());
    }

    public ServiceCall<ValueExport> getValue(GetValueOptions getValueOptions) {
        Validator.notNull((Object)((Object)getValueOptions), (String)"getValueOptions cannot be null");
        String[] pathSegments = new String[]{"v1/workspaces", "entities", "values"};
        String[] pathParameters = new String[]{getValueOptions.workspaceId(), getValueOptions.entity(), getValueOptions.value()};
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getEndPoint(), (String[])pathSegments, (String[])pathParameters));
        builder.query(new Object[]{"version", this.versionDate});
        if (getValueOptions.export() != null) {
            builder.query(new Object[]{"export", String.valueOf(getValueOptions.export())});
        }
        if (getValueOptions.includeAudit() != null) {
            builder.query(new Object[]{"include_audit", String.valueOf(getValueOptions.includeAudit())});
        }
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getObject(ValueExport.class));
    }

    public ServiceCall<ValueCollection> listValues(ListValuesOptions listValuesOptions) {
        Validator.notNull((Object)((Object)listValuesOptions), (String)"listValuesOptions cannot be null");
        String[] pathSegments = new String[]{"v1/workspaces", "entities", "values"};
        String[] pathParameters = new String[]{listValuesOptions.workspaceId(), listValuesOptions.entity()};
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getEndPoint(), (String[])pathSegments, (String[])pathParameters));
        builder.query(new Object[]{"version", this.versionDate});
        if (listValuesOptions.export() != null) {
            builder.query(new Object[]{"export", String.valueOf(listValuesOptions.export())});
        }
        if (listValuesOptions.pageLimit() != null) {
            builder.query(new Object[]{"page_limit", String.valueOf(listValuesOptions.pageLimit())});
        }
        if (listValuesOptions.includeCount() != null) {
            builder.query(new Object[]{"include_count", String.valueOf(listValuesOptions.includeCount())});
        }
        if (listValuesOptions.sort() != null) {
            builder.query(new Object[]{"sort", listValuesOptions.sort()});
        }
        if (listValuesOptions.cursor() != null) {
            builder.query(new Object[]{"cursor", listValuesOptions.cursor()});
        }
        if (listValuesOptions.includeAudit() != null) {
            builder.query(new Object[]{"include_audit", String.valueOf(listValuesOptions.includeAudit())});
        }
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getObject(ValueCollection.class));
    }

    public ServiceCall<Value> updateValue(UpdateValueOptions updateValueOptions) {
        Validator.notNull((Object)((Object)updateValueOptions), (String)"updateValueOptions cannot be null");
        String[] pathSegments = new String[]{"v1/workspaces", "entities", "values"};
        String[] pathParameters = new String[]{updateValueOptions.workspaceId(), updateValueOptions.entity(), updateValueOptions.value()};
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getEndPoint(), (String[])pathSegments, (String[])pathParameters));
        builder.query(new Object[]{"version", this.versionDate});
        JsonObject contentJson = new JsonObject();
        if (updateValueOptions.newSynonyms() != null) {
            contentJson.add("synonyms", GsonSingleton.getGson().toJsonTree(updateValueOptions.newSynonyms()));
        }
        if (updateValueOptions.valueType() != null) {
            contentJson.addProperty("type", updateValueOptions.valueType());
        }
        if (updateValueOptions.newMetadata() != null) {
            contentJson.add("metadata", GsonSingleton.getGson().toJsonTree((Object)updateValueOptions.newMetadata()));
        }
        if (updateValueOptions.newPatterns() != null) {
            contentJson.add("patterns", GsonSingleton.getGson().toJsonTree(updateValueOptions.newPatterns()));
        }
        if (updateValueOptions.newValue() != null) {
            contentJson.addProperty("value", updateValueOptions.newValue());
        }
        builder.bodyJson(contentJson);
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getObject(Value.class));
    }

    public ServiceCall<Synonym> createSynonym(CreateSynonymOptions createSynonymOptions) {
        Validator.notNull((Object)((Object)createSynonymOptions), (String)"createSynonymOptions cannot be null");
        String[] pathSegments = new String[]{"v1/workspaces", "entities", "values", "synonyms"};
        String[] pathParameters = new String[]{createSynonymOptions.workspaceId(), createSynonymOptions.entity(), createSynonymOptions.value()};
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getEndPoint(), (String[])pathSegments, (String[])pathParameters));
        builder.query(new Object[]{"version", this.versionDate});
        JsonObject contentJson = new JsonObject();
        contentJson.addProperty("synonym", createSynonymOptions.synonym());
        builder.bodyJson(contentJson);
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getObject(Synonym.class));
    }

    public ServiceCall<Void> deleteSynonym(DeleteSynonymOptions deleteSynonymOptions) {
        Validator.notNull((Object)((Object)deleteSynonymOptions), (String)"deleteSynonymOptions cannot be null");
        String[] pathSegments = new String[]{"v1/workspaces", "entities", "values", "synonyms"};
        String[] pathParameters = new String[]{deleteSynonymOptions.workspaceId(), deleteSynonymOptions.entity(), deleteSynonymOptions.value(), deleteSynonymOptions.synonym()};
        RequestBuilder builder = RequestBuilder.delete((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getEndPoint(), (String[])pathSegments, (String[])pathParameters));
        builder.query(new Object[]{"version", this.versionDate});
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getVoid());
    }

    public ServiceCall<Synonym> getSynonym(GetSynonymOptions getSynonymOptions) {
        Validator.notNull((Object)((Object)getSynonymOptions), (String)"getSynonymOptions cannot be null");
        String[] pathSegments = new String[]{"v1/workspaces", "entities", "values", "synonyms"};
        String[] pathParameters = new String[]{getSynonymOptions.workspaceId(), getSynonymOptions.entity(), getSynonymOptions.value(), getSynonymOptions.synonym()};
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getEndPoint(), (String[])pathSegments, (String[])pathParameters));
        builder.query(new Object[]{"version", this.versionDate});
        if (getSynonymOptions.includeAudit() != null) {
            builder.query(new Object[]{"include_audit", String.valueOf(getSynonymOptions.includeAudit())});
        }
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getObject(Synonym.class));
    }

    public ServiceCall<SynonymCollection> listSynonyms(ListSynonymsOptions listSynonymsOptions) {
        Validator.notNull((Object)((Object)listSynonymsOptions), (String)"listSynonymsOptions cannot be null");
        String[] pathSegments = new String[]{"v1/workspaces", "entities", "values", "synonyms"};
        String[] pathParameters = new String[]{listSynonymsOptions.workspaceId(), listSynonymsOptions.entity(), listSynonymsOptions.value()};
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getEndPoint(), (String[])pathSegments, (String[])pathParameters));
        builder.query(new Object[]{"version", this.versionDate});
        if (listSynonymsOptions.pageLimit() != null) {
            builder.query(new Object[]{"page_limit", String.valueOf(listSynonymsOptions.pageLimit())});
        }
        if (listSynonymsOptions.includeCount() != null) {
            builder.query(new Object[]{"include_count", String.valueOf(listSynonymsOptions.includeCount())});
        }
        if (listSynonymsOptions.sort() != null) {
            builder.query(new Object[]{"sort", listSynonymsOptions.sort()});
        }
        if (listSynonymsOptions.cursor() != null) {
            builder.query(new Object[]{"cursor", listSynonymsOptions.cursor()});
        }
        if (listSynonymsOptions.includeAudit() != null) {
            builder.query(new Object[]{"include_audit", String.valueOf(listSynonymsOptions.includeAudit())});
        }
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getObject(SynonymCollection.class));
    }

    public ServiceCall<Synonym> updateSynonym(UpdateSynonymOptions updateSynonymOptions) {
        Validator.notNull((Object)((Object)updateSynonymOptions), (String)"updateSynonymOptions cannot be null");
        String[] pathSegments = new String[]{"v1/workspaces", "entities", "values", "synonyms"};
        String[] pathParameters = new String[]{updateSynonymOptions.workspaceId(), updateSynonymOptions.entity(), updateSynonymOptions.value(), updateSynonymOptions.synonym()};
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getEndPoint(), (String[])pathSegments, (String[])pathParameters));
        builder.query(new Object[]{"version", this.versionDate});
        JsonObject contentJson = new JsonObject();
        if (updateSynonymOptions.newSynonym() != null) {
            contentJson.addProperty("synonym", updateSynonymOptions.newSynonym());
        }
        builder.bodyJson(contentJson);
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getObject(Synonym.class));
    }

    public ServiceCall<DialogNode> createDialogNode(CreateDialogNodeOptions createDialogNodeOptions) {
        Validator.notNull((Object)((Object)createDialogNodeOptions), (String)"createDialogNodeOptions cannot be null");
        String[] pathSegments = new String[]{"v1/workspaces", "dialog_nodes"};
        String[] pathParameters = new String[]{createDialogNodeOptions.workspaceId()};
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getEndPoint(), (String[])pathSegments, (String[])pathParameters));
        builder.query(new Object[]{"version", this.versionDate});
        JsonObject contentJson = new JsonObject();
        contentJson.addProperty("dialog_node", createDialogNodeOptions.dialogNode());
        if (createDialogNodeOptions.description() != null) {
            contentJson.addProperty("description", createDialogNodeOptions.description());
        }
        if (createDialogNodeOptions.conditions() != null) {
            contentJson.addProperty("conditions", createDialogNodeOptions.conditions());
        }
        if (createDialogNodeOptions.parent() != null) {
            contentJson.addProperty("parent", createDialogNodeOptions.parent());
        }
        if (createDialogNodeOptions.previousSibling() != null) {
            contentJson.addProperty("previous_sibling", createDialogNodeOptions.previousSibling());
        }
        if (createDialogNodeOptions.output() != null) {
            contentJson.add("output", GsonSingleton.getGson().toJsonTree((Object)createDialogNodeOptions.output()));
        }
        if (createDialogNodeOptions.context() != null) {
            contentJson.add("context", GsonSingleton.getGson().toJsonTree((Object)createDialogNodeOptions.context()));
        }
        if (createDialogNodeOptions.metadata() != null) {
            contentJson.add("metadata", GsonSingleton.getGson().toJsonTree((Object)createDialogNodeOptions.metadata()));
        }
        if (createDialogNodeOptions.nextStep() != null) {
            contentJson.add("next_step", GsonSingleton.getGson().toJsonTree((Object)createDialogNodeOptions.nextStep()));
        }
        if (createDialogNodeOptions.actions() != null) {
            contentJson.add("actions", GsonSingleton.getGson().toJsonTree(createDialogNodeOptions.actions()));
        }
        if (createDialogNodeOptions.title() != null) {
            contentJson.addProperty("title", createDialogNodeOptions.title());
        }
        if (createDialogNodeOptions.nodeType() != null) {
            contentJson.addProperty("type", createDialogNodeOptions.nodeType());
        }
        if (createDialogNodeOptions.eventName() != null) {
            contentJson.addProperty("event_name", createDialogNodeOptions.eventName());
        }
        if (createDialogNodeOptions.variable() != null) {
            contentJson.addProperty("variable", createDialogNodeOptions.variable());
        }
        if (createDialogNodeOptions.digressIn() != null) {
            contentJson.addProperty("digress_in", createDialogNodeOptions.digressIn());
        }
        if (createDialogNodeOptions.digressOut() != null) {
            contentJson.addProperty("digress_out", createDialogNodeOptions.digressOut());
        }
        if (createDialogNodeOptions.digressOutSlots() != null) {
            contentJson.addProperty("digress_out_slots", createDialogNodeOptions.digressOutSlots());
        }
        builder.bodyJson(contentJson);
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getObject(DialogNode.class));
    }

    public ServiceCall<Void> deleteDialogNode(DeleteDialogNodeOptions deleteDialogNodeOptions) {
        Validator.notNull((Object)((Object)deleteDialogNodeOptions), (String)"deleteDialogNodeOptions cannot be null");
        String[] pathSegments = new String[]{"v1/workspaces", "dialog_nodes"};
        String[] pathParameters = new String[]{deleteDialogNodeOptions.workspaceId(), deleteDialogNodeOptions.dialogNode()};
        RequestBuilder builder = RequestBuilder.delete((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getEndPoint(), (String[])pathSegments, (String[])pathParameters));
        builder.query(new Object[]{"version", this.versionDate});
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getVoid());
    }

    public ServiceCall<DialogNode> getDialogNode(GetDialogNodeOptions getDialogNodeOptions) {
        Validator.notNull((Object)((Object)getDialogNodeOptions), (String)"getDialogNodeOptions cannot be null");
        String[] pathSegments = new String[]{"v1/workspaces", "dialog_nodes"};
        String[] pathParameters = new String[]{getDialogNodeOptions.workspaceId(), getDialogNodeOptions.dialogNode()};
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getEndPoint(), (String[])pathSegments, (String[])pathParameters));
        builder.query(new Object[]{"version", this.versionDate});
        if (getDialogNodeOptions.includeAudit() != null) {
            builder.query(new Object[]{"include_audit", String.valueOf(getDialogNodeOptions.includeAudit())});
        }
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getObject(DialogNode.class));
    }

    public ServiceCall<DialogNodeCollection> listDialogNodes(ListDialogNodesOptions listDialogNodesOptions) {
        Validator.notNull((Object)((Object)listDialogNodesOptions), (String)"listDialogNodesOptions cannot be null");
        String[] pathSegments = new String[]{"v1/workspaces", "dialog_nodes"};
        String[] pathParameters = new String[]{listDialogNodesOptions.workspaceId()};
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getEndPoint(), (String[])pathSegments, (String[])pathParameters));
        builder.query(new Object[]{"version", this.versionDate});
        if (listDialogNodesOptions.pageLimit() != null) {
            builder.query(new Object[]{"page_limit", String.valueOf(listDialogNodesOptions.pageLimit())});
        }
        if (listDialogNodesOptions.includeCount() != null) {
            builder.query(new Object[]{"include_count", String.valueOf(listDialogNodesOptions.includeCount())});
        }
        if (listDialogNodesOptions.sort() != null) {
            builder.query(new Object[]{"sort", listDialogNodesOptions.sort()});
        }
        if (listDialogNodesOptions.cursor() != null) {
            builder.query(new Object[]{"cursor", listDialogNodesOptions.cursor()});
        }
        if (listDialogNodesOptions.includeAudit() != null) {
            builder.query(new Object[]{"include_audit", String.valueOf(listDialogNodesOptions.includeAudit())});
        }
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getObject(DialogNodeCollection.class));
    }

    public ServiceCall<DialogNode> updateDialogNode(UpdateDialogNodeOptions updateDialogNodeOptions) {
        Validator.notNull((Object)((Object)updateDialogNodeOptions), (String)"updateDialogNodeOptions cannot be null");
        String[] pathSegments = new String[]{"v1/workspaces", "dialog_nodes"};
        String[] pathParameters = new String[]{updateDialogNodeOptions.workspaceId(), updateDialogNodeOptions.dialogNode()};
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getEndPoint(), (String[])pathSegments, (String[])pathParameters));
        builder.query(new Object[]{"version", this.versionDate});
        JsonObject contentJson = new JsonObject();
        if (updateDialogNodeOptions.nodeType() != null) {
            contentJson.addProperty("type", updateDialogNodeOptions.nodeType());
        }
        if (updateDialogNodeOptions.newActions() != null) {
            contentJson.add("actions", GsonSingleton.getGson().toJsonTree(updateDialogNodeOptions.newActions()));
        }
        if (updateDialogNodeOptions.newConditions() != null) {
            contentJson.addProperty("conditions", updateDialogNodeOptions.newConditions());
        }
        if (updateDialogNodeOptions.newContext() != null) {
            contentJson.add("context", GsonSingleton.getGson().toJsonTree((Object)updateDialogNodeOptions.newContext()));
        }
        if (updateDialogNodeOptions.newPreviousSibling() != null) {
            contentJson.addProperty("previous_sibling", updateDialogNodeOptions.newPreviousSibling());
        }
        if (updateDialogNodeOptions.newVariable() != null) {
            contentJson.addProperty("variable", updateDialogNodeOptions.newVariable());
        }
        if (updateDialogNodeOptions.newMetadata() != null) {
            contentJson.add("metadata", GsonSingleton.getGson().toJsonTree((Object)updateDialogNodeOptions.newMetadata()));
        }
        if (updateDialogNodeOptions.newTitle() != null) {
            contentJson.addProperty("title", updateDialogNodeOptions.newTitle());
        }
        if (updateDialogNodeOptions.newDescription() != null) {
            contentJson.addProperty("description", updateDialogNodeOptions.newDescription());
        }
        if (updateDialogNodeOptions.newDigressOut() != null) {
            contentJson.addProperty("digress_out", updateDialogNodeOptions.newDigressOut());
        }
        if (updateDialogNodeOptions.newEventName() != null) {
            contentJson.addProperty("event_name", updateDialogNodeOptions.newEventName());
        }
        if (updateDialogNodeOptions.newDigressOutSlots() != null) {
            contentJson.addProperty("digress_out_slots", updateDialogNodeOptions.newDigressOutSlots());
        }
        if (updateDialogNodeOptions.newNextStep() != null) {
            contentJson.add("next_step", GsonSingleton.getGson().toJsonTree((Object)updateDialogNodeOptions.newNextStep()));
        }
        if (updateDialogNodeOptions.newDigressIn() != null) {
            contentJson.addProperty("digress_in", updateDialogNodeOptions.newDigressIn());
        }
        if (updateDialogNodeOptions.newOutput() != null) {
            contentJson.add("output", GsonSingleton.getGson().toJsonTree((Object)updateDialogNodeOptions.newOutput()));
        }
        if (updateDialogNodeOptions.newParent() != null) {
            contentJson.addProperty("parent", updateDialogNodeOptions.newParent());
        }
        if (updateDialogNodeOptions.newDialogNode() != null) {
            contentJson.addProperty("dialog_node", updateDialogNodeOptions.newDialogNode());
        }
        builder.bodyJson(contentJson);
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getObject(DialogNode.class));
    }

    public ServiceCall<LogCollection> listAllLogs(ListAllLogsOptions listAllLogsOptions) {
        Validator.notNull((Object)((Object)listAllLogsOptions), (String)"listAllLogsOptions cannot be null");
        String[] pathSegments = new String[]{"v1/logs"};
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getEndPoint(), (String[])pathSegments));
        builder.query(new Object[]{"version", this.versionDate});
        builder.query(new Object[]{"filter", listAllLogsOptions.filter()});
        if (listAllLogsOptions.sort() != null) {
            builder.query(new Object[]{"sort", listAllLogsOptions.sort()});
        }
        if (listAllLogsOptions.pageLimit() != null) {
            builder.query(new Object[]{"page_limit", String.valueOf(listAllLogsOptions.pageLimit())});
        }
        if (listAllLogsOptions.cursor() != null) {
            builder.query(new Object[]{"cursor", listAllLogsOptions.cursor()});
        }
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getObject(LogCollection.class));
    }

    public ServiceCall<LogCollection> listLogs(ListLogsOptions listLogsOptions) {
        Validator.notNull((Object)((Object)listLogsOptions), (String)"listLogsOptions cannot be null");
        String[] pathSegments = new String[]{"v1/workspaces", "logs"};
        String[] pathParameters = new String[]{listLogsOptions.workspaceId()};
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getEndPoint(), (String[])pathSegments, (String[])pathParameters));
        builder.query(new Object[]{"version", this.versionDate});
        if (listLogsOptions.sort() != null) {
            builder.query(new Object[]{"sort", listLogsOptions.sort()});
        }
        if (listLogsOptions.filter() != null) {
            builder.query(new Object[]{"filter", listLogsOptions.filter()});
        }
        if (listLogsOptions.pageLimit() != null) {
            builder.query(new Object[]{"page_limit", String.valueOf(listLogsOptions.pageLimit())});
        }
        if (listLogsOptions.cursor() != null) {
            builder.query(new Object[]{"cursor", listLogsOptions.cursor()});
        }
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getObject(LogCollection.class));
    }
}

