/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.assistant.v1.model;

import com.ibm.watson.developer_cloud.service.model.GenericModel;
import com.ibm.watson.developer_cloud.util.Validator;

public class GetExampleOptions
extends GenericModel {
    private String workspaceId;
    private String intent;
    private String text;
    private Boolean includeAudit;

    private GetExampleOptions(Builder builder) {
        Validator.notEmpty((String)builder.workspaceId, (String)"workspaceId cannot be empty");
        Validator.notEmpty((String)builder.intent, (String)"intent cannot be empty");
        Validator.notEmpty((String)builder.text, (String)"text cannot be empty");
        this.workspaceId = builder.workspaceId;
        this.intent = builder.intent;
        this.text = builder.text;
        this.includeAudit = builder.includeAudit;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String workspaceId() {
        return this.workspaceId;
    }

    public String intent() {
        return this.intent;
    }

    public String text() {
        return this.text;
    }

    public Boolean includeAudit() {
        return this.includeAudit;
    }

    public static class Builder {
        private String workspaceId;
        private String intent;
        private String text;
        private Boolean includeAudit;

        private Builder(GetExampleOptions getExampleOptions) {
            this.workspaceId = getExampleOptions.workspaceId;
            this.intent = getExampleOptions.intent;
            this.text = getExampleOptions.text;
            this.includeAudit = getExampleOptions.includeAudit;
        }

        public Builder() {
        }

        public Builder(String workspaceId, String intent, String text) {
            this.workspaceId = workspaceId;
            this.intent = intent;
            this.text = text;
        }

        public GetExampleOptions build() {
            return new GetExampleOptions(this);
        }

        public Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public Builder intent(String intent) {
            this.intent = intent;
            return this;
        }

        public Builder text(String text) {
            this.text = text;
            return this;
        }

        public Builder includeAudit(Boolean includeAudit) {
            this.includeAudit = includeAudit;
            return this;
        }
    }
}

