/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.assistant.v1.model;

import com.ibm.watson.developer_cloud.assistant.v1.model.CreateCounterexample;
import com.ibm.watson.developer_cloud.assistant.v1.model.CreateDialogNode;
import com.ibm.watson.developer_cloud.assistant.v1.model.CreateEntity;
import com.ibm.watson.developer_cloud.assistant.v1.model.CreateIntent;
import com.ibm.watson.developer_cloud.service.model.GenericModel;
import com.ibm.watson.developer_cloud.util.Validator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class UpdateWorkspaceOptions
extends GenericModel {
    private String workspaceId;
    private String name;
    private String description;
    private String language;
    private List<CreateIntent> intents;
    private List<CreateEntity> entities;
    private List<CreateDialogNode> dialogNodes;
    private List<CreateCounterexample> counterexamples;
    private Map metadata;
    private Boolean learningOptOut;
    private Boolean append;

    private UpdateWorkspaceOptions(Builder builder) {
        Validator.notEmpty((String)builder.workspaceId, (String)"workspaceId cannot be empty");
        this.workspaceId = builder.workspaceId;
        this.name = builder.name;
        this.description = builder.description;
        this.language = builder.language;
        this.intents = builder.intents;
        this.entities = builder.entities;
        this.dialogNodes = builder.dialogNodes;
        this.counterexamples = builder.counterexamples;
        this.metadata = builder.metadata;
        this.learningOptOut = builder.learningOptOut;
        this.append = builder.append;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String workspaceId() {
        return this.workspaceId;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public String language() {
        return this.language;
    }

    public List<CreateIntent> intents() {
        return this.intents;
    }

    public List<CreateEntity> entities() {
        return this.entities;
    }

    public List<CreateDialogNode> dialogNodes() {
        return this.dialogNodes;
    }

    public List<CreateCounterexample> counterexamples() {
        return this.counterexamples;
    }

    public Map metadata() {
        return this.metadata;
    }

    public Boolean learningOptOut() {
        return this.learningOptOut;
    }

    public Boolean append() {
        return this.append;
    }

    public static class Builder {
        private String workspaceId;
        private String name;
        private String description;
        private String language;
        private List<CreateIntent> intents;
        private List<CreateEntity> entities;
        private List<CreateDialogNode> dialogNodes;
        private List<CreateCounterexample> counterexamples;
        private Map metadata;
        private Boolean learningOptOut;
        private Boolean append;

        private Builder(UpdateWorkspaceOptions updateWorkspaceOptions) {
            this.workspaceId = updateWorkspaceOptions.workspaceId;
            this.name = updateWorkspaceOptions.name;
            this.description = updateWorkspaceOptions.description;
            this.language = updateWorkspaceOptions.language;
            this.intents = updateWorkspaceOptions.intents;
            this.entities = updateWorkspaceOptions.entities;
            this.dialogNodes = updateWorkspaceOptions.dialogNodes;
            this.counterexamples = updateWorkspaceOptions.counterexamples;
            this.metadata = updateWorkspaceOptions.metadata;
            this.learningOptOut = updateWorkspaceOptions.learningOptOut;
            this.append = updateWorkspaceOptions.append;
        }

        public Builder() {
        }

        public Builder(String workspaceId) {
            this.workspaceId = workspaceId;
        }

        public UpdateWorkspaceOptions build() {
            return new UpdateWorkspaceOptions(this);
        }

        public Builder addIntent(CreateIntent intent) {
            Validator.notNull((Object)((Object)intent), (String)"intent cannot be null");
            if (this.intents == null) {
                this.intents = new ArrayList<CreateIntent>();
            }
            this.intents.add(intent);
            return this;
        }

        public Builder addEntity(CreateEntity entity) {
            Validator.notNull((Object)((Object)entity), (String)"entity cannot be null");
            if (this.entities == null) {
                this.entities = new ArrayList<CreateEntity>();
            }
            this.entities.add(entity);
            return this;
        }

        public Builder addDialogNode(CreateDialogNode dialogNode) {
            Validator.notNull((Object)((Object)dialogNode), (String)"dialogNode cannot be null");
            if (this.dialogNodes == null) {
                this.dialogNodes = new ArrayList<CreateDialogNode>();
            }
            this.dialogNodes.add(dialogNode);
            return this;
        }

        public Builder addCounterexample(CreateCounterexample counterexample) {
            Validator.notNull((Object)((Object)counterexample), (String)"counterexample cannot be null");
            if (this.counterexamples == null) {
                this.counterexamples = new ArrayList<CreateCounterexample>();
            }
            this.counterexamples.add(counterexample);
            return this;
        }

        public Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder language(String language) {
            this.language = language;
            return this;
        }

        public Builder intents(List<CreateIntent> intents) {
            this.intents = intents;
            return this;
        }

        public Builder entities(List<CreateEntity> entities) {
            this.entities = entities;
            return this;
        }

        public Builder dialogNodes(List<CreateDialogNode> dialogNodes) {
            this.dialogNodes = dialogNodes;
            return this;
        }

        public Builder counterexamples(List<CreateCounterexample> counterexamples) {
            this.counterexamples = counterexamples;
            return this;
        }

        public Builder metadata(Map metadata) {
            this.metadata = metadata;
            return this;
        }

        public Builder learningOptOut(Boolean learningOptOut) {
            this.learningOptOut = learningOptOut;
            return this;
        }

        public Builder append(Boolean append) {
            this.append = append;
            return this;
        }
    }
}

