/*
 * Decompiled with CFR 0.152.
 */
package winter.com.ideaaedi.classwinter.util;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.NoSuchElementException;
import sun.misc.Unsafe;
import winter.com.ideaaedi.classwinter.exception.JVMException;

public class JVMUtil {
    private static final Method findNative;
    private static final ClassLoader classLoader;
    public static final Unsafe unsafe;

    public static long getSymbol(String name) {
        long address = JVMUtil.lookup(name);
        if (address == 0L) {
            throw new NoSuchElementException("No such symbol: " + name);
        }
        return JVMUtil.getLong(address);
    }

    public static long getLong(long addr) {
        return unsafe.getLong(addr);
    }

    public static void putAddress(long addr, long val) {
        unsafe.putAddress(addr, val);
    }

    public static long lookup(String name) {
        try {
            return (Long)findNative.invoke(null, classLoader, name);
        }
        catch (InvocationTargetException e) {
            throw new JVMException(e.getTargetException());
        }
        catch (IllegalAccessException e) {
            throw new JVMException(e);
        }
    }

    private static Unsafe getUnsafe() {
        try {
            Field f = Unsafe.class.getDeclaredField("theUnsafe");
            f.setAccessible(true);
            return (Unsafe)f.get(null);
        }
        catch (Exception e) {
            throw new JVMException("Unable to get Unsafe", e);
        }
    }

    static {
        unsafe = JVMUtil.getUnsafe();
        String os = System.getProperty("os.name").toLowerCase();
        if (os.contains("windows")) {
            String vmName = System.getProperty("java.vm.name");
            String dll = vmName.contains("Client VM") ? "/bin/client/jvm.dll" : "/bin/server/jvm.dll";
            try {
                System.load(System.getProperty("java.home") + dll);
            }
            catch (UnsatisfiedLinkError e) {
                throw new JVMException("Cannot find jvm.dll. Unsupported JVM?");
            }
            classLoader = JVMUtil.class.getClassLoader();
        } else {
            classLoader = null;
        }
        try {
            findNative = ClassLoader.class.getDeclaredMethod("findNative", ClassLoader.class, String.class);
            findNative.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw new JVMException("Method ClassLoader.findNative not found");
        }
    }
}

