/*
 * Decompiled with CFR 0.152.
 */
package winter.com.ideaaedi.classwinter.util;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.atomic.AtomicBoolean;

public final class Logger {
    public static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    public static final AtomicBoolean ENABLE_DEBUG = new AtomicBoolean(false);

    private Logger() {
    }

    public static void debug(String msg) {
        if (ENABLE_DEBUG.get()) {
            String log = DATE_TIME_FORMATTER.format(LocalDateTime.now()) + " [DEBUG] " + msg;
            System.out.println(log);
        }
    }

    public static void debug(Class<?> clazz, String msg) {
        if (ENABLE_DEBUG.get()) {
            String log = DATE_TIME_FORMATTER.format(LocalDateTime.now()) + " [DEBUG] " + clazz.getName() + ": " + msg;
            System.out.println(log);
        }
    }

    public static void simpleInfo(String msg) {
        System.out.println("[INFO] " + msg);
    }

    public static void info(String msg) {
        System.out.println(DATE_TIME_FORMATTER.format(LocalDateTime.now()) + " [ INFO] " + msg);
    }

    public static void info(Class<?> clazz, String msg) {
        System.out.println(DATE_TIME_FORMATTER.format(LocalDateTime.now()) + " [ INFO] " + clazz.getName() + ": " + msg);
    }

    public static void warn(String msg) {
        System.out.println(DATE_TIME_FORMATTER.format(LocalDateTime.now()) + " [ WARN] " + msg);
    }

    public static void warn(Class<?> clazz, String msg) {
        System.out.println(DATE_TIME_FORMATTER.format(LocalDateTime.now()) + " [ WARN] " + clazz.getName() + ": " + msg);
    }

    public static void error(String msg) {
        System.out.println(DATE_TIME_FORMATTER.format(LocalDateTime.now()) + " [ERROR] " + msg);
    }

    public static void error(Class<?> clazz, String msg) {
        System.out.println(DATE_TIME_FORMATTER.format(LocalDateTime.now()) + " [ERROR] " + clazz.getName() + ": " + msg);
    }
}

