/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.extensions;

import com.intellij.openapi.extensions.SortingException;
import java.util.ArrayList;
import org.jdom.Element;
import org.jetbrains.annotations.Nullable;

public abstract class LoadingOrder {
    public static final LoadingOrder ANY = new LoadingOrder("ANY"){

        int findPlace(Orderable[] orderables, int current) {
            return -1;
        }
    };
    public static final LoadingOrder FIRST = new LoadingOrder("FIRST"){

        int findPlace(Orderable[] orderables, int current) {
            return -3;
        }
    };
    public static final LoadingOrder LAST = new LoadingOrder("LAST"){

        int findPlace(Orderable[] orderables, int current) {
            return -3;
        }
    };
    private static final int DONT_CARE = -1;
    static final int ACCEPTABLE = -2;
    private static final int SPECIAL = -3;
    private final String myName;
    private static final String BEFORE_STR = "BEFORE:";
    private static final String AFTER_STR = "AFTER:";

    private LoadingOrder(String name) {
        this.myName = name;
    }

    public String toString() {
        return this.myName;
    }

    public static LoadingOrder before(String id) {
        return new BeforeLoadingOrder(id);
    }

    public static LoadingOrder after(String id) {
        return new AfterLoadingOrder(id);
    }

    abstract int findPlace(Orderable[] var1, int var2);

    public static void sort(Orderable[] orderables) {
        Orderable first = null;
        Orderable last = null;
        ArrayList<Orderable> other = new ArrayList<Orderable>();
        for (int i = 0; i < orderables.length; ++i) {
            Orderable orderable = orderables[i];
            if (orderable.getOrder() == FIRST) {
                if (first != null) {
                    throw new SortingException("More than one 'first' element", new Element[]{first.getDescribingElement(), orderable.getDescribingElement()});
                }
                first = orderable;
                continue;
            }
            if (orderable.getOrder() == LAST) {
                if (last != null) {
                    throw new SortingException("More than one 'last' element", new Element[]{last.getDescribingElement(), orderable.getDescribingElement()});
                }
                last = orderable;
                continue;
            }
            other.add(orderable);
        }
        ArrayList<Orderable> result = new ArrayList<Orderable>();
        if (first != null) {
            result.add(first);
        }
        result.addAll(other);
        if (last != null) {
            result.add(last);
        }
        assert (result.size() == orderables.length);
        Orderable[] presorted = result.toArray(new Orderable[result.size()]);
        int swapCount = 0;
        int maxSwaps = presorted.length * presorted.length;
        for (int i = 0; i < presorted.length; ++i) {
            Orderable orderable = presorted[i];
            LoadingOrder order = orderable.getOrder();
            int place = order.findPlace(presorted, i);
            if (place == -1 || place == -2 || place == -3) continue;
            if (place == 0 && presorted[0].getOrder() == FIRST) {
                throw new SortingException("Element attempts to go before the specified first", new Element[]{orderable.getDescribingElement(), presorted[0].getDescribingElement()});
            }
            if (place == presorted.length - 1 && presorted[presorted.length - 1].getOrder() == LAST) {
                throw new SortingException("Element attempts to go after the specified last", new Element[]{orderable.getDescribingElement(), presorted[presorted.length - 1].getDescribingElement()});
            }
            LoadingOrder.moveTo(presorted, i, place);
            i = i > place ? place : --i;
            if (++swapCount <= maxSwaps) continue;
            ArrayList<Element> allElements = new ArrayList<Element>();
            for (int j = 0; j < presorted.length; ++j) {
                allElements.add(presorted[j].getDescribingElement());
            }
            throw new SortingException("Could not satisfy sorting requirements", allElements.toArray(new Element[allElements.size()]));
        }
        System.arraycopy(presorted, 0, orderables, 0, presorted.length);
    }

    private static void moveTo(Orderable[] orderables, int from, int to) {
        if (to == from) {
            return;
        }
        Orderable movedOrderable = orderables[from];
        if (to > from) {
            for (int i = from; i < to; ++i) {
                orderables[i] = orderables[i + 1];
            }
        } else {
            for (int i = from; i > to; --i) {
                orderables[i] = orderables[i - 1];
            }
        }
        orderables[to] = movedOrderable;
    }

    public static LoadingOrder readOrder(String orderAttr) {
        if (orderAttr != null) {
            if ("FIRST".equalsIgnoreCase(orderAttr)) {
                return FIRST;
            }
            if ("LAST".equalsIgnoreCase(orderAttr)) {
                return LAST;
            }
            if ("ANY".equalsIgnoreCase(orderAttr)) {
                return ANY;
            }
            if (orderAttr.toUpperCase().startsWith(BEFORE_STR)) {
                return LoadingOrder.before(orderAttr.substring(BEFORE_STR.length()));
            }
            if (orderAttr.toUpperCase().startsWith(AFTER_STR)) {
                return LoadingOrder.after(orderAttr.substring(AFTER_STR.length()));
            }
        }
        return ANY;
    }

    public static interface Orderable {
        @Nullable
        public String getOrderId();

        public LoadingOrder getOrder();

        public Element getDescribingElement();
    }

    private static class AfterLoadingOrder
    extends LoadingOrder {
        private final String myId;

        public AfterLoadingOrder(String id) {
            super(LoadingOrder.AFTER_STR + id);
            this.myId = id;
        }

        int findPlace(Orderable[] orderables, int current) {
            for (int i = 0; i < orderables.length; ++i) {
                Orderable orderable = orderables[i];
                String orderId = orderable.getOrderId();
                if (!this.myId.equals(orderId)) continue;
                if (current > i) {
                    return -2;
                }
                return i;
            }
            return -1;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof AfterLoadingOrder)) {
                return false;
            }
            AfterLoadingOrder afterLoadingOrder = (AfterLoadingOrder)o;
            return this.myId.equals(afterLoadingOrder.myId);
        }

        public int hashCode() {
            return this.myId.hashCode();
        }
    }

    private static class BeforeLoadingOrder
    extends LoadingOrder {
        private final String myId;

        public BeforeLoadingOrder(String id) {
            super(LoadingOrder.BEFORE_STR + id);
            this.myId = id;
        }

        int findPlace(Orderable[] orderables, int current) {
            for (int i = 0; i < orderables.length; ++i) {
                Orderable orderable = orderables[i];
                String orderId = orderable.getOrderId();
                if (!this.myId.equals(orderId)) continue;
                if (current < i) {
                    return -2;
                }
                return i;
            }
            return -1;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof BeforeLoadingOrder)) {
                return false;
            }
            BeforeLoadingOrder beforeLoadingOrder = (BeforeLoadingOrder)o;
            return this.myId.equals(beforeLoadingOrder.myId);
        }

        public int hashCode() {
            return this.myId.hashCode();
        }
    }
}

