/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.extensions;

import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SmartExtensionPoint<Extension, V>
implements ExtensionPointListener<Extension> {
    private final Collection<V> myExplicitExtensions;
    private ExtensionPoint<Extension> myExtensionPoint;
    private List<V> myCache;

    protected SmartExtensionPoint(@NotNull Collection<V> explicitExtensions) {
        if (explicitExtensions == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/extensions/SmartExtensionPoint.<init> must not be null");
        }
        this.myExplicitExtensions = explicitExtensions;
    }

    @NotNull
    protected abstract ExtensionPoint<Extension> getExtensionPoint();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addExplicitExtension(@NotNull V extension) {
        if (extension == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/extensions/SmartExtensionPoint.addExplicitExtension must not be null");
        }
        Collection<V> collection = this.myExplicitExtensions;
        synchronized (collection) {
            this.myExplicitExtensions.add(extension);
            this.myCache = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeExplicitExtension(@NotNull V extension) {
        if (extension == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/extensions/SmartExtensionPoint.removeExplicitExtension must not be null");
        }
        Collection<V> collection = this.myExplicitExtensions;
        synchronized (collection) {
            this.myExplicitExtensions.remove(extension);
            this.myCache = null;
        }
    }

    @Nullable
    protected abstract V getExtension(@NotNull Extension var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public final List<V> getExtensions() {
        Collection<V> collection = this.myExplicitExtensions;
        // MONITORENTER : collection
        if (this.myCache == null) {
            this.myExtensionPoint = this.getExtensionPoint();
            this.myExtensionPoint.addExtensionPointListener(this);
            this.myCache = new ArrayList<V>(this.myExplicitExtensions);
            this.myCache.addAll(ContainerUtil.mapNotNull((Object[])this.myExtensionPoint.getExtensions(), (Function)new NullableFunction<Extension, V>(){

                @Nullable
                public V fun(Extension extension) {
                    return SmartExtensionPoint.this.getExtension(extension);
                }
            }));
        }
        List<V> list = this.myCache;
        // MONITOREXIT : collection
        if (list == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/extensions/SmartExtensionPoint.getExtensions must not return null");
        return list;
    }

    @Override
    public final void extensionAdded(Extension extension, @Nullable PluginDescriptor pluginDescriptor) {
        this.dropCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void dropCache() {
        Collection<V> collection = this.myExplicitExtensions;
        synchronized (collection) {
            if (this.myCache != null) {
                this.myCache = null;
                this.myExtensionPoint.removeExtensionPointListener(this);
                this.myExtensionPoint = null;
            }
        }
    }

    @Override
    public final void extensionRemoved(Extension extension, @Nullable PluginDescriptor pluginDescriptor) {
        this.dropCache();
    }
}

