/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.extensions.impl;

import com.intellij.openapi.extensions.ExtensionInitializer;
import com.intellij.openapi.extensions.LoadingOrder;
import com.intellij.openapi.extensions.PluginAware;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.util.pico.AssignableToComponentAdapter;
import com.intellij.util.xmlb.XmlSerializer;
import org.jdom.Element;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoInitializationException;
import org.picocontainer.PicoIntrospectionException;
import org.picocontainer.PicoVisitor;
import org.picocontainer.defaults.AssignabilityRegistrationException;
import org.picocontainer.defaults.CachingComponentAdapter;
import org.picocontainer.defaults.ConstructorInjectionComponentAdapter;
import org.picocontainer.defaults.NotConcreteRegistrationException;

public class ExtensionComponentAdapter
implements ComponentAdapter,
LoadingOrder.Orderable,
AssignableToComponentAdapter {
    private Object myComponentInstance;
    private String myImplementationClassName;
    private Element myExtensionElement;
    private PicoContainer myContainer;
    private PluginDescriptor myPluginDescriptor;
    private boolean myDeserializeInstance;
    private ComponentAdapter myDelegate;
    private Class myImplementationClass;

    public ExtensionComponentAdapter(String implementationClass, Element extensionElement, PicoContainer container, PluginDescriptor pluginDescriptor, boolean deserializeInstance) {
        this.myImplementationClassName = implementationClass;
        this.myExtensionElement = extensionElement;
        this.myContainer = container;
        this.myPluginDescriptor = pluginDescriptor;
        this.myDeserializeInstance = deserializeInstance;
    }

    public Object getComponentKey() {
        return this;
    }

    public Class getComponentImplementation() {
        return this.loadClass(this.myImplementationClassName);
    }

    public Object getComponentInstance(PicoContainer container) throws PicoInitializationException, PicoIntrospectionException, AssignabilityRegistrationException, NotConcreteRegistrationException {
        if (this.myComponentInstance == null) {
            if (!Element.class.equals((Object)this.getComponentImplementation())) {
                ExtensionInitializer initializer;
                Object componentInstance = this.getDelegate().getComponentInstance(container);
                if (this.myDeserializeInstance) {
                    try {
                        XmlSerializer.deserializeInto((Object)componentInstance, (Element)this.myExtensionElement);
                    }
                    catch (Exception e) {
                        throw new PicoInitializationException((Throwable)e);
                    }
                }
                if ((initializer = (ExtensionInitializer)container.getComponentInstance(ExtensionInitializer.class)) != null) {
                    initializer.initExtension(componentInstance);
                }
                this.myComponentInstance = componentInstance;
            } else {
                this.myComponentInstance = this.myExtensionElement;
            }
            if (this.myComponentInstance instanceof PluginAware) {
                PluginAware pluginAware = (PluginAware)this.myComponentInstance;
                pluginAware.setPluginDescriptor(this.myPluginDescriptor);
            }
        }
        return this.myComponentInstance;
    }

    public void verify(PicoContainer container) throws PicoIntrospectionException {
        throw new UnsupportedOperationException("Method verify is not supported in " + this.getClass());
    }

    public void accept(PicoVisitor visitor) {
        throw new UnsupportedOperationException("Method accept is not supported in " + this.getClass());
    }

    public Object getExtension() {
        return this.getComponentInstance(this.myContainer);
    }

    public LoadingOrder getOrder() {
        String orderAttr = this.myExtensionElement.getAttributeValue("order");
        return LoadingOrder.readOrder(orderAttr);
    }

    public String getOrderId() {
        return this.myExtensionElement.getAttributeValue("id");
    }

    private Element getExtensionElement() {
        return this.myExtensionElement;
    }

    public Element getDescribingElement() {
        return this.getExtensionElement();
    }

    public PluginId getPluginName() {
        return this.myPluginDescriptor.getPluginId();
    }

    public PluginDescriptor getPluginDescriptor() {
        return this.myPluginDescriptor;
    }

    private Class loadClass(String className) {
        if (this.myImplementationClass != null) {
            return this.myImplementationClass;
        }
        try {
            ClassLoader classLoader;
            ClassLoader classLoader2 = classLoader = this.myPluginDescriptor != null ? this.myPluginDescriptor.getPluginClassLoader() : this.getClass().getClassLoader();
            if (classLoader == null) {
                classLoader = this.getClass().getClassLoader();
            }
            this.myImplementationClass = Class.forName(className, true, classLoader);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        return this.myImplementationClass;
    }

    private synchronized ComponentAdapter getDelegate() {
        if (this.myDelegate == null) {
            this.myDelegate = new CachingComponentAdapter((ComponentAdapter)new ConstructorInjectionComponentAdapter(this.getComponentKey(), this.loadClass(this.myImplementationClassName), null, true));
        }
        return this.myDelegate;
    }

    public boolean isAssignableTo(Class aClass) {
        return aClass.getName().equals(this.myImplementationClassName);
    }
}

