/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.commons.utils;

import com.itextpdf.commons.utils.MessageFormatUtil;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ZipFileReader
implements Closeable {
    private final ZipFile zipFile;

    public ZipFileReader(String archivePath) throws IOException {
        if (archivePath == null) {
            throw new IOException("File name can not be null.");
        }
        this.zipFile = new ZipFile(archivePath, StandardCharsets.UTF_8);
    }

    public Set<String> getFileNames() {
        HashSet<String> fileNames = new HashSet<String>();
        Enumeration<? extends ZipEntry> entries = this.zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (entry.isDirectory()) continue;
            fileNames.add(entry.getName());
        }
        return fileNames;
    }

    public InputStream readFromZip(String fileName) throws IOException {
        if (fileName == null) {
            throw new IOException("File name can not be null.");
        }
        ZipEntry entry = this.zipFile.getEntry(fileName);
        if (entry == null || entry.isDirectory()) {
            throw new IOException(MessageFormatUtil.format("Zip entry not found for name: {0}", fileName));
        }
        return this.zipFile.getInputStream(entry);
    }

    @Override
    public void close() throws IOException {
        this.zipFile.close();
    }
}

