/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.commons.datastructures;

import com.itextpdf.commons.datastructures.ISimpleList;
import java.util.HashMap;
import java.util.Map;

public final class NullUnlimitedList<T>
implements ISimpleList<T> {
    private final Map<Integer, T> map = new HashMap<Integer, T>();
    private int size = 0;

    @Override
    public void add(T element) {
        if (element == null) {
            ++this.size;
        } else {
            int position = this.size++;
            this.map.put(position, element);
        }
    }

    @Override
    public void add(int index, T element) {
        if (index < 0 || index > this.size) {
            return;
        }
        ++this.size;
        T previous = this.map.get(index);
        for (int i = index + 1; i < this.size; ++i) {
            T currentToAdd = previous;
            previous = this.map.get(i);
            this.set(i, currentToAdd);
        }
        this.set(index, element);
    }

    @Override
    public T get(int index) {
        return this.map.get(index);
    }

    @Override
    public T set(int index, T element) {
        if (element == null) {
            this.map.remove(index);
        } else {
            this.map.put(index, element);
        }
        return element;
    }

    @Override
    public int indexOf(Object element) {
        if (element == null) {
            for (int i = 0; i < this.size; ++i) {
                if (this.map.containsKey(i)) continue;
                return i;
            }
            return -1;
        }
        for (Map.Entry<Integer, T> entry : this.map.entrySet()) {
            if (!element.equals(entry.getValue())) continue;
            return entry.getKey();
        }
        return -1;
    }

    @Override
    public void remove(int index) {
        if (index < 0 || index >= this.size) {
            return;
        }
        this.map.remove(index);
        T previous = this.map.get(this.size - 1);
        int offset = 2;
        for (int i = this.size - 2; i >= index; --i) {
            T current = previous;
            previous = this.map.get(i);
            this.set(i, current);
        }
        this.map.remove(--this.size);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }
}

